/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.AutoIdGenerator;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.IdentityIdGenerator;
import com.github.drinkjava2.jdialects.id.SequenceIdGenerator;
import com.github.drinkjava2.jdialects.id.SortedUUIDGenerator;
import com.github.drinkjava2.jdialects.id.TableIdGenerator;
import com.github.drinkjava2.jdialects.id.TimeStampIdGenerator;
import com.github.drinkjava2.jdialects.id.UUID25Generator;
import com.github.drinkjava2.jdialects.id.UUID32Generator;
import com.github.drinkjava2.jdialects.id.UUID36Generator;
import com.github.drinkjava2.jdialects.id.UUIDAnyGenerator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.IndexModel;
import com.github.drinkjava2.jdialects.model.UniqueModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableModel {
    private String tableName;
    private String check;
    private String comment;
    private String engineTail;
    private List<ColumnModel> columns = new ArrayList<ColumnModel>();
    private List<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
    private List<FKeyModel> fkeyConstraints = new ArrayList<FKeyModel>();
    private List<IndexModel> indexConsts = new ArrayList<IndexModel>();
    private List<UniqueModel> uniqueConsts = new ArrayList<UniqueModel>();
    private Class<?> entityClass;
    private String alias;

    public TableModel() {
    }

    public TableModel(String tableName) {
        this.tableName = tableName;
    }

    public TableModel newCopy() {
        TableModel tb = new TableModel();
        tb.tableName = this.tableName;
        tb.check = this.check;
        tb.comment = this.comment;
        tb.engineTail = this.engineTail;
        if (!this.columns.isEmpty()) {
            for (ColumnModel columnModel : this.columns) {
                ColumnModel newItem = columnModel.newCopy();
                newItem.setTableModel(tb);
                tb.columns.add(newItem);
            }
        }
        if (!this.idGenerators.isEmpty()) {
            for (IdGenerator idGenerator : this.idGenerators) {
                tb.idGenerators.add(idGenerator.newCopy());
            }
        }
        if (!this.fkeyConstraints.isEmpty()) {
            for (FKeyModel fKeyModel : this.fkeyConstraints) {
                tb.fkeyConstraints.add(fKeyModel.newCopy());
            }
        }
        if (!this.indexConsts.isEmpty()) {
            for (IndexModel indexModel : this.indexConsts) {
                tb.indexConsts.add(indexModel.newCopy());
            }
        }
        if (!this.uniqueConsts.isEmpty()) {
            for (UniqueModel uniqueModel : this.uniqueConsts) {
                tb.uniqueConsts.add(uniqueModel.newCopy());
            }
        }
        return tb;
    }

    public void tableGenerator(String name, String tableName, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.addGenerator(new TableIdGenerator(name, tableName, pkColumnName, valueColumnName, pkColumnValue, initialValue, allocationSize));
    }

    public void uuidAny(String name, Integer length) {
        this.addGenerator(new UUIDAnyGenerator(name, length));
    }

    public void addGenerator(IdGenerator generator) {
        DialectException.assureNotNull(generator, new String[0]);
        DialectException.assureNotNull((Object)generator.getGenerationType(), new String[0]);
        DialectException.assureNotEmpty(generator.getIdGenName(), "IdGenerator name can not be empty");
        this.idGenerators.add(generator);
    }

    public void sequenceGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.addGenerator(new SequenceIdGenerator(name, sequenceName, initialValue, allocationSize));
    }

    public void sortedUUIDGenerator(String name, Integer sortedLength, Integer uuidLength) {
        DialectException.assureNotNull(name, new String[0]);
        if (this.getIdGenerator(GenerationType.SORTED_UUID, name) != null) {
            throw new DialectException("Duplicated sortedUUIDGenerator name '" + name + "'");
        }
        this.idGenerators.add(new SortedUUIDGenerator(name, sortedLength, uuidLength));
    }

    public TableModel check(String check) {
        this.check = check;
        return this;
    }

    public TableModel comment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableModel addColumn(ColumnModel column) {
        DialectException.assureNotNull(column, new String[0]);
        DialectException.assureNotEmpty(column.getColumnName(), "Column's columnName can not be empty");
        column.setTableModel(this);
        this.columns.add(column);
        return this;
    }

    public TableModel removeColumn(String columnName) {
        List<ColumnModel> oldColumns = this.getColumns();
        Iterator<ColumnModel> columnIter = oldColumns.iterator();
        while (columnIter.hasNext()) {
            if (!columnIter.next().getColumnName().equalsIgnoreCase(columnName)) continue;
            columnIter.remove();
        }
        return this;
    }

    public TableModel removeFKey(String fkeyName) {
        List<FKeyModel> fkeys = this.getFkeyConstraints();
        Iterator<FKeyModel> fkeyIter = fkeys.iterator();
        while (fkeyIter.hasNext()) {
            if (!fkeyIter.next().getFkeyName().equalsIgnoreCase(fkeyName)) continue;
            fkeyIter.remove();
        }
        return this;
    }

    public ColumnModel column(String columnName) {
        ColumnModel col = this.getColumn(columnName);
        if (col != null) {
            return col;
        }
        return this.addColumn(columnName);
    }

    public ColumnModel addColumn(String columnName) {
        DialectException.assureNotEmpty(columnName, "columnName can not be empty");
        for (ColumnModel columnModel : this.columns) {
            if (!columnName.equals(columnModel.getColumnName())) continue;
            throw new DialectException("ColumnModel name '" + columnName + "' already existed");
        }
        ColumnModel column = new ColumnModel(columnName);
        this.addColumn(column);
        return column;
    }

    public ColumnModel getColumn(String columnName) {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getColumnName() == null || !columnModel.getColumnName().equals(columnName)) continue;
            return columnModel;
        }
        return null;
    }

    public FKeyModel fkey() {
        FKeyModel fkey = new FKeyModel();
        fkey.setTableName(this.tableName);
        this.fkeyConstraints.add(fkey);
        return fkey;
    }

    public FKeyModel fkey(String fkeyName) {
        FKeyModel fkey = new FKeyModel();
        fkey.setTableName(this.tableName);
        fkey.setFkeyName(fkeyName);
        this.fkeyConstraints.add(fkey);
        return fkey;
    }

    public FKeyModel getFkey(String fkeyName) {
        for (FKeyModel fkey : this.fkeyConstraints) {
            if (StrUtils.isEmpty(fkeyName) || !fkeyName.equalsIgnoreCase(fkey.getFkeyName())) continue;
            return fkey;
        }
        return null;
    }

    public IndexModel index() {
        IndexModel index = new IndexModel();
        this.indexConsts.add(index);
        return index;
    }

    public IndexModel index(String indexName) {
        IndexModel index = new IndexModel();
        index.setName(indexName);
        this.indexConsts.add(index);
        return index;
    }

    public UniqueModel unique() {
        UniqueModel unique = new UniqueModel();
        this.uniqueConsts.add(unique);
        return unique;
    }

    public UniqueModel unique(String uniqueName) {
        UniqueModel unique = new UniqueModel();
        unique.setName(uniqueName);
        this.uniqueConsts.add(unique);
        return unique;
    }

    public TableModel engineTail(String engineTail) {
        this.engineTail = engineTail;
        return this;
    }

    public IdGenerator getIdGenerator(GenerationType generationType, String name) {
        return TableModel.getIdGenerator(generationType, name, this.getIdGenerators());
    }

    public IdGenerator getIdGenerator(GenerationType generationType) {
        return TableModel.getIdGeneratorByType(generationType);
    }

    public IdGenerator getIdGenerator(String name) {
        return TableModel.getIdGenerator(null, name, this.getIdGenerators());
    }

    public static IdGenerator getIdGeneratorByType(GenerationType generationType) {
        if (generationType == null) {
            return null;
        }
        switch (generationType) {
            case IDENTITY: {
                return IdentityIdGenerator.INSTANCE;
            }
            case AUTO: {
                return AutoIdGenerator.INSTANCE;
            }
            case UUID25: {
                return UUID25Generator.INSTANCE;
            }
            case UUID32: {
                return UUID32Generator.INSTANCE;
            }
            case UUID36: {
                return UUID36Generator.INSTANCE;
            }
            case TIMESTAMP: {
                return TimeStampIdGenerator.INSTANCE;
            }
        }
        return null;
    }

    public static IdGenerator getIdGenerator(GenerationType generationType, String name, List<IdGenerator> idGeneratorList) {
        IdGenerator idGen = TableModel.getIdGeneratorByType(generationType);
        if (idGen != null) {
            return idGen;
        }
        if (StrUtils.isEmpty(name)) {
            return null;
        }
        for (IdGenerator idGenerator : idGeneratorList) {
            if (generationType != null && name.equalsIgnoreCase(idGenerator.getIdGenName())) {
                return idGenerator;
            }
            if (generationType != null && !GenerationType.OTHER.equals((Object)generationType) || !name.equalsIgnoreCase(idGenerator.getIdGenName())) continue;
            return idGenerator;
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnModel> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnModel> columns) {
        this.columns = columns;
    }

    public List<FKeyModel> getFkeyConstraints() {
        return this.fkeyConstraints;
    }

    public void setFkeyConstraints(List<FKeyModel> fkeyConstraints) {
        this.fkeyConstraints = fkeyConstraints;
    }

    public String getEngineTail() {
        return this.engineTail;
    }

    public void setEngineTail(String engineTail) {
        this.engineTail = engineTail;
    }

    public List<IndexModel> getIndexConsts() {
        return this.indexConsts;
    }

    public void setIndexConsts(List<IndexModel> indexConsts) {
        this.indexConsts = indexConsts;
    }

    public List<UniqueModel> getUniqueConsts() {
        return this.uniqueConsts;
    }

    public void setUniqueConsts(List<UniqueModel> uniqueConsts) {
        this.uniqueConsts = uniqueConsts;
    }

    public List<IdGenerator> getIdGenerators() {
        return this.idGenerators;
    }

    public void setIdGenerators(List<IdGenerator> idGenerators) {
        this.idGenerators = idGenerators;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

