/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbProConfig;
import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdbpro.SpecialSqlItem;
import com.github.drinkjava2.jdbpro.SpecialSqlItemPreparer;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class DbPro
extends ImprovedQueryRunner
implements NormalJdbcTool {
    public DbPro() {
    }

    public DbPro(DataSource ds) {
        super(ds);
    }

    public DbPro(DbProConfig config) {
        this.connectionManager = config.getConnectionManager();
        this.sqlTemplateEngine = config.getTemplateEngine();
        this.allowShowSQL = config.getAllowSqlSql();
        this.logger = config.getLogger();
        this.batchSize = config.getBatchSize();
        this.sqlHandlers = config.getSqlHandlers();
        this.iocTool = config.getIocTool();
        this.slaves = config.getSlaves();
        this.masters = config.getMasters();
        this.masterSlaveOption = config.getMasterSlaveSelect();
        this.specialSqlItemPreparers = config.getSpecialSqlItemPreparers();
    }

    public DbPro(DataSource ds, DbProConfig config) {
        super(ds);
        this.connectionManager = config.getConnectionManager();
        this.sqlTemplateEngine = config.getTemplateEngine();
        this.allowShowSQL = config.getAllowSqlSql();
        this.logger = config.getLogger();
        this.batchSize = config.getBatchSize();
        this.sqlHandlers = config.getSqlHandlers();
        this.iocTool = config.getIocTool();
        this.slaves = config.getSlaves();
        this.masters = config.getMasters();
        this.masterSlaveOption = config.getMasterSlaveSelect();
        this.specialSqlItemPreparers = config.getSpecialSqlItemPreparers();
    }

    public int quiteExecute(String sql, Object ... params) {
        try {
            return this.execute(sql, params);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void ________prepareMethods________() {
    }

    public PreparedSQL iPrepare(Object ... items) {
        return this.doPrepare(true, items);
    }

    public PreparedSQL pPrepare(Object ... items) {
        return this.doPrepare(false, items);
    }

    private PreparedSQL doPrepare(boolean iXxxStyle, Object ... items) {
        PreparedSQL ps = this.realDoPrepare(null, null, iXxxStyle, items);
        ps.addGlobalAndThreadedHandlers(this);
        return ps;
    }

    protected PreparedSQL realDoPrepare(PreparedSQL lastPreSql, StringBuilder lastSqlBuilder, boolean iXxxStyle, Object ... items) {
        StringBuilder sql;
        if (items == null || items.length == 0) {
            throw new DbProRuntimeException("prepareSQL items can not be empty");
        }
        PreparedSQL predSQL = lastPreSql;
        if (predSQL == null) {
            predSQL = new PreparedSQL();
        }
        if ((sql = lastSqlBuilder) == null) {
            sql = new StringBuilder();
        }
        for (Object item : items) {
            if (item == null) {
                if (iXxxStyle) {
                    throw new DbProRuntimeException("In iXxxx style,  null value can not append as SQL piece");
                }
                predSQL.addParam(null);
                continue;
            }
            if (this.dealItem(iXxxStyle, predSQL, sql, item)) continue;
            if (item instanceof SqlItem) {
                throw new DbProRuntimeException("One SqlItem did not find explainer, type=" + (Object)((Object)((SqlItem)item).getType()));
            }
            if (item.getClass().isArray()) {
                this.realDoPrepare(predSQL, sql, iXxxStyle, (Object[])item);
                continue;
            }
            if (iXxxStyle) {
                sql.append(item);
                continue;
            }
            predSQL.addParam(item);
        }
        predSQL.setSql(sql.toString());
        return predSQL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean dealItem(boolean iXxxStyle, PreparedSQL predSQL, StringBuilder sql, Object item) {
        if (item instanceof String) {
            if (iXxxStyle) {
                sql.append(item);
                return true;
            } else if (sql.length() > 0) {
                predSQL.addParam(item);
                return true;
            } else {
                sql.append(item);
            }
            return true;
        } else if (item instanceof PreparedSQL) {
            PreparedSQL psItem = (PreparedSQL)item;
            if (psItem.getSql() != null) {
                sql.append(psItem.getSql());
            }
            if (psItem.getParams() == null) return true;
            for (Object obj : psItem.getParams()) {
                predSQL.addParam(obj);
            }
            return true;
        } else if (item instanceof SqlTemplateEngine) {
            predSQL.setTemplateEngine((SqlTemplateEngine)item);
            return true;
        } else if (item instanceof Map) {
            predSQL.addTemplateMap((Map)item);
            return true;
        } else if (item instanceof SqlOption) {
            if (SqlOption.USE_MASTER.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_MASTER);
                return true;
            } else if (SqlOption.USE_SLAVE.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_SLAVE);
                return true;
            } else if (SqlOption.USE_AUTO.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_AUTO);
                return true;
            } else if (SqlOption.USE_BOTH.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_BOTH);
                return true;
            } else if (SqlOption.USE_TEMPLATE.equals(item)) {
                predSQL.setUseTemplate(true);
                return true;
            } else if (SqlOption.EXECUTE.equals(item)) {
                predSQL.setOperationType(SqlOption.EXECUTE);
                return true;
            } else if (SqlOption.UPDATE.equals(item)) {
                predSQL.setOperationType(SqlOption.UPDATE);
                return true;
            } else if (SqlOption.QUERY.equals(item)) {
                predSQL.setOperationType(SqlOption.QUERY);
                return true;
            } else {
                if (!SqlOption.INSERT.equals(item)) throw new DbProRuntimeException("Un-explained SqlOption:" + item);
                predSQL.setOperationType(SqlOption.INSERT);
            }
            return true;
        } else if (item instanceof SqlItem) {
            SqlItem sqItem = (SqlItem)item;
            SqlOption sqlItemType = sqItem.getType();
            if (SqlOption.IGNORE.equals((Object)sqlItemType)) {
                return true;
            }
            if (SqlOption.PARAM.equals((Object)sqlItemType)) {
                for (Object pm : sqItem.getParameters()) {
                    predSQL.addParam(pm);
                }
                return true;
            } else if (SqlOption.BIND.equals((Object)sqlItemType)) {
                predSQL.addTemplateParam(sqItem);
                return true;
            } else if (SqlOption.SQL.equals((Object)sqlItemType)) {
                for (Object pm : sqItem.getParameters()) {
                    sql.append(pm);
                }
                return true;
            } else if (SqlOption.QUESTION_PARAM.equals((Object)sqlItemType)) {
                int i = 0;
                for (Object pm : sqItem.getParameters()) {
                    predSQL.addParam(pm);
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                    ++i;
                }
                return true;
            } else if (SqlOption.NOT_NULL.equals((Object)sqlItemType)) {
                Object[] args = sqItem.getParameters();
                if (args.length < 2) {
                    throw new DbProRuntimeException("NOT_NULL type SqlItem need at least 2 args");
                }
                if (args[args.length - 1] == null) return true;
                for (int i = 0; i < args.length - 1; ++i) {
                    this.dealItem(true, predSQL, sql, args[i]);
                }
                predSQL.addParam(args[args.length - 1]);
                return true;
            } else if (SqlOption.VALUES_QUESTIONS.equals((Object)sqlItemType)) {
                sql.append(" values(");
                for (int i = 0; i < predSQL.getParamSize(); ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                }
                sql.append(")");
                return true;
            } else if (SqlOption.ENABLE_HANDLERS.equals((Object)sqlItemType)) {
                predSQL.enableAllHandlers();
                return true;
            } else if (SqlOption.DISABLE_HANDLERS.equals((Object)sqlItemType)) {
                predSQL.disableHandlers(sqItem.getParameters());
                return true;
            } else if (SqlOption.SWITCHTO.equals((Object)sqlItemType)) {
                predSQL.setSwitchTo((DbPro)sqItem.getParameters()[0]);
                return true;
            } else {
                if (!SqlOption.IOC.equals((Object)sqlItemType)) return false;
                if (this.getIocTool() == null) {
                    throw new DbProRuntimeException("A IocTool setting required to deal an @Ioc or ioc() method, please read user manual.");
                }
                for (Object claz : sqItem.getParameters()) {
                    Object obj = this.getIocTool().getBean((Class)claz);
                    this.dealItem(iXxxStyle, predSQL, sql, obj);
                }
            }
            return true;
        } else if (item instanceof Connection) {
            predSQL.setConnection((Connection)item);
            return true;
        } else if (item instanceof DbPro) {
            predSQL.setSwitchTo((DbPro)item);
            return true;
        } else if (item instanceof SqlHandler) {
            predSQL.addHandler((SqlHandler)item);
            return true;
        } else if (item instanceof ResultSetHandler) {
            predSQL.setResultSetHandler((ResultSetHandler)item);
            return true;
        } else {
            if (item instanceof Class) {
                throw new DbProRuntimeException("Found a sqlItem is class type :'" + item + "', currently is not allowed.");
            }
            if (!(item instanceof SpecialSqlItem)) return false;
            if (this.specialSqlItemPreparers == null || this.specialSqlItemPreparers.length == 0) {
                throw new DbProRuntimeException("SpecialSqlItem found but no specialSqlItemPreparers be set, please read user manual how to set SpecialSqlItemPreparers");
            }
            for (SpecialSqlItemPreparer spPreparer : this.specialSqlItemPreparers) {
                if (!spPreparer.doPrepare(predSQL, sql, (SpecialSqlItem)item)) continue;
                return true;
            }
            return false;
        }
    }

    public void ________iXxxxStyles________() {
    }

    public <T> T iQuery(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T iQueryForObject(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler((ResultSetHandler<?>)new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long iQueryForLongValue(Object ... inlineSQL) {
        return ((Number)this.iQueryForObject(inlineSQL)).longValue();
    }

    public String iQueryForString(Object ... inlineSQL) {
        return String.valueOf(this.iQueryForObject(inlineSQL));
    }

    public List<Map<String, Object>> iQueryForMapList(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.addHandler((ResultSetHandler)new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public int iUpdate(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T iInsert(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T iExecute(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________pXxxxStyles________() {
    }

    public <T> T pQuery(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T pQueryForObject(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler((ResultSetHandler<?>)new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long pQueryForLongValue(Object ... items) {
        return ((Number)this.pQueryForObject(items)).longValue();
    }

    public String pQueryForString(Object ... items) {
        return String.valueOf(this.pQueryForObject(items));
    }

    public List<Map<String, Object>> pQueryForMapList(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.addHandler((ResultSetHandler)new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public int pUpdate(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T pInsert(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T pExecute(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________tXxxxStyles________() {
    }

    public <T> T tQuery(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T tQueryForObject(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler((ResultSetHandler<?>)new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long tQueryForLongValue(Object ... items) {
        return ((Number)this.tQueryForObject(items)).longValue();
    }

    public String tQueryForString(Object ... items) {
        return String.valueOf(this.tQueryForObject(items));
    }

    public List<Map<String, Object>> tQueryForMapList(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.addHandler((ResultSetHandler)new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public int tUpdate(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T tInsert(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T tExecute(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________nXxxxStyles________() {
    }

    public <T> T nQuery(Connection conn, ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, conn, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T nQueryForObject(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, conn, (ResultSetHandler<?>)SingleTonHandlers.scalarHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public String nQueryForString(Connection conn, String sql, Object ... params) {
        return (String)this.nQueryForObject(conn, sql, params);
    }

    public long nQueryForLongValue(Connection conn, String sql, Object ... params) {
        return ((Number)this.nQueryForObject(conn, sql, params)).longValue();
    }

    public List<Map<String, Object>> nQueryForMapList(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, conn, (ResultSetHandler<?>)SingleTonHandlers.mapListHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }

    public int nUpdate(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.UPDATE, conn, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T nInsert(Connection conn, ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.INSERT, conn, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public int nExecute(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, conn, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> List<T> nExecute(Connection conn, ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, conn, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }

    public <T> T nQuery(ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    @Override
    public <T> T nQueryForObject(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, (ResultSetHandler<?>)SingleTonHandlers.scalarHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public String nQueryForString(String sql, Object ... params) {
        return String.valueOf(this.nQueryForObject(sql, params));
    }

    public long nQueryForLongValue(String sql, Object ... params) {
        return ((Number)this.nQueryForObject(sql, params)).longValue();
    }

    public List<Map<String, Object>> nQueryForMapList(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, (ResultSetHandler<?>)SingleTonHandlers.mapListHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }

    @Override
    public int nUpdate(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.UPDATE, null, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T nInsert(ResultSetHandler rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.INSERT, null, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    @Override
    public int nExecute(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, null, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> List<T> nExecute(ResultSetHandler rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, null, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }
}

