/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProConfig;
import com.github.drinkjava2.jdbpro.DbProLogger;
import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdbpro.IocTool;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SpecialSqlItemPreparer;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import com.github.drinkjava2.jtransactions.ConnectionManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ImprovedQueryRunner
extends QueryRunner {
    protected SqlTemplateEngine sqlTemplateEngine = DbProConfig.globalNextTemplateEngine;
    protected ConnectionManager connectionManager = DbProConfig.globalNextConnectionManager;
    protected Boolean allowShowSQL = DbProConfig.globalNextAllowShowSql;
    protected SqlOption masterSlaveOption = DbProConfig.globalNextMasterSlaveOption;
    protected DbProLogger logger = DbProConfig.globalNextLogger;
    protected Integer batchSize = DbProConfig.globalNextBatchSize;
    protected SqlHandler[] sqlHandlers = DbProConfig.globalNextSqlHandlers;
    protected SpecialSqlItemPreparer[] specialSqlItemPreparers = DbProConfig.globalNextSpecialSqlItemPreparers;
    protected DbPro[] slaves;
    protected DbPro[] masters;
    protected String name;
    protected IocTool iocTool = DbProConfig.globalNextIocTool;
    private static ThreadLocal<SqlHandler[]> threadLocalSqlHandlers = new ThreadLocal();
    private ThreadLocal<Boolean> batchEnabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<ArrayList<PreparedSQL>> sqlBatchCache = new ThreadLocal<ArrayList<PreparedSQL>>(){

        @Override
        protected ArrayList<PreparedSQL> initialValue() {
            return new ArrayList<PreparedSQL>();
        }
    };

    public ImprovedQueryRunner() {
    }

    public ImprovedQueryRunner(DataSource ds) {
        super(ds);
    }

    public ImprovedQueryRunner(DataSource ds, ConnectionManager cm) {
        super(ds);
        this.connectionManager = cm;
    }

    public void close(Connection conn) throws SQLException {
        if (this.connectionManager == null) {
            super.close(conn);
        } else {
            this.connectionManager.releaseConnection(conn, this.getDataSource());
        }
    }

    public Connection prepareConnection() throws SQLException {
        if (this.connectionManager == null) {
            return super.prepareConnection();
        }
        return this.connectionManager.getConnection(this.getDataSource());
    }

    protected CallableStatement prepareCall(Connection conn, String sql) throws SQLException {
        if (this.getAllowShowSQL().booleanValue() && !this.batchEnabled.get().booleanValue()) {
            this.logger.info("SQL: " + sql);
        }
        return super.prepareCall(conn, sql);
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        if (this.getAllowShowSQL().booleanValue() && !this.batchEnabled.get().booleanValue()) {
            this.logger.info(this.formatSqlForLoggerOutput(sql));
        }
        return super.prepareStatement(conn, sql);
    }

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        if (this.getAllowShowSQL().booleanValue() && !this.batchEnabled.get().booleanValue()) {
            this.logger.info(this.formatParametersForLoggerOutput(params));
        }
        super.fillStatement(stmt, params);
    }

    protected String formatSqlForLoggerOutput(String sql) {
        return "SQL: " + sql;
    }

    protected String formatParametersForLoggerOutput(Object ... params) {
        return "PAR: " + Arrays.deepToString(params);
    }

    private <T> T addToCacheIfFullFlush(PreparedSQL ps) {
        PreparedSQL last;
        if (ps == null) {
            throw new DbProRuntimeException("PreparedSQL can not be null.");
        }
        Integer result = null;
        List cached = this.sqlBatchCache.get();
        if (cached.size() >= this.batchSize) {
            result = (Integer)this.nBatchFlush();
        } else if (!(cached.isEmpty() || (last = (PreparedSQL)cached.get(cached.size() - 1)).getOperationType().equals((Object)ps.getOperationType()) && last.getConnection() == ps.getConnection() && last.getSql().equals(ps.getSql()) && last.getParamSize() == ps.getParamSize() && last.getResultSetHandler() == ps.getResultSetHandler())) {
            result = this.nBatchFlush();
        }
        this.sqlBatchCache.get().add(ps);
        switch (ps.getOperationType()) {
            case UPDATE: 
            case EXECUTE: {
                result = 0;
                break;
            }
            case INSERT: {
                result = null;
                break;
            }
            default: {
                throw new DbProRuntimeException("Unknow batch sql operation type:" + (Object)((Object)ps.getOperationType()));
            }
        }
        return (T)result;
    }

    public <T> T nBatchFlush() {
        List psList = this.sqlBatchCache.get();
        if (psList.isEmpty()) {
            return null;
        }
        Object result = null;
        PreparedSQL first = (PreparedSQL)psList.get(0);
        int paramLenth = first.getParamSize();
        Object[][] allParams = new Object[psList.size()][paramLenth];
        if (paramLenth > 0) {
            for (int i = 0; i < psList.size(); ++i) {
                allParams[i] = ((PreparedSQL)psList.get(i)).getParams();
            }
        }
        if (this.getAllowShowSQL().booleanValue()) {
            this.logger.info("Batch execute " + psList.size() + " SQLs");
            this.logger.info(this.formatSqlForLoggerOutput(first.getSql()));
            this.logger.info("First row " + this.formatParametersForLoggerOutput(allParams[0]));
            this.logger.info("Last row " + this.formatParametersForLoggerOutput(allParams[allParams.length - 1]));
        }
        if (this.batchEnabled.get().booleanValue()) {
            switch (first.getOperationType()) {
                case UPDATE: 
                case EXECUTE: {
                    try {
                        if (first.getConnection() != null) {
                            result = this.batch(first.getConnection(), first.getSql(), allParams).length;
                            break;
                        }
                        result = this.batch(first.getSql(), allParams).length;
                        break;
                    }
                    catch (SQLException e) {
                        throw new DbProRuntimeException(e);
                    }
                }
                case INSERT: {
                    if (first.getResultSetHandler() == null) {
                        throw new DbProRuntimeException("insertBatch need a ResultSetHandler.");
                    }
                    try {
                        if (first.getConnection() != null) {
                            result = this.insertBatch(first.getConnection(), first.getSql(), first.getResultSetHandler(), allParams);
                            break;
                        }
                        result = this.insertBatch(first.getSql(), first.getResultSetHandler(), allParams);
                        break;
                    }
                    catch (SQLException e) {
                        throw new DbProRuntimeException(e);
                    }
                }
                default: {
                    throw new DbProRuntimeException("Unknow batch sql operation type:" + (Object)((Object)first.getOperationType()));
                }
            }
        }
        this.sqlBatchCache.get().clear();
        return (T)result;
    }

    public void nBatchBegin() {
        if (!this.sqlBatchCache.get().isEmpty()) {
            this.nBatchFlush();
        }
        this.batchEnabled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nBatchEnd() {
        try {
            if (!this.sqlBatchCache.get().isEmpty()) {
                this.nBatchFlush();
            }
        }
        finally {
            this.batchEnabled.set(false);
        }
    }

    public <T> T queryForObject(Connection conn, String sql, Object ... params) throws SQLException {
        return (T)this.query(conn, sql, (ResultSetHandler)new ScalarHandler(1), params);
    }

    public <T> T queryForObject(String sql, Object ... params) throws SQLException {
        return (T)this.query(sql, (ResultSetHandler)new ScalarHandler(1), params);
    }

    public Object runPreparedSQL(PreparedSQL ps) {
        if (ps.getSwitchTo() != null) {
            DbPro pro = ps.getSwitchTo();
            ps.setSwitchTo(null);
            return pro.runPreparedSQL(ps);
        }
        if (ps.getMasterSlaveOption() == null) {
            ps.setMasterSlaveOption(this.getMasterSlaveOption());
        }
        if (ps.getUseTemplate() != null && ps.getUseTemplate().booleanValue()) {
            ps.setUseTemplate(false);
            SqlTemplateEngine engine = ps.getTemplateEngine();
            if (engine == null) {
                engine = this.sqlTemplateEngine;
            }
            PreparedSQL rendered = engine.render(ps.getSql(), ps.getTemplateParamMap(), ps.getParams());
            ps.setSql(rendered.getSql());
            ps.setParams(rendered.getParams());
        }
        while (ps.getSqlHandlers() != null && !ps.getSqlHandlers().isEmpty()) {
            SqlHandler handler = ps.getSqlHandlers().get(0);
            ps.getSqlHandlers().remove(0);
            if (ps.isDisabledHandler(handler)) continue;
            return handler.handle(this, ps);
        }
        return this.runRealSqlMethod(ps);
    }

    public Object runRealSqlMethod(PreparedSQL ps) {
        if (ps.getOperationType() == null) {
            throw new DbProRuntimeException("PreparedSQL's type not set");
        }
        if (this.batchEnabled.get().booleanValue()) {
            switch (ps.getOperationType()) {
                case UPDATE: 
                case EXECUTE: 
                case INSERT: {
                    return this.addToCacheIfFullFlush(ps);
                }
            }
        }
        switch (ps.getOperationType()) {
            case UPDATE: 
            case EXECUTE: 
            case INSERT: {
                if (SqlOption.USE_MASTER.equals((Object)ps.getMasterSlaveOption()) || SqlOption.USE_AUTO.equals((Object)ps.getMasterSlaveOption())) {
                    return this.runWriteOperations(this, ps);
                }
                if (SqlOption.USE_BOTH.equals((Object)ps.getMasterSlaveOption())) {
                    if (this.getSlaves() != null) {
                        for (DbPro dbPro : this.getSlaves()) {
                            this.runWriteOperations(dbPro, ps);
                        }
                    }
                    return this.runWriteOperations(this, ps);
                }
                if (SqlOption.USE_SLAVE.equals((Object)ps.getMasterSlaveOption())) {
                    Object result = null;
                    if (this.getSlaves() == null || this.getSlaves().length == 0) {
                        throw new DbProRuntimeException("Try to write slaves but slave list not found");
                    }
                    for (DbPro dbPro : this.getSlaves()) {
                        result = this.runWriteOperations(dbPro, ps);
                    }
                    return result;
                }
                throw new DbProRuntimeException("Should never run to here");
            }
            case QUERY: {
                if (SqlOption.USE_MASTER.equals((Object)ps.getMasterSlaveOption()) || SqlOption.USE_BOTH.equals((Object)ps.getMasterSlaveOption())) {
                    return this.runQuery(ps);
                }
                if (SqlOption.USE_SLAVE.equals((Object)ps.getMasterSlaveOption())) {
                    DbPro db = this.chooseOneSlave();
                    if (db == null) {
                        throw new DbProRuntimeException("Try to query on slave but slave list not found");
                    }
                    return db.runQuery(ps);
                }
                if (SqlOption.USE_AUTO.equals((Object)ps.getMasterSlaveOption())) {
                    DbPro db = this.autoChooseMasterOrSlaveQuery(ps);
                    return db.runQuery(ps);
                }
                throw new DbProRuntimeException("Should never run to here");
            }
        }
        throw new DbProRuntimeException("Unknow SQL operation type " + (Object)((Object)ps.getOperationType()));
    }

    private Object runReadOperation(PreparedSQL ps) {
        if (SqlOption.USE_MASTER.equals((Object)ps.getMasterSlaveOption()) || SqlOption.USE_BOTH.equals((Object)ps.getMasterSlaveOption())) {
            return this.runQuery(ps);
        }
        if (SqlOption.USE_SLAVE.equals((Object)ps.getMasterSlaveOption())) {
            DbPro db = this.chooseOneSlave();
            if (db == null) {
                throw new DbProRuntimeException("Try to run a slave DbPro but slave list is null or empty");
            }
            return db.runQuery(ps);
        }
        if (SqlOption.USE_AUTO.equals((Object)ps.getMasterSlaveOption())) {
            DbPro db = this.autoChooseMasterOrSlaveQuery(ps);
            return db.runQuery(ps);
        }
        throw new DbProRuntimeException("masterSlaveSelect property not set.");
    }

    private Object runWriteOperations(ImprovedQueryRunner dbPro, PreparedSQL ps) {
        switch (ps.getOperationType()) {
            case INSERT: {
                return dbPro.runInsert(ps);
            }
            case EXECUTE: {
                return dbPro.runExecute(ps);
            }
            case UPDATE: {
                return dbPro.runUpdate(ps);
            }
        }
        throw new DbProRuntimeException("Should never run to here");
    }

    protected <T> T runQuery(PreparedSQL ps) {
        if (ps.getResultSetHandler() != null) {
            try {
                if (ps.getConnection() != null) {
                    if (ps.getParams() != null) {
                        return (T)this.query(ps.getConnection(), ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                    }
                    return (T)this.query(ps.getConnection(), ps.getSql(), ps.getResultSetHandler());
                }
                if (ps.getParams() != null) {
                    return (T)this.query(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                }
                return (T)this.query(ps.getSql(), ps.getResultSetHandler());
            }
            catch (SQLException e) {
                throw new DbProRuntimeException(e);
            }
        }
        throw new DbProRuntimeException("A ResultSetHandler is required by query method");
    }

    private DbPro autoChooseMasterOrSlaveQuery(PreparedSQL ps) {
        if (this.getSlaves() == null || this.getSlaves().length == 0 || this.getConnectionManager() != null && this.getConnectionManager().isInTransaction(this.getDataSource())) {
            return (DbPro)this;
        }
        DbPro slave = this.chooseOneSlave();
        if (slave == null) {
            throw new DbProRuntimeException("Try to run a slave DbPro but slave list is null or empty");
        }
        return slave;
    }

    private <T> T runMasterQuery(PreparedSQL ps) throws SQLException {
        if (ps.getParams() != null) {
            return (T)this.query(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
        }
        return (T)this.query(ps.getSql(), ps.getResultSetHandler());
    }

    private DbPro chooseOneSlave() {
        if (this.slaves == null || this.slaves.length == 0) {
            return null;
        }
        return this.slaves[new Random().nextInt(this.slaves.length)];
    }

    protected <T> T runInsert(PreparedSQL ps) {
        if (ps.getResultSetHandler() != null) {
            try {
                if (ps.getConnection() != null) {
                    if (ps.getParams() != null) {
                        return (T)this.insert(ps.getConnection(), ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                    }
                    return (T)this.insert(ps.getConnection(), ps.getSql(), ps.getResultSetHandler());
                }
                if (ps.getParams() != null) {
                    return (T)this.insert(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                }
                return (T)this.insert(ps.getSql(), ps.getResultSetHandler());
            }
            catch (SQLException e) {
                throw new DbProRuntimeException(e);
            }
        }
        throw new DbProRuntimeException("A ResultSetHandler is required by insert method");
    }

    protected <T> T runExecute(PreparedSQL ps) {
        try {
            if (ps.getResultSetHandler() != null) {
                if (ps.getConnection() != null) {
                    return (T)this.execute(ps.getConnection(), ps.getSql(), ps.getResultSetHandler(), ps.getParams());
                }
                return (T)this.execute(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
            }
            if (ps.getConnection() != null) {
                return (T)Integer.valueOf(this.execute(ps.getConnection(), ps.getSql(), ps.getParams()));
            }
            return (T)Integer.valueOf(this.execute(ps.getSql(), ps.getParams()));
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    protected int runUpdate(PreparedSQL ps) {
        try {
            if (ps.getResultSetHandler() != null) {
                // empty if block
            }
            if (ps.getConnection() != null) {
                if (ps.getParams() != null) {
                    return this.update(ps.getConnection(), ps.getSql(), ps.getParams());
                }
                return this.update(ps.getConnection(), ps.getSql());
            }
            if (ps.getParams() != null) {
                return this.update(ps.getSql(), ps.getParams());
            }
            return this.update(ps.getSql());
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    private <T> T runQueryForScalar(PreparedSQL ps) {
        try {
            if (ps.getResultSetHandler() == null) {
                return (T)this.query(ps.getSql(), (ResultSetHandler)new ScalarHandler(1), ps.getParams());
            }
            return (T)this.query(ps.getSql(), ps.getResultSetHandler(), ps.getParams());
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    public int[] nBatch(String sql, List<Object[]> params) {
        try {
            return this.batch(sql, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    public int[] nBatch(Connection conn, String sql, List<Object[]> params) throws SQLException {
        try {
            return this.batch(conn, sql, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    public <T> T nInsertBatch(String sql, ResultSetHandler<T> rsh, List<Object[]> params) {
        try {
            return (T)this.insertBatch(sql, rsh, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    public <T> T nInsertBatch(Connection conn, String sql, ResultSetHandler<T> rsh, List<Object[]> params) {
        try {
            return (T)this.insertBatch(conn, sql, rsh, ImprovedQueryRunner.objectsListToArray2D(params));
        }
        catch (SQLException e) {
            throw new DbProRuntimeException(e);
        }
    }

    private void specialStaticMethods_____________________() {
    }

    public static Object[][] listListToArray2D(List<List<?>> paramList) {
        Object[][] array = new Object[paramList.size()][];
        int i = 0;
        for (List<?> item : paramList) {
            array[i++] = item.toArray(new Object[item.size()]);
        }
        return array;
    }

    public static Object[][] objectsListToArray2D(List<Object[]> paramList) {
        Object[][] array = new Object[paramList.size()][];
        int i = 0;
        for (Object[] item : paramList) {
            array[i++] = item;
        }
        return array;
    }

    public static SqlHandler[] getThreadLocalSqlHandlers() {
        return threadLocalSqlHandlers.get();
    }

    public static void setThreadLocalSqlHandlers(SqlHandler ... handlers) {
        threadLocalSqlHandlers.set(handlers);
    }

    private void normalGetterSetters_____________________() {
    }

    public Boolean getAllowShowSQL() {
        return this.allowShowSQL;
    }

    @Deprecated
    public void setAllowShowSQL(Boolean allowShowSQL) {
        this.allowShowSQL = allowShowSQL;
    }

    public SqlTemplateEngine getSqlTemplateEngine() {
        return this.sqlTemplateEngine;
    }

    @Deprecated
    public void setSqlTemplateEngine(SqlTemplateEngine sqlTemplateEngine) {
        this.sqlTemplateEngine = sqlTemplateEngine;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Deprecated
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public DbProLogger getLogger() {
        return this.logger;
    }

    @Deprecated
    public void setLogger(DbProLogger logger) {
        this.logger = logger;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Deprecated
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public SqlHandler[] getSqlHandlers() {
        return this.sqlHandlers;
    }

    @Deprecated
    public void setSqlHandlers(SqlHandler[] sqlHandlers) {
        this.sqlHandlers = sqlHandlers;
    }

    public SpecialSqlItemPreparer[] getSpecialSqlItemPreparers() {
        return this.specialSqlItemPreparers;
    }

    @Deprecated
    public void setSpecialSqlItemPreparers(SpecialSqlItemPreparer[] specialSqlItemPreparers) {
        this.specialSqlItemPreparers = specialSqlItemPreparers;
    }

    @Deprecated
    public void addSpecialSqlItemPreparer(SpecialSqlItemPreparer specialSqlItemPreparer) {
        if (this.specialSqlItemPreparers == null || this.specialSqlItemPreparers.length == 0) {
            this.specialSqlItemPreparers = new SpecialSqlItemPreparer[]{specialSqlItemPreparer};
        } else {
            SpecialSqlItemPreparer[] newArray = new SpecialSqlItemPreparer[this.specialSqlItemPreparers.length + 1];
            System.arraycopy(this.specialSqlItemPreparers, 0, newArray, 0, this.specialSqlItemPreparers.length);
            newArray[this.specialSqlItemPreparers.length] = specialSqlItemPreparer;
            this.specialSqlItemPreparers = newArray;
        }
    }

    public DbPro[] getSlaves() {
        return this.slaves;
    }

    @Deprecated
    public void setSlaves(DbPro[] slaves) {
        this.slaves = slaves;
    }

    public DbPro[] getMasters() {
        return this.masters;
    }

    @Deprecated
    public void setMasters(DbPro[] masters) {
        this.masters = masters;
    }

    public IocTool getIocTool() {
        return this.iocTool;
    }

    @Deprecated
    public void setIocTool(IocTool iocTool) {
        this.iocTool = iocTool;
    }

    public SqlOption getMasterSlaveOption() {
        return this.masterSlaveOption;
    }

    @Deprecated
    public void setMasterSlaveOption(SqlOption masterSlaveOption) {
        this.masterSlaveOption = masterSlaveOption;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBatchEnabled() {
        return this.batchEnabled.get();
    }

    public ThreadLocal<ArrayList<PreparedSQL>> getSqlBatchCache() {
        return this.sqlBatchCache;
    }
}

