/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public class PreparedSQL {
    private SqlOption operationType;
    private SqlOption masterSlaveOption;
    private DbPro switchTo;
    private Connection connection;
    private String sql;
    private Object[] params;
    private Boolean useTemplate = null;
    private SqlTemplateEngine templateEngine;
    private Map<String, Object> templateParamMap;
    private List<SqlHandler> sqlHandlers;
    private ResultSetHandler<?> resultSetHandler;
    private List<Class<?>> disabledHandlers;
    private Object[] models;
    private List<String[]> givesList = null;

    public PreparedSQL() {
    }

    public PreparedSQL(SqlOption type, Connection conn, ResultSetHandler<?> rsh, String sql, Object ... params) {
        this.operationType = type;
        this.connection = conn;
        this.resultSetHandler = rsh;
        this.sql = sql;
        this.params = params;
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\ntype=").append((Object)this.operationType);
        sb.append("\nsql=").append(this.sql);
        sb.append("\nparams=").append(Arrays.deepToString(this.params));
        sb.append("\nmasterSlaveSelect=").append((Object)this.masterSlaveOption);
        sb.append("\nconnection=").append(this.connection);
        sb.append("\nresultSetHandler=").append(this.resultSetHandler);
        sb.append("\nsqlHandlers=").append(this.sqlHandlers);
        sb.append("\nuseTemplate=").append(this.useTemplate);
        sb.append("\ntemplateEngine=").append(this.templateEngine);
        sb.append("\ntemplateParams=").append(this.templateParamMap);
        sb.append("\ndisabledHandlers=").append(this.disabledHandlers);
        sb.append("\nmasterSlaveOption=").append((Object)this.masterSlaveOption);
        sb.append("\n");
        return sb.toString();
    }

    public void addParam(Object param) {
        if (this.params == null) {
            this.params = new Object[1];
        } else {
            Object[] newParams = new Object[this.params.length + 1];
            System.arraycopy(this.params, 0, newParams, 0, this.params.length);
            this.params = newParams;
        }
        this.params[this.params.length - 1] = param;
    }

    public void addModel(Object model) {
        if (this.models == null) {
            this.models = new Object[1];
        } else {
            Object[] newModels = new Object[this.models.length + 1];
            System.arraycopy(this.models, 0, newModels, 0, this.models.length);
            this.models = newModels;
        }
        this.models[this.models.length - 1] = model;
    }

    public void addGives(String[] gives) {
        if (this.givesList == null) {
            this.givesList = new ArrayList<String[]>();
        }
        if (gives == null || gives.length < 2) {
            throw new DbProRuntimeException("addGives at least need 2 alias parameters");
        }
        this.givesList.add(gives);
    }

    public void addTemplateMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        if (this.templateParamMap == null) {
            this.templateParamMap = new HashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.templateParamMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void addTemplateParam(SqlItem sp) {
        if (sp.getParameters() == null || sp.getParameters().length % 2 != 0) {
            throw new DbProRuntimeException("Put type template parameter should be key1, value1, key2,value2... format");
        }
        if (this.templateParamMap == null) {
            this.templateParamMap = new HashMap<String, Object>();
        }
        for (int i = 1; i <= sp.getParameters().length / 2; ++i) {
            this.templateParamMap.put((String)sp.getParameters()[(i - 1) * 2], sp.getParameters()[(i - 1) * 2 + 1]);
        }
    }

    public void addSqlHandler(SqlHandler sqlHandler) {
        if (this.sqlHandlers == null) {
            this.sqlHandlers = new ArrayList<SqlHandler>();
        }
        for (int i = this.sqlHandlers.size() - 1; i >= 0; --i) {
            if (this.sqlHandlers.get(i).getOrder() > sqlHandler.getOrder()) continue;
            this.sqlHandlers.add(i + 1, sqlHandler);
            return;
        }
        this.sqlHandlers.add(sqlHandler);
    }

    public void disableHandlers(Object[] handlersClass) {
        if (handlersClass == null || handlersClass.length == 0) {
            throw new DbProRuntimeException("disableHandlers method need at least 1 parameter");
        }
        if (this.disabledHandlers == null) {
            this.disabledHandlers = new ArrayList();
        }
        for (Object obj : handlersClass) {
            this.disabledHandlers.add((Class)obj);
        }
    }

    public boolean isDisabledHandler(Object handler) {
        if (this.disabledHandlers == null || this.disabledHandlers.isEmpty()) {
            return false;
        }
        for (Class<?> disabled : this.disabledHandlers) {
            if (!disabled.equals(handler.getClass())) continue;
            return true;
        }
        return false;
    }

    public void enableAllHandlers() {
        this.disabledHandlers = null;
    }

    public int getParamSize() {
        if (this.params == null) {
            return 0;
        }
        return this.params.length;
    }

    public void setResultSetHandler(ResultSetHandler<?> rsh) {
        if (this.resultSetHandler != null) {
            throw new DbProRuntimeException("ResultSetHandler already exist and can only set 1, need use changeResultSetHandler method.");
        }
        this.resultSetHandler = rsh;
    }

    public void changeResultSetHandler(ResultSetHandler<?> rsh) {
        this.resultSetHandler = rsh;
    }

    public void addHandler(ResultSetHandler handler) {
        this.setResultSetHandler(handler);
    }

    public void addHandler(SqlHandler handler) {
        this.addSqlHandler(handler);
    }

    public void addNoParamHandlerByClass(Class handlerClass) {
        block5: {
            if (handlerClass == null) {
                throw new DbProRuntimeException("HandlerClass can not be null");
            }
            try {
                if (ResultSetHandler.class.isAssignableFrom(handlerClass)) {
                    this.setResultSetHandler((ResultSetHandler)handlerClass.newInstance());
                    break block5;
                }
                if (SqlHandler.class.isAssignableFrom(handlerClass)) {
                    this.addSqlHandler((SqlHandler)handlerClass.newInstance());
                    break block5;
                }
                throw new DbProRuntimeException("ResultSetHandler class or SqlHandler class required");
            }
            catch (Exception e) {
                throw new DbProRuntimeException(e);
            }
        }
    }

    public Object[] getParams() {
        if (this.params == null) {
            return new Object[0];
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalAndThreadedHandlers(ImprovedQueryRunner dbPro) {
        if (dbPro.getSqlHandlers() != null) {
            for (SqlHandler handler : dbPro.getSqlHandlers()) {
                this.addSqlHandler(handler);
            }
        }
        if (ImprovedQueryRunner.getThreadLocalSqlHandlers() != null) {
            try {
                for (SqlHandler handler : ImprovedQueryRunner.getThreadLocalSqlHandlers()) {
                    this.addSqlHandler(handler);
                }
            }
            finally {
                ImprovedQueryRunner.setThreadLocalSqlHandlers(null);
            }
        }
    }

    public void ifNullSetType(SqlOption type) {
        if (this.operationType == null) {
            this.operationType = type;
        }
    }

    public void ifNullSetUseTemplate(Boolean useTemplate) {
        if (this.useTemplate == null) {
            this.useTemplate = useTemplate;
        }
    }

    protected void GetterSetters_________________________() {
    }

    public SqlOption getOperationType() {
        return this.operationType;
    }

    public void setOperationType(SqlOption operationType) {
        this.operationType = operationType;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Boolean getUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(Boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public SqlTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(SqlTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Map<String, Object> getTemplateParamMap() {
        if (this.templateParamMap == null) {
            return new HashMap<String, Object>();
        }
        return this.templateParamMap;
    }

    public void setTemplateParamMap(Map<String, Object> templateParamMap) {
        this.templateParamMap = templateParamMap;
    }

    public List<SqlHandler> getSqlHandlers() {
        return this.sqlHandlers;
    }

    public void setSqlHandlers(List<SqlHandler> sqlHandlers) {
        this.sqlHandlers = sqlHandlers;
    }

    public ResultSetHandler<?> getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public void setMasterSlaveOption(SqlOption masterSlaveOption) {
        this.masterSlaveOption = masterSlaveOption;
    }

    public DbPro getSwitchTo() {
        return this.switchTo;
    }

    public void setSwitchTo(DbPro switchTo) {
        this.switchTo = switchTo;
    }

    public SqlOption getMasterSlaveOption() {
        return this.masterSlaveOption;
    }

    public List<Class<?>> getDisabledHandlers() {
        return this.disabledHandlers;
    }

    public void setDisabledHandlers(List<Class<?>> disabledHandlers) {
        this.disabledHandlers = disabledHandlers;
    }

    public Object[] getModels() {
        return this.models;
    }

    public void setModels(Object[] models) {
        this.models = models;
    }

    public List<String[]> getGivesList() {
        return this.givesList;
    }

    public void setGivesList(List<String[]> givesList) {
        this.givesList = givesList;
    }
}

