/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleCacheHandler
extends DefaultOrderSqlHandler {
    private Map<String, Object> cache;
    private int aliveSeconds = 1000;
    private int capacity = 500;

    public SimpleCacheHandler() {
        this.cache = Collections.synchronizedMap(new LRULinkedHashMap(this.capacity));
    }

    public int getAliveSeconds() {
        return this.aliveSeconds;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public SimpleCacheHandler(int capacity, int aliveSeconds) {
        this.aliveSeconds = aliveSeconds <= 1 ? 1 : (aliveSeconds <= 10 ? 10 : (aliveSeconds <= 100 ? 100 : (aliveSeconds <= 1000 ? 1000 : (aliveSeconds <= 10000 ? 10000 : 100000))));
        this.capacity = capacity;
        this.cache = Collections.synchronizedMap(new LRULinkedHashMap(capacity));
    }

    public void clearCache() {
        this.cache.clear();
    }

    private String createKey(PreparedSQL ps) {
        return Long.toString(System.currentTimeMillis() / 1000L / (long)this.aliveSeconds) + "SQL:" + ps.getSql() + "  Params:" + ps.getParams();
    }

    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        String key = this.createKey(ps);
        Object result = this.cache.get(key);
        if (result != null) {
            return ((Object[])result)[1];
        }
        result = runner.runPreparedSQL(ps);
        this.cache.put(key, new Object[]{null, result});
        return result;
    }

    public static class LRULinkedHashMap
    extends LinkedHashMap<String, Object> {
        private int capacity;

        LRULinkedHashMap(int capacity) {
            super(16, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            return this.size() > this.capacity;
        }
    }
}

