/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.CommonDialect;
import com.github.drinkjava2.jdialects.DDLCreateUtils;
import com.github.drinkjava2.jdialects.DDLDropUtils;
import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.DialectFunctionTemplate;
import com.github.drinkjava2.jdialects.DialectFunctionTranslator;
import com.github.drinkjava2.jdialects.DialectLogger;
import com.github.drinkjava2.jdialects.DialectPaginationTemplate;
import com.github.drinkjava2.jdialects.DialectTypeMappingTemplate;
import com.github.drinkjava2.jdialects.GuessDialectUtils;
import com.github.drinkjava2.jdialects.ReservedDBWords;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.hibernatesrc.pagination.RowSelection;
import com.github.drinkjava2.jdialects.hibernatesrc.pagination.SQLServer2005LimitHandler;
import com.github.drinkjava2.jdialects.hibernatesrc.pagination.SQLServer2012LimitHandler;
import com.github.drinkjava2.jdialects.hibernatesrc.utils.StringHelper;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.sql.Connection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public enum Dialect implements CommonDialect
{
    SQLiteDialect,
    AccessDialect,
    ExcelDialect,
    TextDialect,
    ParadoxDialect,
    CobolDialect,
    XMLDialect,
    DbfDialect,
    DerbyDialect,
    OracleDialect,
    Oracle9Dialect,
    Cache71Dialect,
    CUBRIDDialect,
    DerbyTenFiveDialect,
    DataDirectOracle9Dialect,
    DB2Dialect,
    DB2390Dialect,
    DB2400Dialect,
    DerbyTenSevenDialect,
    DerbyTenSixDialect,
    FirebirdDialect,
    FrontBaseDialect,
    H2Dialect,
    HANAColumnStoreDialect,
    HANARowStoreDialect,
    HSQLDialect,
    InformixDialect,
    Informix10Dialect,
    IngresDialect,
    Ingres10Dialect,
    Ingres9Dialect,
    InterbaseDialect,
    JDataStoreDialect,
    MariaDBDialect,
    MariaDB53Dialect,
    MckoiDialect,
    MimerSQLDialect,
    MySQLDialect,
    MySQL5Dialect,
    MySQL55Dialect,
    MySQL57Dialect,
    MySQL57InnoDBDialect,
    MySQL5InnoDBDialect,
    MySQLInnoDBDialect,
    MySQLMyISAMDialect,
    Oracle8iDialect,
    Oracle9iDialect,
    Oracle10gDialect,
    Oracle12cDialect,
    PointbaseDialect,
    PostgresPlusDialect,
    PostgreSQLDialect,
    PostgreSQL81Dialect,
    PostgreSQL82Dialect,
    PostgreSQL9Dialect,
    PostgreSQL91Dialect,
    PostgreSQL92Dialect,
    PostgreSQL93Dialect,
    PostgreSQL94Dialect,
    PostgreSQL95Dialect,
    ProgressDialect,
    RDMSOS2200Dialect,
    SAPDBDialect,
    SQLServerDialect,
    SQLServer2005Dialect,
    SQLServer2008Dialect,
    SQLServer2012Dialect,
    SybaseDialect,
    Sybase11Dialect,
    SybaseAnywhereDialect,
    SybaseASE15Dialect,
    SybaseASE157Dialect,
    TeradataDialect,
    Teradata14Dialect,
    TimesTenDialect;

    private static Boolean globalAllowReservedWords;
    private static Boolean globalAllowShowSql;
    private static String globalSqlFunctionPrefix;
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    private static final String SKIP_ROWS = "$SKIP_ROWS";
    private static final String PAGESIZE = "$PAGESIZE";
    private static final String TOTAL_ROWS = "$TOTAL_ROWS";
    private static final String SKIP_ROWS_PLUS1 = "$SKIP_ROWS_PLUS1";
    private static final String TOTAL_ROWS_PLUS1 = "$TOTAL_ROWS_PLUS1";
    private static final String DISTINCT_TAG = "($DISTINCT)";
    protected static final DialectLogger logger;
    private String sqlTemplate = null;
    private String topLimitTemplate = null;
    protected final Map<Type, String> typeMappings = new EnumMap<Type, String>(Type.class);
    protected final Map<String, String> functions = new HashMap<String, String>();
    protected final DDLFeatures ddlFeatures = new DDLFeatures();

    public static Dialect guessDialect(String databaseName, Object ... majorVersionMinorVersion) {
        return GuessDialectUtils.guessDialect(databaseName, majorVersionMinorVersion);
    }

    public static Dialect guessDialect(Connection connection) {
        return GuessDialectUtils.guessDialect(connection);
    }

    public static Dialect guessDialect(DataSource datasource) {
        return GuessDialectUtils.guessDialect(datasource);
    }

    private void checkIfReservedWord(String word, String ... tableName) {
        if (ReservedDBWords.isReservedWord(word)) {
            String inTable = tableName.length > 0 ? "In table " + tableName[0] + ", " : "";
            String reservedForDB = ReservedDBWords.reservedForDB(word);
            if (ReservedDBWords.isReservedWord(this, word)) {
                if (globalAllowReservedWords.booleanValue()) {
                    logger.warn(inTable + "\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table, column, unique or index name");
                } else {
                    DialectException.throwEX(inTable + "\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table, column, unique or index name. " + "if you really want use this reserved word, call Dialect.setGlobalAllowReservedWords() at application starting.");
                }
            } else {
                logger.warn(inTable + "\"" + word + "\" is a reserved word of other database \"" + reservedForDB + "\", not recommend be used as table, column, unique or index name");
            }
        }
    }

    public String checkReservedWords(String ... words) {
        if (words == null || words.length == 0) {
            return null;
        }
        for (String word : words) {
            this.checkIfReservedWord(word, new String[0]);
        }
        return words[0];
    }

    public String checkNotEmptyReservedWords(String word, String type, String tableName) {
        if (StrUtils.isEmpty(word)) {
            DialectException.throwEX(type + " can not be empty");
        }
        this.checkIfReservedWord(word, tableName);
        return word;
    }

    public String translateToDDLType(Type type, Integer ... lengths) {
        String value = this.typeMappings.get((Object)type);
        if (StrUtils.isEmpty(value) || "N/A".equals(value) || "n/a".equals(value)) {
            DialectException.throwEX("Type \"" + (Object)((Object)type) + "\" is not supported by dialect \"" + this + "\"");
        }
        if (value.contains("|")) {
            String[] mappings;
            for (String mapping : mappings = StringHelper.split("|", value)) {
                if (mapping.contains("<")) {
                    String[] limitType = StringHelper.split("<", mapping);
                    if (lengths.length <= 0 || lengths[0] >= Integer.parseInt(limitType[1])) continue;
                    return this.putParamters(type, limitType[0], lengths);
                }
                return this.putParamters(type, mapping, lengths);
            }
        } else {
            if (value.contains("$")) {
                return this.putParamters(type, value, lengths);
            }
            return value;
        }
        return "";
    }

    private String putParamters(Type type, String value, Integer ... lengths) {
        if (lengths.length < StrUtils.countMatches(value, '$')) {
            DialectException.throwEX("In Dialect \"" + this + "\", Type \"" + (Object)((Object)type) + "\" should have " + StrUtils.countMatches(value, '$') + " parameters");
        }
        int i = 0;
        String newValue = value;
        if (newValue.contains("$l")) {
            newValue = StrUtils.replace(newValue, "$l", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$p")) {
            newValue = StrUtils.replace(newValue, "$p", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$s")) {
            newValue = StrUtils.replace(newValue, "$s", String.valueOf(lengths[i]));
        }
        return newValue;
    }

    private static String aTopLimitSqlExample(String template) {
        String result = StrUtils.replaceIgnoreCase(template, "$SQL", "select * from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, "$BODY", "* from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, " ($DISTINCT)", "");
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS, "0");
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, "10");
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, "10");
        return result;
    }

    private static String processSQLServer(Dialect dialect, int pageNumber, int pageSize, String sql) {
        int skipRows = (pageNumber - 1) * pageSize;
        int totalRows = pageNumber * pageSize;
        RowSelection selection = new RowSelection(skipRows, totalRows);
        String result = null;
        switch (dialect) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: {
                result = new SQLServer2005LimitHandler().processSql(sql, selection);
                break;
            }
            case SQLServer2012Dialect: {
                result = new SQLServer2012LimitHandler().processSql(sql, selection);
                break;
            }
        }
        result = StringHelper.replace(result, "__hibernate_row_nr__", "_ROW_NUM_");
        result = StringHelper.replaceOnce(result, " $Top_Tag(?) ", " TOP(" + totalRows + ") ");
        result = StringHelper.replaceOnce(result, "_ROW_NUM_ >= ? AND _ROW_NUM_ < ?", "_ROW_NUM_ >= " + (skipRows + 1) + " AND _ROW_NUM_ < " + (totalRows + 1));
        result = StringHelper.replaceOnce(result, "offset ? rows fetch next ? rows only", "offset " + skipRows + " rows fetch next " + pageSize + " rows only");
        result = StringHelper.replaceOnce(result, "offset 0 rows fetch next ? rows only", "offset 0 rows fetch next " + pageSize + " rows only");
        if (StrUtils.isEmpty(result)) {
            DialectException.throwEX("Unexpected error, please report this bug");
        }
        return result;
    }

    @Override
    public String paginAndTrans(int pageNumber, int pageSize, String ... sql) {
        return this.pagin(pageNumber, pageSize, this.trans(sql));
    }

    @Override
    public String trans(String ... sql) {
        StringBuilder sb = new StringBuilder();
        for (String str : sql) {
            sb.append(str);
        }
        return DialectFunctionTranslator.instance.doTranslate(this, sb.toString());
    }

    @Override
    public String pagin(int pageNumber, int pageSize, String sql) {
        String result = null;
        DialectException.assureNotNull(sql, "sql string can not be null");
        String trimedSql = sql.trim();
        DialectException.assureNotEmpty(trimedSql, "sql string can not be empty");
        switch (this) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: 
            case SQLServer2012Dialect: {
                result = Dialect.processSQLServer(this, pageNumber, pageSize, trimedSql);
                if (Dialect.getGlobalAllowShowSql().booleanValue()) {
                    logger.info("Paginated sql: " + result);
                }
                return result;
            }
        }
        if (!StrUtils.startsWithIgnoreCase(trimedSql, "select ")) {
            return (String)DialectException.throwEX("SQL should start with \"select \".");
        }
        String body = trimedSql.substring(7).trim();
        DialectException.assureNotEmpty(body, "SQL body can not be empty");
        int skipRows = (pageNumber - 1) * pageSize;
        int skipRowsPlus1 = skipRows + 1;
        int totalRows = pageNumber * pageSize;
        int totalRowsPlus1 = totalRows + 1;
        String useTemplate = this.sqlTemplate;
        if (skipRows == 0) {
            useTemplate = this.topLimitTemplate;
        }
        if (NOT_SUPPORT.equals(useTemplate)) {
            if (!NOT_SUPPORT.equals(this.topLimitTemplate)) {
                return (String)DialectException.throwEX("Dialect \"" + this + "\" only support top limit SQL, for example: \"" + Dialect.aTopLimitSqlExample(this.topLimitTemplate) + "\"");
            }
            return (String)DialectException.throwEX("Dialect \"" + this + "\" does not support physical pagination");
        }
        if (useTemplate.contains(DISTINCT_TAG)) {
            if (!StrUtils.startsWithIgnoreCase(body, "distinct ")) {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "");
            } else {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "distinct");
                body = body.substring(9);
            }
        }
        result = StrUtils.replaceIgnoreCase(useTemplate, SKIP_ROWS, String.valueOf(skipRows));
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, String.valueOf(pageSize));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, String.valueOf(totalRows));
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS_PLUS1, String.valueOf(skipRowsPlus1));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS_PLUS1, String.valueOf(totalRowsPlus1));
        result = StrUtils.replace(result, "$SQL", trimedSql);
        result = StrUtils.replace(result, "$BODY", body);
        if (Dialect.getGlobalAllowShowSql().booleanValue()) {
            logger.info("Paginated sql: " + result);
        }
        return result;
    }

    public boolean isMySqlFamily() {
        return this.toString().startsWith("MySQL");
    }

    public boolean isInfomixFamily() {
        return this.toString().startsWith("Infomix");
    }

    public boolean isOracleFamily() {
        return this.toString().startsWith("Oracle");
    }

    public boolean isSQLServerFamily() {
        return this.toString().startsWith("SQLServer");
    }

    public boolean isH2Family() {
        return H2Dialect.equals(this);
    }

    public boolean isPostgresFamily() {
        return this.toString().startsWith("Postgres");
    }

    public boolean isSybaseFamily() {
        return this.toString().startsWith("Sybase");
    }

    public boolean isDB2Family() {
        return this.toString().startsWith("DB2");
    }

    public boolean isDerbyFamily() {
        return this.toString().startsWith("Derby");
    }

    public String[] toCreateDDL(Class<?> ... entityClasses) {
        return DDLCreateUtils.toCreateDDL(this, TableModelUtils.entity2Models(entityClasses));
    }

    public String[] toDropDDL(Class<?> ... entityClasses) {
        return DDLDropUtils.toDropDDL(this, TableModelUtils.entity2Models(entityClasses));
    }

    public String[] toDropAndCreateDDL(Class<?> ... entityClasses) {
        return this.toDropAndCreateDDL(TableModelUtils.entity2Models(entityClasses));
    }

    public String[] toCreateDDL(TableModel ... tables) {
        return DDLCreateUtils.toCreateDDL(this, tables);
    }

    public String[] toDropDDL(TableModel ... tables) {
        return DDLDropUtils.toDropDDL(this, tables);
    }

    public String[] toDropAndCreateDDL(TableModel ... tables) {
        String[] drop = DDLDropUtils.toDropDDL(this, tables);
        String[] create = DDLCreateUtils.toCreateDDL(this, tables);
        return StrUtils.joinStringArray(drop, create);
    }

    public String dropTableDDL(String tableName) {
        return this.ddlFeatures.dropTableString.replaceFirst("_TABLENAME", tableName);
    }

    public String dropSequenceDDL(String sequenceName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropSequenceStrings)) {
            return StrUtils.replace(this.ddlFeatures.dropSequenceStrings, "_SEQNAME", sequenceName);
        }
        return (String)DialectException.throwEX("Dialect \"" + this + "\" does not support drop sequence ddl, on sequence \"" + sequenceName + "\"");
    }

    public String dropFKeyDDL(String tableName, String fkeyName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropForeignKeyString)) {
            return "alter table " + tableName + " " + this.ddlFeatures.dropForeignKeyString + " " + fkeyName;
        }
        return (String)DialectException.throwEX("Dialect \"" + this + "\" does not support drop foreign key, on foreign key \"" + fkeyName + "\"");
    }

    public Object getNexID(IdGenerator idGenerator, NormalJdbcTool jdbc, Type dataType) {
        return idGenerator.getNextID(jdbc, this, dataType);
    }

    public Map<Type, String> getTypeMappings() {
        return this.typeMappings;
    }

    public Map<String, String> getFunctions() {
        return this.functions;
    }

    public DDLFeatures getDdlFeatures() {
        return this.ddlFeatures;
    }

    public static Boolean getGlobalAllowReservedWords() {
        return globalAllowReservedWords;
    }

    public static void setGlobalAllowReservedWords(Boolean ifAllowReservedWords) {
        globalAllowReservedWords = ifAllowReservedWords;
    }

    public static Boolean getGlobalAllowShowSql() {
        return globalAllowShowSql;
    }

    public static void setGlobalAllowShowSql(Boolean ifAllowShowSql) {
        globalAllowShowSql = ifAllowShowSql;
    }

    public static String getGlobalSqlFunctionPrefix() {
        return globalSqlFunctionPrefix;
    }

    public static void setGlobalSqlFunctionPrefix(String sqlFunctionPrefix) {
        globalSqlFunctionPrefix = sqlFunctionPrefix;
    }

    static {
        globalAllowReservedWords = false;
        globalAllowShowSql = false;
        globalSqlFunctionPrefix = null;
        logger = DialectLogger.getLog(Dialect.class);
        for (Dialect d : Dialect.values()) {
            d.sqlTemplate = DialectPaginationTemplate.initializePaginSQLTemplate(d);
            d.topLimitTemplate = DialectPaginationTemplate.initializeTopLimitSqlTemplate(d);
            DDLFeatures.initDDLFeatures(d, d.ddlFeatures);
        }
        DialectTypeMappingTemplate.initTypeMappings();
        DialectFunctionTemplate.initFunctionTemplates();
    }
}

