/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBox;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.SqlBoxUtils;
import java.lang.reflect.Method;

public class ActiveRecord
implements ActiveRecordSupport {
    SqlBox box;

    @Override
    public SqlBox box() {
        if (this.box == null) {
            this.box = SqlBoxUtils.createSqlBox(SqlBoxContext.gctx(), this.getClass());
        }
        return this.box;
    }

    @Override
    public SqlBox bindedBox() {
        return this.box;
    }

    @Override
    public void bindBox(SqlBox box) {
        if (box == null) {
            throw new SqlBoxException("Can not bind null SqlBox to entity");
        }
        this.box = box;
    }

    @Override
    public void unbindBox() {
        this.box = null;
    }

    @Override
    public TableModel tableModel() {
        return this.box().getTableModel();
    }

    @Override
    public ColumnModel columnModel(String colOrFieldName) {
        return this.box().getTableModel().getColumnByColOrEntityFieldName(colOrFieldName);
    }

    @Override
    public String table() {
        return this.box().getTableModel().getTableName();
    }

    @Override
    public ActiveRecordSupport alias(String alias) {
        this.box().getTableModel().setAlias(alias);
        return this;
    }

    @Override
    public SqlBoxContext ctx() {
        SqlBox theBox = this.box();
        if (theBox.getContext() == null) {
            theBox.setContext(SqlBoxContext.getGlobalSqlBoxContext());
        }
        return theBox.getContext();
    }

    @Override
    public ActiveRecordSupport useContext(SqlBoxContext ctx) {
        this.box().setContext(ctx);
        return this;
    }

    @Override
    public <T> T insert(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        ctx.insert(this, optionalSqlItems);
        return (T)this;
    }

    @Override
    public <T> T update(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        ctx.update(this, optionalSqlItems);
        return (T)this;
    }

    @Override
    public void delete(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        ctx.delete(this, optionalSqlItems);
    }

    @Override
    public <T> T load(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return ctx.load(this, optionalSqlItems);
    }

    @Override
    public <T> T loadById(Object idOrIdMap, Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return ctx.loadById(this, idOrIdMap, optionalSqlItems);
    }

    @Override
    public <T> T loadByQuery(Object ... sqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return (T)ctx.loadByQuery(this.getClass(), sqlItems);
    }

    @Override
    public ActiveRecordSupport put(Object ... fieldAndValues) {
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            String field = (String)fieldAndValues[i * 2];
            Object value = fieldAndValues[i * 2 + 1];
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), field);
            try {
                writeMethod.invoke((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
        }
        return this;
    }

    @Override
    public ActiveRecordSupport putFields(String ... fieldNames) {
        lastTimePutFieldsCache.set(fieldNames);
        return this;
    }

    @Override
    public ActiveRecordSupport putValues(Object ... values) {
        String[] fields = (String[])lastTimePutFieldsCache.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new SqlBoxException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new SqlBoxException("putValues fields and values number not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), fields[i]);
            if (writeMethod == null) {
                throw new SqlBoxException("Not found writeMethod for '" + this.getClass() + "' class's method '" + fields[i] + "'");
            }
            try {
                writeMethod.invoke((Object)this, values[i]);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
        }
        return this;
    }

    @Override
    public <T> T guess(Object ... params) {
        return this.ctx().getSqlMapperGuesser().guess(this.ctx(), this, params);
    }

    @Override
    public String guessSQL() {
        return this.ctx().getSqlMapperGuesser().guessSQL(this.ctx(), this);
    }

    @Override
    public PreparedSQL guessPreparedSQL(Object ... params) {
        return this.ctx().getSqlMapperGuesser().doGuessPreparedSQL(this.ctx(), this, params);
    }

    @Override
    public SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }
}

