/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProLogger;
import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.BasicSqlTemplate;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.id.SnowflakeCreator;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.JSQLBOX;
import com.github.drinkjava2.jsqlbox.SqlBox;
import com.github.drinkjava2.jsqlbox.SqlBoxContextConfig;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.SqlBoxUtils;
import com.github.drinkjava2.jsqlbox.SqlMapperDefaultGuesser;
import com.github.drinkjava2.jsqlbox.SqlMapperGuesser;
import com.github.drinkjava2.jsqlbox.SqlMapperUtils;
import com.github.drinkjava2.jsqlbox.handler.EntityListHandler;
import com.github.drinkjava2.jsqlbox.sharding.ShardingModTool;
import com.github.drinkjava2.jsqlbox.sharding.ShardingRangeTool;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.lang.reflect.Method;
import java.util.List;
import javax.sql.DataSource;

public class SqlBoxContext
extends DbPro {
    public static final String NO_GLOBAL_SQLBOXCONTEXT_FOUND = "No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.";
    public static final String SQLBOX_SUFFIX = "SqlBox";
    protected static SqlBoxContext globalSqlBoxContext = null;
    protected Dialect dialect = SqlBoxContextConfig.globalNextDialect;
    protected SqlMapperGuesser sqlMapperGuesser = SqlBoxContextConfig.globalNextSqlMapperGuesser;
    protected ShardingTool[] shardingTools = SqlBoxContextConfig.globalNextShardingTools;
    protected SnowflakeCreator snowflakeCreator = SqlBoxContextConfig.globalNextSnowflakeCreator;

    public SqlBoxContext() {
        this.dialect = SqlBoxContextConfig.globalNextDialect;
        this.copyConfigs(null);
        this.findAndExecuteInitializer();
    }

    public SqlBoxContext(DataSource ds) {
        super(ds);
        this.dialect = Dialect.guessDialect(ds);
        this.copyConfigs(null);
        this.findAndExecuteInitializer();
    }

    public SqlBoxContext(SqlBoxContextConfig config) {
        super(config);
        this.copyConfigs(config);
        this.findAndExecuteInitializer();
    }

    public SqlBoxContext(DataSource ds, SqlBoxContextConfig config) {
        super(ds, config);
        this.copyConfigs(config);
        if (this.dialect == null) {
            this.dialect = Dialect.guessDialect(ds);
        }
        this.findAndExecuteInitializer();
    }

    private void findAndExecuteInitializer() {
        Class<?> callerClass = ClassCacheUtils.checkClassExist("com.github.drinkjava2.jsqlbox.SqlBoxContextInitializer");
        if (callerClass == null) {
            return;
        }
        try {
            Method initMethod = callerClass.getMethod("initialize", SqlBoxContext.class);
            initMethod.invoke(null, this);
        }
        catch (Exception e) {
            throw new SqlBoxException("SqlBoxContextInitializer found but failed call it's initialize method.");
        }
    }

    private void copyConfigs(SqlBoxContextConfig config) {
        if (config == null) {
            this.sqlMapperGuesser = SqlBoxContextConfig.globalNextSqlMapperGuesser;
            this.shardingTools = SqlBoxContextConfig.globalNextShardingTools;
            this.snowflakeCreator = SqlBoxContextConfig.globalNextSnowflakeCreator;
        } else {
            this.dialect = config.getDialect();
            this.sqlMapperGuesser = config.getSqlMapperGuesser();
            this.shardingTools = config.getShardingTools();
            this.snowflakeCreator = config.getSnowflakeCreator();
        }
    }

    protected void coreMethods______________________________() {
    }

    public static void resetGlobalVariants() {
        SqlBoxContextConfig.setGlobalNextAllowShowSql(false);
        SqlBoxContextConfig.setGlobalNextMasterSlaveOption(SqlOption.USE_AUTO);
        SqlBoxContextConfig.setGlobalNextConnectionManager(null);
        SqlBoxContextConfig.setGlobalNextSqlHandlers(null);
        SqlBoxContextConfig.setGlobalNextLogger(DbProLogger.DefaultDbProLogger.getLog(ImprovedQueryRunner.class));
        SqlBoxContextConfig.setGlobalNextBatchSize(300);
        SqlBoxContextConfig.setGlobalNextTemplateEngine(BasicSqlTemplate.instance());
        SqlBoxContextConfig.setGlobalNextDialect(null);
        SqlBoxContextConfig.setGlobalNextSpecialSqlItemPreparers(null);
        SqlBoxContextConfig.setGlobalNextSqlMapperGuesser(SqlMapperDefaultGuesser.instance);
        SqlBoxContextConfig.setGlobalNextShardingTools(new ShardingTool[]{new ShardingModTool(), new ShardingRangeTool()});
        SqlBoxContextConfig.setGlobalNextIocTool(null);
        globalSqlBoxContext = null;
    }

    public static SqlBoxContext gctx() {
        return globalSqlBoxContext;
    }

    public static SqlBoxContext getGlobalSqlBoxContext() {
        return globalSqlBoxContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean dealItem(boolean iXxxStyle, PreparedSQL ps, StringBuilder sql, Object item) {
        if (super.dealItem(iXxxStyle, ps, sql, item)) {
            return true;
        }
        if (item instanceof TableModel) {
            ps.addModel(item);
            return true;
        } else if (item instanceof ActiveRecordSupport) {
            ps.addModel(((ActiveRecordSupport)item).tableModel());
            return true;
        } else if (item instanceof SqlBox) {
            ps.addModel(((SqlBox)item).getTableModel());
            return true;
        } else {
            if (!(item instanceof SqlItem)) return false;
            SqlItem sqItem = (SqlItem)item;
            SqlOption sqlItemType = sqItem.getType();
            if (SqlOption.SHARD_TABLE.equals((Object)sqlItemType)) {
                this.handleShardTable(sql, sqItem);
                return true;
            } else if (SqlOption.SHARD_DATABASE.equals((Object)sqlItemType)) {
                this.handleShardDatabase(ps, sqItem);
                return true;
            } else if (SqlOption.GIVE.equals((Object)sqlItemType)) {
                Object[] o = ((SqlItem)item).getParameters();
                String[] s = new String[o.length];
                for (int i = 0; i < o.length; ++i) {
                    s[i] = (String)o[i];
                }
                ps.addGives(s);
                return true;
            } else if (SqlOption.GIVE_BOTH.equals((Object)sqlItemType)) {
                Object[] a = ((SqlItem)item).getParameters();
                ps.addGives(new String[]{(String)a[0], (String)a[1]});
                ps.addGives(new String[]{(String)a[1], (String)a[0]});
                return true;
            } else if (SqlOption.MODEL.equals((Object)sqlItemType) || SqlOption.MODEL_AUTO_ALIAS.equals((Object)sqlItemType)) {
                Object[] args = sqItem.getParameters();
                if (args.length == 0) {
                    throw new SqlBoxException("Model item can not be empty");
                }
                for (Object object : args) {
                    TableModel t = SqlBoxContextUtils.configToModel(object, new Object[0]);
                    if (SqlOption.MODEL_AUTO_ALIAS.equals((Object)sqlItemType) && StrUtils.isEmpty(t.getAlias())) {
                        t.setAlias(SqlBoxContextUtils.createAutoAliasNameForEntityClass(t.getEntityClass()));
                    }
                    ps.addModel(t);
                }
                return true;
            } else {
                if (!SqlOption.MODEL_ALIAS.equals((Object)sqlItemType)) return false;
                Object[] args = sqItem.getParameters();
                if (args.length < 2) {
                    throw new SqlBoxException("MODEL_ALIAS item need model1, alias1, model2, alias2... format parameters");
                }
                for (int i = 0; i < args.length / 2; ++i) {
                    TableModel t = SqlBoxContextUtils.configToModel(args[i * 2], new Object[0]);
                    SqlBoxException.assureNotNull(t.getEntityClass(), "'entityClass' property not set for model " + t);
                    SqlBoxException.assureNotEmpty((String)args[i * 2 + 1], "Alias can not be empty for class '" + t.getEntityClass() + "'");
                    t.setAlias((String)args[i * 2 + 1]);
                    ps.addModel(t);
                }
            }
        }
        return true;
    }

    public SqlBox getSqlBox(Object entityBean) {
        return SqlBoxUtils.findAndBindSqlBox(this, entityBean);
    }

    public static <T> T createMapper(Class<?> abstractClass) {
        Class<?> childClass = SqlMapperUtils.createChildClass(abstractClass);
        try {
            return (T)childClass.newInstance();
        }
        catch (Exception e) {
            throw new SqlBoxException(e);
        }
    }

    public static <T> T createMapper(SqlBoxContext ctx, Class<?> abstractClass) {
        T entity = SqlBoxContext.createMapper(abstractClass);
        SqlBoxUtils.findAndBindSqlBox(ctx, entity);
        return entity;
    }

    public String getShardedTB(Object entityOrClass, Object ... shardvalues) {
        String table = SqlBoxContextUtils.getShardedTB(this, entityOrClass, shardvalues);
        if (table == null) {
            throw new SqlBoxException("No found ShardingTool can handle target '" + entityOrClass + "' ");
        }
        return table;
    }

    public SqlBoxContext getShardedDB(Object entityOrClass, Object ... shardvalues) {
        SqlBoxContext ctx = SqlBoxContextUtils.getShardedDB(this, entityOrClass, shardvalues);
        if (ctx == null) {
            throw new SqlBoxException("Not found ShardingTool can handle entity '" + entityOrClass + "' ");
        }
        return ctx;
    }

    protected String handleShardTable(StringBuilder sql, SqlItem item) {
        Object[] params = item.getParameters();
        String table = null;
        table = params.length == 1 ? SqlBoxContextUtils.getShardedTB(this, params[0], new Object[0]) : (params.length == 2 ? SqlBoxContextUtils.getShardedTB(this, params[0], params[1]) : SqlBoxContextUtils.getShardedTB(this, params[0], params[1], params[2]));
        if (table == null) {
            throw new SqlBoxException("No ShardingTool can handle target '" + params[0] + "'");
        }
        sql.append(table);
        return table;
    }

    protected DbPro handleShardDatabase(PreparedSQL predSQL, SqlItem item) {
        Object[] params = item.getParameters();
        SqlBoxContext ctx = null;
        ctx = params.length == 1 ? SqlBoxContextUtils.getShardedDB(this, params[0], new Object[0]) : (params.length == 2 ? SqlBoxContextUtils.getShardedDB(this, params[0], params[1]) : SqlBoxContextUtils.getShardedDB(this, params[0], params[1], params[2]));
        if (ctx == null) {
            throw new SqlBoxException("No ShardingTool can handle target '" + params[0] + "'");
        }
        predSQL.setSwitchTo(ctx);
        return ctx;
    }

    public <T> List<T> iQueryForEntityList(Object config, Object ... optionItems) {
        return (List)this.iQuery(new EntityListHandler(), JSQLBOX.model(config), optionItems);
    }

    public <T> List<T> pQueryForEntityList(Object config, Object ... optionItems) {
        return (List)this.pQuery(new EntityListHandler(), JSQLBOX.model(config), optionItems);
    }

    public <T> List<T> tQueryForEntityList(Object config, Object ... optionItems) {
        return (List)this.tQuery(new EntityListHandler(), JSQLBOX.model(config), optionItems);
    }

    protected void crudMethods______________________________() {
    }

    public void insert(Object entity, Object ... optionItems) {
        SqlBoxContextUtils.insert(this, entity, optionItems);
    }

    public int update(Object entity, Object ... optionItems) {
        return SqlBoxContextUtils.update(this, entity, optionItems);
    }

    public void delete(Object entity, Object ... optionItems) {
        SqlBoxContextUtils.delete(this, entity, optionItems);
    }

    public <T> T load(Object entity, Object ... optionItems) {
        return SqlBoxContextUtils.load(this, entity, optionItems);
    }

    public <T> T loadById(Object entity, Object entityId, Object ... optionItems) {
        return SqlBoxContextUtils.loadById(this, entity, entityId, optionItems);
    }

    public <T> T loadById(Class<T> entityClass, Object entityId, Object ... optionItems) {
        return SqlBoxContextUtils.loadById(this, entityClass, entityId, optionItems);
    }

    public <T> T loadByQuery(Class<T> config, Object ... optionItems) {
        return SqlBoxContextUtils.loadByQuery(this, config, optionItems);
    }

    public <T> List<T> loadAll(Class<T> config, Object ... optionItems) {
        return SqlBoxContextUtils.loadAll(this, config, optionItems);
    }

    protected void dialectShortcutMethods__________________________() {
    }

    public String pagin(int pageNumber, int pageSize, String sql) {
        this.assertDialectNotNull();
        return this.dialect.pagin(pageNumber, pageSize, sql);
    }

    public String trans(String sql) {
        this.assertDialectNotNull();
        return this.dialect.trans(sql);
    }

    public String paginAndTrans(int pageNumber, int pageSize, String sql) {
        this.assertDialectNotNull();
        return this.dialect.paginAndTrans(pageNumber, pageSize, sql);
    }

    public String[] toCreateDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toCreateDDL(entityClasses);
    }

    public String[] toDropDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toDropDDL(entityClasses);
    }

    public String[] toDropAndCreateDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toDropAndCreateDDL(entityClasses);
    }

    public String[] toCreateDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toCreateDDL(tables);
    }

    public String[] toDropDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toDropDDL(tables);
    }

    public String[] toDropAndCreateDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toDropAndCreateDDL(tables);
    }

    private void assertDialectNotNull() {
        if (this.dialect == null) {
            throw new DbProRuntimeException("Try use a dialect method but dialect is null");
        }
    }

    protected void getteSetters__________________________() {
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    @Deprecated
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public SqlMapperGuesser getSqlMapperGuesser() {
        return this.sqlMapperGuesser;
    }

    @Deprecated
    public void setSqlMapperGuesser(SqlMapperGuesser sqlMapperGuesser) {
        this.sqlMapperGuesser = sqlMapperGuesser;
    }

    public ShardingTool[] getShardingTools() {
        return this.shardingTools;
    }

    @Deprecated
    public void setShardingTools(ShardingTool[] shardingTools) {
        this.shardingTools = shardingTools;
    }

    public SnowflakeCreator getSnowflakeCreator() {
        return this.snowflakeCreator;
    }

    @Deprecated
    public void setSnowflakeCreator(SnowflakeCreator snowflakeCreator) {
        this.snowflakeCreator = snowflakeCreator;
    }

    public static void setGlobalSqlBoxContext(SqlBoxContext globalSqlBoxContext) {
        SqlBoxContext.globalSqlBoxContext = globalSqlBoxContext;
    }
}

