/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.JDBPRO;
import com.github.drinkjava2.jdbpro.LinkStyleArrayList;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.IdentityIdGenerator;
import com.github.drinkjava2.jdialects.id.SnowflakeCreator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.JSQLBOX;
import com.github.drinkjava2.jsqlbox.SqlBox;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.SqlBoxStrUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxUtils;
import com.github.drinkjava2.jsqlbox.entitynet.EntityIdUtils;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class SqlBoxContextUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel[] loadMetaTableModels(SqlBoxContext ctx, Dialect dialect) {
        Connection con = null;
        SQLException sqlException = null;
        try {
            con = ctx.prepareConnection();
            TableModel[] tableModelArray = TableModelUtils.db2Models(con, dialect);
            return tableModelArray;
        }
        catch (SQLException e) {
            sqlException = e;
        }
        finally {
            try {
                ctx.close(con);
            }
            catch (SQLException e) {
                if (sqlException != null) {
                    sqlException.setNextException(e);
                }
                sqlException = e;
            }
        }
        throw new SqlBoxException(sqlException);
    }

    private static ColumnModel findMatchColumnForJavaField(String entityField, TableModel tableModel) {
        SqlBoxException.assureNotNull(tableModel, "Can not find column for '" + entityField + "' in null table ");
        List<ColumnModel> columns = tableModel.getColumns();
        ColumnModel result = null;
        String underLineFieldName = SqlBoxStrUtils.camelToLowerCaseUnderline(entityField);
        for (ColumnModel col : columns) {
            if (!entityField.equalsIgnoreCase(col.getEntityField()) && !underLineFieldName.equalsIgnoreCase(col.getColumnName())) continue;
            if (result != null) {
                throw new SqlBoxException("Field '" + entityField + "' found duplicated columns definition");
            }
            result = col;
        }
        if (result == null) {
            throw new SqlBoxException("Can not find column for '" + entityField + "' in table '" + tableModel.getTableName() + "'");
        }
        return result;
    }

    public static String getShardedTB(SqlBoxContext ctx, Object entityOrClass, Object ... shardKey) {
        if (ctx.getShardingTools() == null || ctx.getShardingTools().length == 0) {
            throw new SqlBoxException("No shardingTools be set.");
        }
        String table = null;
        for (ShardingTool sh : ctx.getShardingTools()) {
            String[] result = sh.handleShardTable(ctx, entityOrClass, shardKey);
            if (result == null) continue;
            if (result.length == 0) {
                throw new SqlBoxException("Can not find sharding table for target '" + entityOrClass + "'");
            }
            if (result.length > 1) {
                throw new SqlBoxException("Found more than 1 sharding tables for target '" + entityOrClass + "', jSqlBox current version do not support auto-join, to solve this issue you need adjust your ShardTable search condition");
            }
            table = result[0];
            break;
        }
        return table;
    }

    public static SqlBoxContext getShardedDB(SqlBoxContext currentCtx, Object entityOrClass, Object ... shardKey) {
        if (currentCtx.getMasters() == null || currentCtx.getMasters().length == 0) {
            throw new SqlBoxException("Current SqlBoxContext did not set masters property but try do shardDatabase opertation.");
        }
        if (currentCtx.getShardingTools() == null || currentCtx.getShardingTools().length == 0) {
            throw new SqlBoxException("No shardingTools be set.");
        }
        SqlBoxContext masterCtx = null;
        for (ShardingTool sh : currentCtx.getShardingTools()) {
            SqlBoxContext[] result = sh.handleShardDatabase(currentCtx, entityOrClass, shardKey);
            if (result == null) continue;
            if (result.length == 0) {
                throw new SqlBoxException("Can not find master SqlBoxContext for '" + entityOrClass + "'");
            }
            if (result.length > 1) {
                throw new SqlBoxException("Found more than 1 SqlBoxContext tables for target '" + entityOrClass + "', jSqlBox current version do not support auto-join, to solve this issue you need adjust your ShardDatabase search condition.");
            }
            masterCtx = result[0];
            break;
        }
        return masterCtx;
    }

    public static int insert(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.configToModel(entityBean, optionItems);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        String identityFieldName = null;
        Type identityType = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        jSQL.append(" (");
        boolean foundColumnToInsert = false;
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue() || !col.getInsertable().booleanValue()) continue;
            if (col.getIdGenerationType() != null || !StrUtils.isEmpty(col.getIdGeneratorName())) {
                if (col.getIdGenerator() == null) {
                    throw new SqlBoxException("No IdGenerator found for column '" + col.getColumnName() + "'");
                }
                IdGenerator idGen = col.getIdGenerator();
                if (GenerationType.IDENTITY.equals((Object)idGen.getGenerationType())) {
                    if (identityFieldName != null) {
                        throw new SqlBoxException("More than 1 identity field found for table '" + model.getTableName() + "'");
                    }
                    identityType = col.getColumnType();
                    identityFieldName = fieldName;
                } else if (GenerationType.SNOWFLAKE.equals((Object)idGen.getGenerationType())) {
                    jSQL.append(col.getColumnName());
                    SnowflakeCreator snow = ctx.getSnowflakeCreator();
                    if (snow == null) {
                        throw new SqlBoxException("Current SqlBoxContext no SnowflakeCreator found when try to create a Snowflake value");
                    }
                    Long id = snow.nextId();
                    jSQL.append(JDBPRO.param(id));
                    jSQL.append(", ");
                    foundColumnToInsert = true;
                    ClassCacheUtils.writeValueToBeanField(entityBean, fieldName, id);
                } else {
                    jSQL.append(col.getColumnName());
                    Object id = idGen.getNextID(ctx, ctx.getDialect(), col.getColumnType());
                    jSQL.append(JDBPRO.param(id));
                    jSQL.append(", ");
                    foundColumnToInsert = true;
                    ClassCacheUtils.writeValueToBeanField(entityBean, fieldName, id);
                }
            } else {
                Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
                jSQL.append(col.getColumnName());
                jSQL.append(new SqlItem(SqlOption.PARAM, value));
                jSQL.append(", ");
                foundColumnToInsert = true;
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
        }
        if (foundColumnToInsert) {
            jSQL.remove(jSQL.size() - 1);
        }
        if (shardTableItem != null) {
            jSQL.frontAdd(shardTableItem);
        } else {
            jSQL.frontAdd(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.frontAdd("insert into ");
        jSQL.append(") ");
        jSQL.append(JDBPRO.valuesQuestions());
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        int result = ctx.iUpdate(jSQL.toArray());
        if (ctx.isBatchEnabled()) {
            return result;
        }
        if (identityFieldName != null) {
            Object identityId = IdentityIdGenerator.INSTANCE.getNextID(ctx, ctx.getDialect(), identityType);
            ClassCacheUtils.writeValueToBeanField(entityBean, identityFieldName, identityId);
        }
        return result;
    }

    public static int update(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.configToModel(entityBean, optionItems);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue() || !col.getUpdatable().booleanValue()) continue;
            Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
            if (!col.getPkey().booleanValue()) {
                if (!jSQL.isEmpty()) {
                    jSQL.append(", ");
                }
                jSQL.append(col.getColumnName()).append("=? ");
                jSQL.append(JDBPRO.param(value));
            } else {
                if (!where.isEmpty()) {
                    where.append(" and ");
                }
                where.append(col.getColumnName()).append("=?");
                where.append(JDBPRO.param(value));
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
        }
        jSQL.frontAdd(" set ");
        if (shardTableItem != null) {
            jSQL.frontAdd(shardTableItem);
        } else {
            jSQL.frontAdd(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.frontAdd("update ");
        jSQL.append(" where ");
        jSQL.addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        return ctx.iUpdate(jSQL.toObjectArray());
    }

    public static void delete(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.configToModel(entityBean, optionItems);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<Object> where = new LinkStyleArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> readMethods = ClassCacheUtils.getClassReadMethods(entityBean.getClass());
        for (String fieldName : readMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (!col.getTransientable().booleanValue() && col.getPkey().booleanValue()) {
                Object value = ClassCacheUtils.readValueFromBeanField(entityBean, fieldName);
                if (!where.isEmpty()) {
                    where.append(" and ");
                }
                where.append(JDBPRO.param(value));
                where.append(col.getColumnName()).append("=? ");
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
        }
        if (where.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        jSQL.append("delete from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        jSQL.append(SingleTonHandlers.arrayHandler);
        int rowAffected = ctx.iUpdate(jSQL.toObjectArray());
        if (ctx.isBatchEnabled()) {
            return;
        }
        if (rowAffected <= 0) {
            throw new SqlBoxException("No row be deleted for entityBean");
        }
        if (rowAffected > 1) {
            throw new SqlBoxException("Multiple rows affected when delete entityBean");
        }
    }

    public static <T> T loadByQuery(SqlBoxContext ctx, Object config, Object ... sqlItems) {
        List<Map<String, Object>> rows = ctx.iQueryForMapList(sqlItems);
        if (rows == null || rows.isEmpty()) {
            throw new SqlBoxException("No no record found in database.");
        }
        if (rows.size() > 1) {
            throw new SqlBoxException("More than 1 record found in database.");
        }
        Map<String, Object> oneRow = rows.get(0);
        return SqlBoxContextUtils.mapToEntityBean(ctx, config, oneRow);
    }

    public static <T> T mapToEntityBean(SqlBoxContext ctx, Object config, Map<String, Object> oneRow) {
        if (oneRow == null || oneRow.isEmpty()) {
            throw new SqlBoxException("Can not use null or empty row to convert to EntityBean");
        }
        TableModel model = SqlBoxContextUtils.configToModel(config, new Object[0]);
        SqlBoxException.assureNotNull(model.getEntityClass(), "Can not find entityClass setting in model.");
        Object bean = ClassCacheUtils.createNewEntity(model.getEntityClass());
        ctx.getSqlBox(bean).setTableModel(model.newCopy());
        for (ColumnModel col : model.getColumns()) {
            boolean foundValue = false;
            for (Map.Entry<String, Object> row : oneRow.entrySet()) {
                if (!row.getKey().equalsIgnoreCase(col.getColumnName())) continue;
                foundValue = true;
                SqlBoxException.assureNotEmpty(col.getEntityField(), "EntityField not found for column '" + col.getColumnName() + "'");
                ClassCacheUtils.writeValueToBeanField(bean, col.getEntityField(), row.getValue());
            }
            if (!col.getPkey().booleanValue() || foundValue) continue;
            throw new SqlBoxException("One prime-key not set value: '" + col.getColumnName() + "'");
        }
        return (T)bean;
    }

    public static <T> List<T> loadAll(SqlBoxContext ctx, Object config, Object ... optionItems) {
        TableModel t = SqlBoxContextUtils.configToModel(config, optionItems);
        Object[] items = new Object[optionItems.length + 1];
        items[0] = "select * from " + t.getTableName();
        System.arraycopy(optionItems, 0, items, 1, optionItems.length);
        return ctx.iQueryForEntityList(config, items);
    }

    public static <T> T loadById(SqlBoxContext ctx, Object entityOrClass, Object idOrIdMap, Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.configToModel(entityOrClass, optionItems);
        SqlBoxException.assureNotNull(model.getEntityClass(), "Can not find TableModel setting in '" + entityOrClass + "'");
        T bean = SqlBoxContextUtils.configToBean(entityOrClass);
        bean = EntityIdUtils.setEntityIdValues(bean, idOrIdMap, model);
        return SqlBoxContextUtils.load(ctx, bean, optionItems);
    }

    public static <T> T load(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        SqlBoxException.assureNotNull(entityBean, "entityBean can not be null");
        TableModel model = SqlBoxContextUtils.configToModel(entityBean, optionItems);
        LinkStyleArrayList<Object> jSQL = new LinkStyleArrayList<Object>();
        LinkStyleArrayList<String> where = new LinkStyleArrayList<String>();
        ArrayList<String> allFieldNames = new ArrayList<String>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Map<String, Method> writeMethods = ClassCacheUtils.getClassWriteMethods(entityBean.getClass());
        for (String fieldName : writeMethods.keySet()) {
            ColumnModel col = SqlBoxContextUtils.findMatchColumnForJavaField(fieldName, model);
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                where.append(col.getColumnName()).append("=?").append((String)((Object)JDBPRO.param(ClassCacheUtils.readValueFromBeanField(entityBean, fieldName)))).append(" and ");
            }
            jSQL.append(col.getColumnName()).append(", ");
            allFieldNames.add(col.getEntityField());
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(model, ClassCacheUtils.readValueFromBeanField(entityBean, fieldName));
        }
        jSQL.remove(jSQL.size() - 1);
        if (where.isEmpty()) {
            throw new SqlBoxException("No PKey column found from tableModel '" + model.getTableName() + "'");
        }
        where.remove(where.size() - 1);
        jSQL.frontAdd("select ").append(" from ");
        if (shardTableItem != null) {
            jSQL.append(shardTableItem);
        } else {
            jSQL.append(model.getTableName());
        }
        if (shardDbItem != null) {
            jSQL.append(shardDbItem);
        }
        jSQL.append(" where ").addAll(where);
        if (optionItems != null) {
            for (Object item : optionItems) {
                jSQL.append(item);
            }
        }
        jSQL.append(SingleTonHandlers.arrayListHandler);
        List valuesList = (List)ctx.iQuery(jSQL.toObjectArray());
        if (valuesList.isEmpty()) {
            throw new SqlBoxException("Try to load entity but no record found in database");
        }
        if (valuesList.size() > 1) {
            throw new SqlBoxException("Try to load entity but more than 1 record found in database");
        }
        Object[] values = (Object[])valuesList.get(0);
        try {
            for (int i = 0; i < values.length; ++i) {
                Method writeMethod = writeMethods.get(allFieldNames.get(i));
                SqlBoxException.assureNotNull(writeMethod, "Not found write method of field '" + (String)allFieldNames.get(i) + "' in " + entityBean.getClass());
                writeMethod.invoke(entityBean, values[i]);
            }
        }
        catch (Exception e) {
            throw new SqlBoxException(e);
        }
        return (T)entityBean;
    }

    public static <T> T configToBean(Object entityOrClass) {
        if (entityOrClass == null) {
            throw new SqlBoxException("Can build Bean for null entityOrClass");
        }
        Class t = null;
        if (entityOrClass instanceof TableModel) {
            t = ((TableModel)entityOrClass).getEntityClass();
        } else {
            if (entityOrClass instanceof ActiveRecordSupport) {
                return (T)entityOrClass;
            }
            if (entityOrClass instanceof SqlBox) {
                t = ((SqlBox)entityOrClass).getTableModel().getEntityClass();
            } else if (entityOrClass instanceof Class) {
                t = (Class)entityOrClass;
            } else {
                return (T)entityOrClass;
            }
        }
        try {
            return (T)t.newInstance();
        }
        catch (Exception e) {
            throw new SqlBoxException("Can not create new instance for '" + t + "'");
        }
    }

    public static TableModel configToModel(Object entityOrClass, Object ... optionItems) {
        for (Object item : optionItems) {
            if (item instanceof TableModel) {
                return (TableModel)item;
            }
            if (item instanceof ActiveRecordSupport) {
                return ((ActiveRecordSupport)item).tableModel();
            }
            if (item instanceof SqlBox) {
                return ((SqlBox)item).getTableModel();
            }
            if (!(item instanceof SqlItem)) continue;
            SqlItem sqlItem = (SqlItem)item;
            SqlOption sqlItemType = sqlItem.getType();
            if (SqlOption.MODEL.equals((Object)sqlItemType) || SqlOption.MODEL_AUTO_ALIAS.equals((Object)sqlItemType)) {
                Object[] args = sqlItem.getParameters();
                if (args.length != 1) {
                    throw new SqlBoxException("Model item need one parameter here.");
                }
                TableModel t = SqlBoxContextUtils.configToModel(args[0], new Object[0]);
                if (SqlOption.MODEL_AUTO_ALIAS.equals((Object)sqlItemType) && StrUtils.isEmpty(t.getAlias())) {
                    t.setAlias(SqlBoxContextUtils.createAutoAliasNameForEntityClass(t.getEntityClass()));
                }
                return t;
            }
            if (!SqlOption.MODEL_ALIAS.equals((Object)sqlItemType)) continue;
            Object[] args = sqlItem.getParameters();
            if (args.length != 2) {
                throw new SqlBoxException("MODEL_ALIAS item need 'model, alias' format 2 parameters");
            }
            TableModel t = SqlBoxContextUtils.configToModel(0, new Object[0]);
            SqlBoxException.assureNotNull(t.getEntityClass(), "'entityClass' property not set for model " + t);
            SqlBoxException.assureNotEmpty((String)args[1], "Alias can not be empty for class '" + t.getEntityClass() + "'");
            t.setAlias((String)args[1]);
            return t;
        }
        if (entityOrClass == null) {
            throw new SqlBoxException("Can build TableModel configuration for null entityOrClass");
        }
        if (entityOrClass instanceof TableModel) {
            return (TableModel)entityOrClass;
        }
        if (entityOrClass instanceof ActiveRecordSupport) {
            return ((ActiveRecordSupport)entityOrClass).tableModel();
        }
        if (entityOrClass instanceof SqlBox) {
            return ((SqlBox)entityOrClass).getTableModel();
        }
        if (entityOrClass instanceof Class) {
            return TableModelUtils.entity2Model((Class)entityOrClass);
        }
        return SqlBoxUtils.findAndBindSqlBox(null, entityOrClass).getTableModel();
    }

    public static String createAutoAliasNameForEntityClass(Class<?> clazz) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char c : chars = clazz.getSimpleName().toCharArray()) {
            if (c < 'A' || c > 'Z') continue;
            sb.append(c);
        }
        return sb.toString().toLowerCase();
    }
}

