/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

public abstract class SqlBoxStrUtils {
    public static String camelToLowerCaseUnderline(String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null && name.length() > 0) {
            sb.append(name.substring(0, 1).toLowerCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                char c = s.substring(0, 1).toCharArray()[0];
                if (c >= 'A' && c <= 'Z') {
                    sb.append("_");
                }
                sb.append(s.toLowerCase());
            }
        }
        return sb.toString();
    }

    public static String getQuestionsStr(int howmanyQuestions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < howmanyQuestions; ++i) {
            sb.append("?,");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean isNormalLetters(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    public static boolean isInvisibleChar(char c) {
        return c <= ' ';
    }

    public static String formatSQL(String sql) {
        if (sql == null || sql.length() == 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = sql.toCharArray();
        boolean addedSpace = false;
        for (char c : chars) {
            if (SqlBoxStrUtils.isInvisibleChar(c)) {
                if (addedSpace) continue;
                sb.append(" ");
                addedSpace = true;
                continue;
            }
            sb.append(c);
            addedSpace = false;
        }
        sb.append(" ");
        return sb.toString();
    }
}

