/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBox;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public abstract class SqlBoxUtils {
    public static final ThreadLocal<WeakHashMap<Object, SqlBox>> boxCache = new ThreadLocal<WeakHashMap<Object, SqlBox>>(){

        @Override
        protected WeakHashMap<Object, SqlBox> initialValue() {
            return new WeakHashMap<Object, SqlBox>();
        }
    };

    public static void bindBoxToPOJO(Object pojo, SqlBox box) {
        boxCache.get().put(pojo, box);
    }

    public static SqlBox findBoxOfPOJO(Object entity) {
        return boxCache.get().get(entity);
    }

    public static void unbindBoxOfPOJO(Object entity) {
        SqlBox box = boxCache.get().get(entity);
        if (box != null) {
            boxCache.get().remove(entity);
        }
    }

    public static SqlBox getBindedBox(Object entity) {
        if (entity == null) {
            throw new SqlBoxException("Can not find SqlBox for null entity");
        }
        if (entity instanceof ActiveRecordSupport) {
            return ((ActiveRecordSupport)entity).bindedBox();
        }
        return SqlBoxUtils.findBoxOfPOJO(entity);
    }

    public static SqlBox findBox(Object entity) {
        SqlBoxException.assureNotNull(entity, "Can not find box instance for null entity");
        SqlBox box = SqlBoxUtils.getBindedBox(entity);
        if (box != null) {
            return box;
        }
        return SqlBoxUtils.findAndBindSqlBox(SqlBoxContext.getGlobalSqlBoxContext(), entity);
    }

    public static void unbindBox(Object entity) {
        if (entity == null) {
            throw new SqlBoxException("Unbind box error, entity can not be null");
        }
        if (entity instanceof ActiveRecordSupport) {
            ActiveRecordSupport ac = (ActiveRecordSupport)entity;
            ac.unbindBox();
        } else {
            SqlBoxUtils.unbindBoxOfPOJO(entity);
        }
    }

    public static void bindBoxToBean(SqlBox box, Object entity) {
        if (entity == null) {
            throw new SqlBoxException("Bind box error, entity can not be null");
        }
        if (box == null) {
            throw new SqlBoxException("Bind box error, box can not be null");
        }
        if (entity instanceof ActiveRecordSupport) {
            ((ActiveRecordSupport)entity).bindBox(box);
        } else {
            SqlBoxUtils.bindBoxToPOJO(entity, box);
        }
    }

    public static SqlBox findAndBindSqlBox(SqlBoxContext ctx, Object entity) {
        SqlBoxException.assureNotNull(entity, "Can not find box instance for null entity");
        SqlBox box = SqlBoxUtils.getBindedBox(entity);
        if (box != null) {
            return box;
        }
        box = SqlBoxUtils.createSqlBox(ctx, entity.getClass());
        SqlBoxUtils.bindBoxToBean(box, entity);
        return box;
    }

    public static SqlBox createSqlBox(SqlBoxContext ctx, Class<?> entityOrBoxClass) {
        Class<?> boxClass = null;
        if (entityOrBoxClass == null) {
            throw new SqlBoxException("Bean Or SqlBox class can not be null");
        }
        if (SqlBox.class.isAssignableFrom(entityOrBoxClass)) {
            boxClass = entityOrBoxClass;
        }
        if (boxClass == null) {
            boxClass = ClassCacheUtils.checkClassExist(entityOrBoxClass.getName() + "SqlBox");
        }
        if (boxClass == null) {
            boxClass = ClassCacheUtils.checkClassExist(entityOrBoxClass.getName() + "$" + entityOrBoxClass.getSimpleName() + "SqlBox");
        }
        if (boxClass != null && !SqlBox.class.isAssignableFrom(boxClass)) {
            boxClass = null;
        }
        SqlBox box = null;
        if (boxClass == null) {
            box = new SqlBox();
            TableModel t = TableModelUtils.entity2Model(entityOrBoxClass);
            box.setTableModel(t);
        } else {
            try {
                box = (SqlBox)boxClass.newInstance();
                TableModel model = box.getTableModel();
                if (model == null) {
                    model = TableModelUtils.entity2Model(entityOrBoxClass);
                    box.setTableModel(model);
                }
                Method configMethod = null;
                try {
                    configMethod = boxClass.getMethod("config", TableModel.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (configMethod != null) {
                    configMethod.invoke((Object)box, model);
                }
            }
            catch (Exception e) {
                throw new SqlBoxException("Can not create SqlBox instance: " + entityOrBoxClass, e);
            }
        }
        if (box.getContext() == null) {
            box.setContext(ctx);
        }
        return box;
    }
}

