/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.entitynet;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

public abstract class EntityIdUtils {
    public static Object buildEntityIdFromOneRow(Map<String, Object> oneRow, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = oneRow.get(model.getAlias() + "_" + firstPkeyCol.getColumnName());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append("__");
            }
            if ((value = oneRow.get(model.getAlias() + "_" + col.getColumnName())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromEntity(Object entity, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = ClassCacheUtils.readValueFromBeanField(entity, firstPkeyCol.getEntityField());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append("__");
            }
            if ((value = ClassCacheUtils.readValueFromBeanField(entity, col.getEntityField())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromMap(Map<String, Object> map, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = map.get(firstPkeyCol.getEntityField());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append("__");
            }
            if ((value = map.get(col.getEntityField())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromUnknow(Object entityId, TableModel model) {
        Annotation[] anno;
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map mp = (Map)entityId;
            return EntityIdUtils.buildEntityIdFromMap(mp, model);
        }
        if (TypeUtils.canMapToSqlType(entityId.getClass())) {
            return entityId;
        }
        if (entityId instanceof ActiveRecordSupport) {
            return EntityIdUtils.buildEntityIdFromEntity(entityId, model);
        }
        for (Annotation annotation : anno = entityId.getClass().getAnnotations()) {
            if (!annotation.annotationType().getName().endsWith(".Entity")) continue;
            return EntityIdUtils.buildEntityIdFromEntity(entityId, model);
        }
        throw new SqlBoxException("Can not determine entityId type, if it's a entity, put @Entity annotation on it");
    }

    public static <T> T setEntityIdValues(T bean, Object entityId, TableModel model) {
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map idMap = (Map)entityId;
            for (Map.Entry item : idMap.entrySet()) {
                ClassCacheUtils.writeValueToBeanField(bean, (String)item.getKey(), item.getValue());
            }
        } else {
            Annotation[] anno;
            if (TypeUtils.canMapToSqlType(entityId.getClass())) {
                if (model.getPKeyCount() != 1) {
                    throw new SqlBoxException("More than 1 PKey column but only give 1 primary type parameter");
                }
                ColumnModel col = model.getFirstPKeyColumn();
                ClassCacheUtils.writeValueToBeanField(bean, col.getEntityField(), entityId);
                return bean;
            }
            boolean isEntity = false;
            if (entityId instanceof ActiveRecordSupport) {
                isEntity = true;
            }
            for (Annotation annotation : anno = entityId.getClass().getAnnotations()) {
                if (!annotation.annotationType().getName().endsWith(".Entity")) continue;
                isEntity = true;
                break;
            }
            if (!isEntity) {
                throw new SqlBoxException("Can not determine entityId type, if it's a entity, put @Entity annotation on it");
            }
            List<ColumnModel> Cols = model.getPKeyColsSortByColumnName();
            for (ColumnModel col : Cols) {
                Object value = ClassCacheUtils.readValueFromBeanField(entityId, col.getEntityField());
                ClassCacheUtils.writeValueToBeanField(bean, col.getEntityField(), value);
            }
        }
        return bean;
    }
}

