/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.entitynet;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.entitynet.EntityIdUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityNet {
    public static final String COMPOUND_VALUE_SEPARATOR = "__";
    private Map<String, TableModel> configs = new LinkedHashMap<String, TableModel>();
    private List<String[]> givesList = new ArrayList<String[]>();
    private List<Map<String, Object>> rowData = new ArrayList<Map<String, Object>>();
    private Map<String, LinkedHashMap<Object, Object>> body = new HashMap<String, LinkedHashMap<Object, Object>>();

    protected void core__________________________() {
    }

    public EntityNet config(Object ... entityOrModel) {
        for (Object object : entityOrModel) {
            TableModel t = SqlBoxContextUtils.configToModel(object, new Object[0]);
            SqlBoxException.assureNotNull(t.getEntityClass(), "'entityClass' property not set for model " + t);
            String alias = t.getAlias();
            if (StrUtils.isEmpty(alias)) {
                char[] chars;
                StringBuilder sb = new StringBuilder();
                for (char c : chars = t.getEntityClass().getSimpleName().toCharArray()) {
                    if (c < 'A' || c > 'Z') continue;
                    sb.append(c);
                }
                alias = sb.toString().toLowerCase();
            }
            SqlBoxException.assureNotEmpty(alias, "Alias can not be empty for class '" + t.getEntityClass() + "'");
            if (this.configs.containsKey(alias)) {
                throw new SqlBoxException("Duplicated alias '" + alias + "' for class '" + t.getEntityClass() + "' found, need use configOne method manually set alias.");
            }
            t.setAlias(alias);
            this.configs.put(alias, t);
        }
        return this;
    }

    public EntityNet configAlias(Object ... args) {
        for (int i = 0; i < args.length / 2; ++i) {
            this.configOneAlias(args[i * 2], (String)args[i * 2 + 1]);
        }
        return this;
    }

    private EntityNet configOneAlias(Object entityOrModel, String alias) {
        TableModel t = SqlBoxContextUtils.configToModel(entityOrModel, new Object[0]);
        SqlBoxException.assureNotNull(t.getEntityClass(), "'entityClass' property not set for model " + t);
        SqlBoxException.assureNotEmpty(alias, "Alias can not be empty for class '" + t.getEntityClass() + "'");
        t.setAlias(alias);
        if (this.configs.containsKey(alias)) {
            throw new SqlBoxException("Duplicated alias '" + alias + "' found, need manually set alias.");
        }
        this.configs.put(alias, t);
        return this;
    }

    public EntityNet giveBoth(String a, String b) {
        this.give(a, b);
        this.give(b, a);
        return this;
    }

    public EntityNet give(String a, String b) {
        TableModel aModel = this.configs.get(a);
        SqlBoxException.assureNotNull(aModel, "Not found config for alias '" + a + "'");
        SqlBoxException.assureNotNull(aModel.getEntityClass(), "'entityClass' property not set for model " + aModel);
        String fieldName = StrUtils.toLowerCaseFirstOne(aModel.getEntityClass().getSimpleName());
        TableModel bModel = this.configs.get(b);
        SqlBoxException.assureNotNull(bModel, "Not found config for alias '" + a + "'");
        SqlBoxException.assureNotNull(bModel.getEntityClass(), "'entityClass' property not set for model " + bModel);
        boolean found = false;
        Method readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName);
        if (readMethod != null) {
            this.give(a, b, StrUtils.toLowerCaseFirstOne(fieldName));
            found = true;
        }
        if ((readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName + "List")) != null) {
            this.give(a, b, fieldName + "List");
            found = true;
        }
        if ((readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName + "Set")) != null) {
            this.give(a, b, fieldName + "Set");
            found = true;
        }
        if ((readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName + "Map")) != null) {
            this.give(a, b, fieldName + "Map");
            found = true;
        }
        if (!found) {
            throw new SqlBoxException("Not found field '" + fieldName + "' or '" + fieldName + "List/Set/Map' in class /" + bModel.getEntityClass());
        }
        return this;
    }

    public EntityNet give(String a, String b, String someField) {
        SqlBoxException.assureNotEmpty(someField, "give field parameter can not be empty for '" + b + "'");
        this.givesList.add(new String[]{a, b, someField});
        return this;
    }

    public EntityNet translateToEntity(SqlBoxContext ctx, List<Map<String, Object>> listMap) {
        for (Map<String, Object> map : listMap) {
            this.rowData.add(map);
            this.translateToEntities(ctx, map);
            if (this.givesList.isEmpty()) continue;
            this.doGive(map);
        }
        return this;
    }

    public <T> List<T> pickEntityList(String alias) {
        return new ArrayList<Object>(this.body.get(alias).values());
    }

    public <T> Set<T> pickEntitySet(String alias) {
        return new LinkedHashSet<Object>(this.body.get(alias).values());
    }

    public <T> Map<Object, T> pickEntityMap(String alias) {
        return this.body.get(alias);
    }

    public <T> T pickOneEntity(String alias, Object entityId) {
        SqlBoxException.assureNotEmpty(alias, new String[0]);
        if (!this.configs.containsKey(alias)) {
            throw new SqlBoxException("There is no alias '" + alias + "' setting in current EntityNet.");
        }
        TableModel model = this.configs.get(alias);
        Object realEntityId = EntityIdUtils.buildEntityIdFromUnknow(entityId, model);
        if (realEntityId == null) {
            throw new SqlBoxException("Can not build entityId for '" + entityId + "'");
        }
        Map map = this.body.get(alias);
        if (map == null) {
            return null;
        }
        return (T)map.get(realEntityId);
    }

    private void translateToEntities(SqlBoxContext ctx, Map<String, Object> oneRow) {
        for (Map.Entry<String, TableModel> config : this.configs.entrySet()) {
            TableModel model = config.getValue();
            String alias = model.getAlias();
            Object entityId = EntityIdUtils.buildEntityIdFromOneRow(oneRow, model);
            if (entityId == null) continue;
            Object entity = this.getOneEntity(alias, entityId);
            if (entity == null) {
                entity = EntityNet.createEntity(ctx, oneRow, model, alias);
                this.putOneEntity(alias, entityId, entity);
            }
            oneRow.put(alias, entity);
            oneRow.put("#" + alias, entityId);
        }
    }

    private static Object createEntity(SqlBoxContext ctx, Map<String, Object> oneRow, TableModel model, String alias) {
        Object entity = ClassCacheUtils.createNewEntity(model.getEntityClass());
        ctx.getSqlBox(entity).setTableModel(model.newCopy());
        for (Map.Entry<String, Object> row : oneRow.entrySet()) {
            for (ColumnModel col : model.getColumns()) {
                if (col.getTransientable().booleanValue() || !row.getKey().equalsIgnoreCase(alias + "_" + col.getColumnName())) continue;
                SqlBoxException.assureNotEmpty(col.getEntityField(), "EntityField not set for column '" + col.getColumnName() + "'");
                ClassCacheUtils.writeValueToBeanField(entity, col.getEntityField(), row.getValue());
            }
        }
        return entity;
    }

    private void doGive(Map<String, Object> oneRow) {
        for (String[] gives : this.givesList) {
            String fromAlias = gives[0];
            String toAlias = gives[1];
            Object from = oneRow.get(fromAlias);
            Object to = oneRow.get(toAlias);
            String tofield = gives[2];
            SqlBoxException.assureNotEmpty(tofield, new String[0]);
            if (from == null || to == null) continue;
            TableModel toModel = this.configs.get(toAlias);
            ColumnModel col = toModel.getColumn(tofield);
            Method readMethod = ClassCacheUtils.getClassFieldReadMethod(toModel.getEntityClass(), col.getEntityField());
            Class<Object> fieldType = readMethod.getReturnType();
            if (fieldType.isAssignableFrom(List.class)) {
                ArrayList<Object> list = (ArrayList<Object>)ClassCacheUtils.readValueFromBeanField(to, tofield);
                if (list == null) {
                    list = new ArrayList<Object>();
                    ClassCacheUtils.writeValueToBeanField(to, tofield, list);
                }
                if (list.contains(from)) continue;
                list.add(from);
                continue;
            }
            if (fieldType.isAssignableFrom(Set.class)) {
                HashSet<Object> set = (HashSet<Object>)ClassCacheUtils.readValueFromBeanField(to, tofield);
                if (set == null) {
                    set = new HashSet<Object>();
                    ClassCacheUtils.writeValueToBeanField(to, tofield, set);
                }
                if (set.contains(from)) continue;
                set.add(from);
                continue;
            }
            if (fieldType.isAssignableFrom(Map.class)) {
                HashMap<Object, Object> map = (HashMap<Object, Object>)ClassCacheUtils.readValueFromBeanField(to, tofield);
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    ClassCacheUtils.writeValueToBeanField(to, tofield, map);
                }
                Object entityId = oneRow.get("#" + fromAlias);
                SqlBoxException.assureNotNull(entityId, "Can not find entityId for '" + fromAlias + "'");
                if (map.containsKey(entityId)) continue;
                map.put(entityId, from);
                continue;
            }
            ClassCacheUtils.writeValueToBeanField(to, tofield, from);
        }
    }

    public void putOneEntity(String alias, Object entityId, Object entity) {
        LinkedHashMap<Object, Object> entityMap = this.body.get(alias);
        if (entityMap == null) {
            entityMap = new LinkedHashMap();
            this.body.put(alias, entityMap);
        }
        entityMap.put(entityId, entity);
    }

    public Object getOneEntity(String alias, Object entityId) {
        Map entityMap = this.body.get(alias);
        if (entityMap == null) {
            return null;
        }
        return entityMap.get(entityId);
    }

    protected void getterSetter__________________________() {
    }

    public Map<String, TableModel> getConfigs() {
        return this.configs;
    }

    public EntityNet setConfigs(Map<String, TableModel> configs) {
        this.configs = configs;
        return this;
    }

    public List<Map<String, Object>> getRowData() {
        return this.rowData;
    }

    public EntityNet setRowData(List<Map<String, Object>> rowData) {
        this.rowData = rowData;
        return this;
    }

    public List<String[]> getGivesList() {
        return this.givesList;
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n=========givesList=========\r\n");
        for (String[] stringArray : this.givesList) {
            for (String str : stringArray) {
                sb.append(str + " ");
            }
            sb.append("\r\n");
        }
        sb.append("\r\n=========configs=========\r\n");
        for (TableModel tableModel : this.configs.values()) {
            sb.append(tableModel.getDebugInfo());
        }
        sb.append("\r\n=========rowData=========\r\n");
        for (Map map : this.rowData) {
            sb.append(map.toString()).append("\r\n");
        }
        sb.append("\r\n=========body=========\r\n");
        for (LinkedHashMap linkedHashMap : this.body.values()) {
            sb.append(linkedHashMap.toString()).append("\r\n");
        }
        return sb.toString();
    }

    public EntityNet addGivesList(List<String[]> givesList) {
        if (givesList == null) {
            return this;
        }
        for (String[] strings : givesList) {
            if (strings == null || strings.length < 2 || strings.length > 3) {
                throw new SqlBoxException("gives should have 2 or 3 parameters");
            }
            if (strings.length == 2) {
                this.give(strings[0], strings[1]);
                continue;
            }
            this.give(strings[0], strings[1], strings[2]);
        }
        return this;
    }

    public EntityNet setGivesList(List<String[]> givesList) {
        this.givesList = givesList;
        return this;
    }

    public Map<String, LinkedHashMap<Object, Object>> getBody() {
        return this.body;
    }

    public void setBody(Map<String, LinkedHashMap<Object, Object>> body) {
        this.body = body;
    }
}

