/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.SqlBoxStrUtils;

public class SSHandler
extends DefaultOrderSqlHandler {
    public Object[] models;

    public SSHandler() {
    }

    public SSHandler(Object ... configs) {
        if (configs == null && configs.length == 0) {
            return;
        }
        this.models = new Object[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            this.models[i] = SqlBoxContextUtils.configToModel(configs[i], new Object[0]);
        }
    }

    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        Object[] tableModels = this.models;
        if (tableModels == null) {
            tableModels = ps.getModels();
        }
        if (tableModels == null || tableModels.length == 0) {
            throw new SqlBoxException("TableModel items needed for SSHandler");
        }
        String sql = this.explainNetQuery(ps.getSql(), tableModels);
        ps.setSql(sql);
        return runner.runPreparedSQL(ps);
    }

    private String explainNetQuery(String sqlString, Object[] tableModels) {
        SqlBoxException.assureNotEmpty(sqlString, "Sql can not be empty");
        String sql = SqlBoxStrUtils.formatSQL(sqlString);
        int pos = sql.indexOf(".**");
        if (pos < 0) {
            pos = sql.indexOf(".##");
        }
        while (pos >= 0) {
            StringBuilder aliasSB = new StringBuilder();
            for (int i = pos - 1; i >= 0 && SqlBoxStrUtils.isNormalLetters(sql.charAt(i)); --i) {
                aliasSB.insert(0, sql.charAt(i));
            }
            if (aliasSB.length() == 0) {
                throw new SqlBoxException(".** can not put at front");
            }
            String alias = aliasSB.toString();
            int posAlias = StrUtils.indexOfIgnoreCase(sql = sql + " ", " as " + alias + " ");
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " as " + alias + ",");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " as " + alias + ")");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " " + alias + " ");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " " + alias + ",");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " " + alias + ")");
            }
            if (posAlias == -1) {
                throw new SqlBoxException("Alias '" + alias + "' not found");
            }
            StringBuilder tableNameSb = new StringBuilder();
            for (int i = posAlias - 1; i >= 0; --i) {
                char c = sql.charAt(i);
                if (SqlBoxStrUtils.isNormalLetters(c)) {
                    tableNameSb.insert(0, c);
                    continue;
                }
                if (tableNameSb.length() > 0) break;
            }
            if (tableNameSb.length() == 0) {
                throw new SqlBoxException("Alias '" + alias + "' not found tablename in SQL");
            }
            String tbStr = tableNameSb.toString();
            pos = (sql = SSHandler.replaceStarStarToColumn(sql, alias, tbStr, tableModels)).indexOf(".**");
            if (pos >= 0) continue;
            pos = sql.indexOf(".##");
        }
        return sql;
    }

    private static String replaceStarStarToColumn(String sql, String alias, String tableName, Object[] tableModels) {
        String result = sql;
        if (sql.contains(alias + ".**")) {
            StringBuilder sb = new StringBuilder();
            for (Object obj : tableModels) {
                TableModel tb = (TableModel)obj;
                if (!tableName.equalsIgnoreCase(tb.getTableName())) continue;
                if (StrUtils.isEmpty(tb.getAlias())) {
                    tb.setAlias(alias);
                } else if (!alias.equalsIgnoreCase(tb.getAlias())) {
                    throw new SqlBoxException("Alias '" + alias + "' not same as tableModel's alias '" + tb.getAlias() + "'");
                }
                for (ColumnModel col : tb.getColumns()) {
                    if (col.getTransientable().booleanValue()) continue;
                    sb.append(alias).append(".").append(col.getColumnName()).append(" as ").append(alias).append("_").append(col.getColumnName()).append(", ");
                }
                break;
            }
            if (sb.length() == 0) {
                throw new SqlBoxException("In SQL '" + sql + "', Can not find columns in table '" + tableName + "'");
            }
            sb.setLength(sb.length() - 2);
            result = StrUtils.replaceFirst(sql, alias + ".**", sb.toString());
            return result;
        }
        if (sql.contains(alias + ".##")) {
            StringBuilder sb = new StringBuilder();
            for (Object obj : tableModels) {
                TableModel tb = (TableModel)obj;
                if (!tableName.equalsIgnoreCase(tb.getTableName())) continue;
                if (StrUtils.isEmpty(tb.getAlias())) {
                    tb.setAlias(alias);
                } else if (!alias.equalsIgnoreCase(tb.getAlias())) {
                    throw new SqlBoxException("Alias '" + alias + "' not same as tableModel's alias");
                }
                for (ColumnModel col : tb.getColumns()) {
                    boolean found = false;
                    if (!col.getTransientable().booleanValue()) {
                        if (col.getPkey().booleanValue()) {
                            found = true;
                        } else {
                            for (FKeyModel tableModel : tb.getFkeyConstraints()) {
                                if (!tableModel.getColumnNames().contains(col.getColumnName())) continue;
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) continue;
                    sb.append(alias).append(".").append(col.getColumnName()).append(" as ").append(alias).append("_").append(col.getColumnName()).append(", ");
                }
                break;
            }
            if (sb.length() == 0) {
                throw new SqlBoxException("In SQL '" + sql + "', Can not find key columns in table '" + tableName + "'");
            }
            sb.setLength(sb.length() - 2);
            result = StrUtils.replaceFirst(result, alias + ".##", sb.toString());
        }
        return result;
    }
}

