/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import java.math.BigInteger;
import java.util.UUID;

public class UUID25Generator
implements IdGenerator {
    public static final UUID25Generator INSTANCE = new UUID25Generator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID25;
    }

    @Override
    public String getIdGenName() {
        return "UUID25";
    }

    @Override
    public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType) {
        return UUID25Generator.get25LettersRadix36UUID();
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    private static String get25LettersRadix36UUID() {
        String uuidHex = UUID.randomUUID().toString().replaceAll("-", "");
        BigInteger b = new BigInteger(uuidHex, 16);
        String s = b.toString(36);
        while (s.length() < 25) {
            s = s + "0";
        }
        return s;
    }
}

