/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActiveRecord<T>
implements ActiveRecordSupport<T> {
    SqlBoxContext ctx;

    @Override
    public SqlBoxContext ctx(Object ... optionItems) {
        for (Object item : optionItems) {
            if (item == null || !(item instanceof SqlBoxContext)) continue;
            return (SqlBoxContext)item;
        }
        if (this.ctx == null) {
            this.ctx = SqlBoxContext.globalSqlBoxContext;
        }
        if (this.ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return this.ctx;
    }

    public T useContext(SqlBoxContext ctx) {
        this.ctx = ctx;
        return (T)this;
    }

    protected void crudMethods__________________() {
    }

    @Override
    public T insert(Object ... optionItems) {
        return (T)this.ctx(optionItems).entityInsert(this, optionItems);
    }

    @Override
    public T update(Object ... optionItems) {
        return this.ctx(optionItems).entityUpdate(this, optionItems);
    }

    @Override
    public int updateTry(Object ... optionItems) {
        return this.ctx(optionItems).entityUpdateTry(this, optionItems);
    }

    @Override
    public void delete(Object ... optionItems) {
        this.ctx(optionItems).entityDelete(this, optionItems);
    }

    @Override
    public int deleteTry(Object ... optionItems) {
        return this.ctx(optionItems).entityDeleteTry(this, optionItems);
    }

    @Override
    public void deleteById(Object id, Object ... optionItems) {
        this.ctx(optionItems).entityDeleteById(this.getClass(), id, optionItems);
    }

    @Override
    public int deleteByIdTry(Object id, Object ... optionItems) {
        return this.ctx(optionItems).entityDeleteByIdTry(this.getClass(), id, optionItems);
    }

    @Override
    public boolean exist(Object ... optionItems) {
        return this.ctx(optionItems).entityExist(this, optionItems);
    }

    @Override
    public boolean existById(Object id, Object ... optionItems) {
        return this.ctx(optionItems).entityExistById(this.getClass(), id, optionItems);
    }

    @Override
    public T load(Object ... optionItems) {
        return (T)this.ctx(optionItems).entityLoad(this, optionItems);
    }

    @Override
    public int loadTry(Object ... optionItems) {
        return this.ctx(optionItems).entityLoadTry(this, optionItems);
    }

    @Override
    public T loadById(Object id, Object ... optionItems) {
        return (T)this.ctx(optionItems).entityLoadById(this.getClass(), id, optionItems);
    }

    @Override
    public T loadByIdTry(Object id, Object ... optionItems) {
        return (T)this.ctx(optionItems).entityLoadByIdTry(this.getClass(), id, optionItems);
    }

    @Override
    public List<T> findAll(Object ... optionItems) {
        return this.ctx(optionItems).entityFindAll(this.getClass(), optionItems);
    }

    @Override
    public List<T> findByIds(Iterable<?> ids, Object ... optionItems) {
        return this.ctx(optionItems).entityFindByIds(this.getClass(), ids, optionItems);
    }

    @Override
    public List<T> findBySQL(Object ... optionItems) {
        return this.ctx(optionItems).iQueryForEntityList(this.getClass(), optionItems);
    }

    @Override
    public List<T> findBySample(Object sampleBean, Object ... optionItems) {
        return this.ctx(optionItems).entityFindBySample(sampleBean, optionItems);
    }

    static Object[] insertThisClassIfNotHave(Object entity, Object ... optionItems) {
        Object[] items = optionItems;
        TableModel[] models = SqlBoxContextUtils.findAllModels(optionItems);
        if (models.length == 0) {
            throw new SqlBoxException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            items = ArrayUtils.insertArray(model, items);
        }
        return items;
    }

    @Override
    public <E> E findOneRelated(Object ... optionItems) {
        Object[] items = ActiveRecord.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedOne(this, items);
    }

    @Override
    public <E> List<E> findRelatedList(Object ... optionItems) {
        Object[] items = ActiveRecord.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedList(this, items);
    }

    @Override
    public <E> Set<E> findRelatedSet(Object ... optionItems) {
        Object[] items = ActiveRecord.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedSet(this, items);
    }

    @Override
    public <E> Map<Object, E> findRelatedMap(Object ... optionItems) {
        Object[] items = ActiveRecord.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedMap(this, items);
    }

    @Override
    public int countAll(Object ... optionItems) {
        return this.ctx(optionItems).entityCountAll(this.getClass(), optionItems);
    }

    protected void miscMethods__________________() {
    }

    @Override
    public T put(Object ... fieldAndValues) {
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            String field = (String)fieldAndValues[i * 2];
            Object value = fieldAndValues[i * 2 + 1];
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), field);
            try {
                writeMethod.invoke((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
        }
        return (T)this;
    }

    @Override
    public T putFields(String ... fieldNames) {
        lastTimePutFieldsCache.set(fieldNames);
        return (T)this;
    }

    @Override
    public T putValues(Object ... values) {
        String[] fields = (String[])lastTimePutFieldsCache.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new SqlBoxException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new SqlBoxException("putValues fields and values number not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), fields[i]);
            if (writeMethod == null) {
                throw new SqlBoxException("Not found writeMethod for '" + this.getClass() + "' class's method '" + fields[i] + "'");
            }
            try {
                writeMethod.invoke((Object)this, values[i]);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
        }
        return (T)this;
    }

    @Override
    public <U> U guess(Object ... params) {
        return this.ctx(new Object[0]).getSqlMapperGuesser().guess(this.ctx(new Object[0]), this, params);
    }

    @Override
    public String guessSQL() {
        return this.ctx(new Object[0]).getSqlMapperGuesser().guessSQL(this.ctx(new Object[0]), this);
    }

    @Override
    public PreparedSQL guessPreparedSQL(Object ... params) {
        return this.ctx(new Object[0]).getSqlMapperGuesser().doGuessPreparedSQL(this.ctx(new Object[0]), this, params);
    }

    @Override
    public SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }

    @Override
    public String shardTB(Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), optionItems);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = ClassCacheUtils.readValueFromBeanField(this, col.getColumnName());
        return SqlBoxContextUtils.getShardedTB(this.ctx(new Object[0]), model.getEntityClass(), shardKey1);
    }

    @Override
    public SqlBoxContext shardDB(Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), optionItems);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = ClassCacheUtils.readValueFromBeanField(this, col.getColumnName());
        return SqlBoxContextUtils.getShardedDB(this.ctx(new Object[0]), model.getEntityClass(), shardKey1);
    }
}

