/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.compiler;

import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.compiler.CharSequenceJavaFileObject;
import com.github.drinkjava2.jsqlbox.compiler.ClassFileManager;
import com.github.drinkjava2.jsqlbox.compiler.DynamicClassLoader;
import com.github.drinkjava2.jsqlbox.compiler.JavaClassObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class DynamicCompileEngine {
    public static final DynamicCompileEngine instance = new DynamicCompileEngine();
    private static final Map<String, Class<?>> compiledClassCache = new ConcurrentHashMap();
    private ClassLoader parentClassLoader;
    private String classpath;

    private DynamicCompileEngine() {
        this.buildClassPath();
    }

    private static String readFileToString(String filename) {
        String result = null;
        File file = new File(filename);
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            char[] chars = new char[(int)file.length()];
            reader.read(chars);
            result = new String(chars);
            reader.close();
        }
        catch (IOException e) {
            throw new SqlBoxException("Error happen when open file '" + filename + "'", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new SqlBoxException("Error happen when closing file '" + filename + "'", e);
                }
            }
        }
        return result;
    }

    private void buildClassPath() {
        this.classpath = null;
        String weblogicClazzPass = null;
        ClassLoader weblogicClassloader = this.getClass().getClassLoader();
        try {
            Method methods = weblogicClassloader.getClass().getDeclaredMethod("getClassPath", null);
            if (methods != null) {
                weblogicClazzPass = (String)methods.invoke((Object)weblogicClassloader, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!StrUtils.isEmpty(weblogicClazzPass)) {
            this.parentClassLoader = weblogicClassloader;
            this.classpath = weblogicClazzPass;
            return;
        }
        this.parentClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        StringBuilder sb = new StringBuilder();
        for (URL url : ((URLClassLoader)this.parentClassLoader).getURLs()) {
            String p = url.getFile();
            sb.append(p).append(File.pathSeparator);
        }
        this.classpath = sb.toString();
        if (this.classpath.indexOf("surefire/surefirebooter") > 0) {
            String path = StrUtils.substringAfter(this.classpath, "/");
            path = StrUtils.substringBeforeLast(path, ";");
            String mavenJarPath = DynamicCompileEngine.readFileToString(path);
            mavenJarPath = StrUtils.substringBetween(mavenJarPath, "Class-Path: ", "Main-Class: ");
            mavenJarPath = StrUtils.replace(mavenJarPath, "\r\n ", "").trim();
            mavenJarPath = StrUtils.replace(mavenJarPath, " ", ";");
            this.classpath = StrUtils.replace(mavenJarPath, "file:/", "");
        }
    }

    public Class<?> javaCodeToClass(String fullClassName, String javaCode) {
        if (StrUtils.isEmpty(fullClassName)) {
            throw new SqlBoxException("Can not compile class with empty name");
        }
        if (StrUtils.isEmpty(javaCode)) {
            throw new SqlBoxException("Can not compile class " + fullClassName + " with empty Java source code");
        }
        Class result = compiledClassCache.get(fullClassName);
        if (result != null) {
            return result;
        }
        Object instance = null;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(diagnostics, null, null));
        ArrayList<CharSequenceJavaFileObject> jfiles = new ArrayList<CharSequenceJavaFileObject>();
        jfiles.add(new CharSequenceJavaFileObject(fullClassName, javaCode));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-encoding");
        options.add("UTF-8");
        options.add("-classpath");
        options.add(this.classpath);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, jfiles);
        boolean success = task.call();
        if (success) {
            JavaClassObject jco = fileManager.getJavaClassObject();
            DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(this.parentClassLoader);
            try {
                result = dynamicClassLoader.loadClass(fullClassName, jco);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SqlBoxException(" \r\r\r <<< Dynamic Class Loadere Error \r", e);
            }
            if (result == null) {
                throw new SqlBoxException(" \r\r\r <<< Dynamic Class Loadere Null Error \r" + fullClassName);
            }
            compiledClassCache.put(fullClassName, result);
            return result;
        }
        String error = "";
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            error = error + this.compilePrint(diagnostic);
        }
        throw new SqlBoxException(error + " \r\r\r <<< Java Source Code Compile Error \r" + javaCode);
    }

    public Object javaCodeToNewInstance(String fullClassName, String javaCode) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = this.javaCodeToClass(fullClassName, javaCode);
        Object instance = clazz.newInstance();
        return instance;
    }

    private String compilePrint(Diagnostic diagnostic) {
        StringBuffer res = new StringBuffer();
        res.append("Code:[" + diagnostic.getCode() + "]\n");
        res.append("Kind:[" + (Object)((Object)diagnostic.getKind()) + "]\n");
        res.append("Position:[" + diagnostic.getPosition() + "]\n");
        res.append("Start Position:[" + diagnostic.getStartPosition() + "]\n");
        res.append("End Position:[" + diagnostic.getEndPosition() + "]\n");
        res.append("Source:[" + diagnostic.getSource() + "]\n");
        res.append("Message:[" + diagnostic.getMessage(null) + "]\n");
        res.append("LineNumber:[" + diagnostic.getLineNumber() + "]\n");
        res.append("ColumnNumber:[" + diagnostic.getColumnNumber() + "]\n");
        return res.toString();
    }
}

