/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.entitynet;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class EntityIdUtils {
    public static final String COMPOUND_ID_SEPARATOR = "__";

    public static Object buildEntityIdFromOneRow(Map<String, Object> oneRow, TableModel model, String alias) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException(" No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = oneRow.get(alias + "_" + firstPkeyCol.getColumnName());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            if ((value = oneRow.get(alias + "_" + col.getColumnName())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromEntity(Object entity, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = ClassCacheUtils.readValueFromBeanField(entity, firstPkeyCol.getEntityField());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            if ((value = ClassCacheUtils.readValueFromBeanField(entity, col.getEntityField())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromMap(Map<String, Object> map, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = map.get(firstPkeyCol.getEntityField());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            if ((value = map.get(col.getEntityField())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromUnknow(Object entityId, TableModel model) {
        Annotation[] anno;
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map mp = (Map)entityId;
            return EntityIdUtils.buildEntityIdFromMap(mp, model);
        }
        if (TypeUtils.canMapToSqlType(entityId.getClass())) {
            return entityId;
        }
        if (entityId instanceof ActiveRecordSupport) {
            return EntityIdUtils.buildEntityIdFromEntity(entityId, model);
        }
        for (Annotation annotation : anno = entityId.getClass().getAnnotations()) {
            if (!annotation.annotationType().getName().endsWith(".Entity")) continue;
            return EntityIdUtils.buildEntityIdFromEntity(entityId, model);
        }
        throw new SqlBoxException("Can not determine entityId type, if it's a entity, put @Entity annotation on it");
    }

    public static <T> T setEntityIdValues(T bean, Object entityId, TableModel model) {
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map idMap = (Map)entityId;
            for (Map.Entry item : idMap.entrySet()) {
                ClassCacheUtils.writeValueToBeanField(bean, (String)item.getKey(), item.getValue());
            }
        } else {
            if (TypeUtils.canMapToSqlType(entityId.getClass())) {
                if (model.getPKeyCount() == 0) {
                    throw new SqlBoxException("No PKey column found for '" + bean.getClass() + "'");
                }
                if (model.getPKeyCount() != 1) {
                    throw new SqlBoxException("Not give enough PKey column value for '" + bean.getClass() + "'");
                }
                ColumnModel col = model.getFirstPKeyColumn();
                ClassCacheUtils.writeValueToBeanField(bean, col.getEntityField(), entityId);
                return bean;
            }
            boolean isEntity = false;
            if (entityId instanceof ActiveRecordSupport) {
                isEntity = true;
            } else {
                Annotation[] anno;
                for (Annotation annotation : anno = entityId.getClass().getAnnotations()) {
                    if (!annotation.annotationType().getName().endsWith(".Entity")) continue;
                    isEntity = true;
                    break;
                }
            }
            if (!isEntity) {
                throw new SqlBoxException("Can not determine entityId type, if it's a entity, put @Entity annotation on it");
            }
            List<ColumnModel> cols = model.getPKeyColsSortByColumnName();
            for (ColumnModel col : cols) {
                Object value = ClassCacheUtils.readValueFromBeanField(entityId, col.getEntityField());
                ClassCacheUtils.writeValueToBeanField(bean, col.getEntityField(), value);
            }
        }
        return bean;
    }

    public static Object readFeidlValueFromEntityId(Object entityId, TableModel model, String entityFieldName) {
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map idMap = (Map)entityId;
            return idMap.get(entityFieldName);
        }
        if (TypeUtils.canMapToSqlType(entityId.getClass())) {
            return entityId;
        }
        boolean isEntity = false;
        if (entityId instanceof ActiveRecordSupport) {
            isEntity = true;
        } else {
            Annotation[] anno;
            for (Annotation annotation : anno = entityId.getClass().getAnnotations()) {
                if (!annotation.annotationType().getName().endsWith(".Entity")) continue;
                isEntity = true;
                break;
            }
        }
        if (!isEntity) {
            throw new SqlBoxException("Can not determine entityId type, if it's a entity, put @Entity annotation on it");
        }
        return ClassCacheUtils.readValueFromBeanField(entityId, entityFieldName);
    }

    public static List<Object> getOnlyOneFieldFromIds(Iterable<?> ids, TableModel model, String entityFieldName) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object entityId : ids) {
            Object realEntityId = EntityIdUtils.readFeidlValueFromEntityId(entityId, model, entityFieldName);
            result.add(realEntityId);
        }
        return result;
    }
}

