/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public class EntityListHandler
extends DefaultOrderSqlHandler {
    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        Object[] tableModels = ps.getModels();
        if (tableModels == null || tableModels.length == 0) {
            throw new SqlBoxException("TableModel setting needed for EntityListHandler");
        }
        if (tableModels.length > 1) {
            throw new SqlBoxException("TableModel setting should only have 1 for EntityListHandler");
        }
        TableModel model = (TableModel)tableModels[0];
        ps.setResultSetHandler((ResultSetHandler<?>)SingleTonHandlers.mapListHandler);
        List maps = (List)runner.runPreparedSQL(ps);
        ArrayList entityList = new ArrayList();
        for (Map row : maps) {
            Object entity = SqlBoxContextUtils.mapToEntityBean(model, row);
            entityList.add(entity);
        }
        return entityList;
    }
}

