/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.sqlitem;

import com.github.drinkjava2.jdbpro.CustomizedSqlItem;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxException;

public class EntityKeyItem
implements CustomizedSqlItem {
    private Object entity;

    public EntityKeyItem(Object entity) {
        this.entity = entity;
    }

    @Override
    public void doPrepare(PreparedSQL ps) {
        TableModel model = null;
        String alias = null;
        for (int i = 0; i < ps.getModels().length; ++i) {
            TableModel psmodel = (TableModel)ps.getModels()[i];
            if (!this.entity.getClass().equals(psmodel.getEntityClass())) continue;
            model = psmodel;
            alias = ps.getAliases()[i];
        }
        SqlBoxException.assureNotNull(model, new String[0]);
        SqlBoxException.assureNotEmpty(alias, new String[0]);
        this.doAppendEntityKeyParameters(ps, alias, model);
    }

    private void doAppendEntityKeyParameters(PreparedSQL ps, String alias, TableModel model) {
        int i = 0;
        if (model != null) {
            for (ColumnModel col : model.getColumns()) {
                if (!col.getPkey().booleanValue() || col.getTransientable().booleanValue()) continue;
                if (i > 0) {
                    ps.addSql(" and ");
                }
                ps.addSql(alias).append(".").append(col.getColumnName()).append("=? ");
                Object value = ClassCacheUtils.readValueFromBeanField(this.entity, col.getEntityField());
                ps.addParam(value);
                ++i;
            }
        }
    }
}

