/*
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later. See
 * the lgpl.txt file in the root directory or
 * <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;

/**
 * Interface for all ID generators
 * 
 * @author Yong Zhu
 * @version 1.0.0
 * @since 1.0
 */

public interface IdGenerator {// NOSONAR
	/**
	 * Get the next ID generated by implementation of IdGenerator
	 * 
	 * @param jdbc
	 *            A NormalJdbcTool implementation to access database
	 * @param dialect
	 *            The Dialect
	 * @param dataType
	 *            The {@link Type} of a column
	 * @return id generated by IdGenerator
	 */
	public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType);

	/** Return GenerationType */
	public GenerationType getGenerationType();

	/** Return a unique Id Generator name in this TableModel */
	public String getIdGenName();

	/** Return a newCopy (Deep Clone) instance */
	public IdGenerator newCopy();

	/**
	 * If depends on AutoIdGenerator, for example SortedUUIDGenerator depends on
	 * AutoIdGenerator to create start numbers
	 */
	public Boolean dependOnAutoIdGenerator();

}
