/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdialects.StrUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TextUtils {
    protected static final Map<String, String> javaFileCache = new ConcurrentHashMap<String, String>();

    public static String getJavaSourceCodeUTF8(Class<?> clazz) {
        return TextUtils.getJavaSourceCode(clazz, "UTF-8");
    }

    public static String getJavaSourceCodeUTF8(String classFullName) {
        return TextUtils.getJavaSourceCode(classFullName, "UTF-8");
    }

    public static String getJavaSourceCode(String classFullName, String encoding) {
        if (javaFileCache.containsKey(classFullName)) {
            return javaFileCache.get(classFullName);
        }
        try {
            Class<?> clazz = Class.forName(classFullName);
            return TextUtils.getJavaSourceCode(clazz, encoding);
        }
        catch (ClassNotFoundException e) {
            throw new DbProRuntimeException(e);
        }
    }

    public static String getJavaSourceCode(Class<?> clazz, String encoding) {
        if (clazz == null) {
            return null;
        }
        if (javaFileCache.containsKey(clazz.getName())) {
            return javaFileCache.get(clazz.getName());
        }
        String classPathName = StrUtils.substringBefore(clazz.getName(), "$");
        classPathName = "/" + StrUtils.replace(classPathName, ".", "/");
        String fileName = classPathName + ".java";
        InputStream inputStream = null;
        try {
            int length;
            inputStream = TextUtils.class.getResourceAsStream(fileName);
            if (inputStream == null) {
                File file = new File(clazz.getResource(classPathName + ".class").getFile());
                String absPath = file.getAbsolutePath();
                String projectFolder = StrUtils.substringBefore(absPath = StrUtils.replace(absPath, "\\", "/"), "/target/");
                String realFile = projectFolder + "/src/main/resources" + classPathName + ".java";
                file = new File(realFile);
                if (!file.exists()) {
                    realFile = projectFolder + "/src/test/resources" + classPathName + ".java";
                    file = new File(realFile);
                }
                if (!file.exists()) {
                    throw new IOException("Can not find '" + realFile + "' in resources folder");
                }
                inputStream = new FileInputStream(file);
                if (inputStream == null) {
                    throw new IOException("Error happen when open file '" + realFile + "'");
                }
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String javaSrc = result.toString(encoding);
            javaFileCache.put(clazz.getName(), javaSrc);
            String string = javaSrc;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

