/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.handler;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;

public class TitleArrayListHandler
implements ResultSetHandler<List<Object[]>> {
    public List<Object[]> handle(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        String[] titles = new String[cols];
        for (int i = 1; i <= cols; ++i) {
            String columnName = rsmd.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            titles[i - 1] = columnName;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        rows.add(titles);
        while (rs.next()) {
            rows.add(this.toArray(rs, cols));
        }
        return rows;
    }

    public Object[] toArray(ResultSet rs, int cols) throws SQLException {
        Object[] result = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            result[i] = rs.getObject(i + 1);
        }
        return result;
    }
}

