/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.util.Arrays;
import java.util.List;

public abstract class DebugUtils {
    public static String getColumnModelDebugInfo(ColumnModel c) {
        StringBuilder sb = new StringBuilder();
        sb.append("columnName=" + c.getColumnName()).append(", ");
        sb.append("transient=" + c.getTransientable()).append(", ");
        sb.append("type=" + (Object)((Object)c.getColumnType())).append(", ");
        sb.append("pkey=" + c.getPkey()).append(", ");
        sb.append("shardTable=" + c.getShardTable()).append(", ");
        sb.append("shardDatabase=" + c.getShardDatabase()).append(", ");
        sb.append("idGenerationType=" + (Object)((Object)c.getIdGenerationType())).append(", ");
        sb.append("idGeneratorName=" + c.getIdGeneratorName()).append(", ");
        sb.append("idGenerator=" + c.getIdGenerator()).append(", ");
        sb.append("lengths=");
        if (c.getLengths() != null) {
            sb.append(Arrays.deepToString(c.getLengths()));
        }
        sb.append(", ");
        sb.append("entityField=" + c.getEntityField()).append(", ");
        sb.append("length=" + c.getLength()).append(", ");
        sb.append("precisio=" + c.getPrecision()).append(", ");
        sb.append("scale" + c.getScale()).append(", ");
        return sb.toString();
    }

    public static String getFkeyDebugInfo(TableModel t) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fkeys:\r\n");
        for (FKeyModel k : t.getFkeyConstraints()) {
            sb.append("FkeyName=" + k.getFkeyName());
            sb.append(", ColumnNames=" + k.getColumnNames());
            sb.append(", RefTableAndColumns=" + Arrays.deepToString(k.getRefTableAndColumns()));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelDebugInfo(TableModel model) {
        StringBuilder sb = new StringBuilder("\r\n=======================================================\r\n");
        sb.append("tableName=" + model.getTableName()).append("\r\n");
        sb.append("getEntityClass=" + model.getEntityClass()).append("\r\n");
        sb.append("readOnly=" + model.getReadOnly()).append("\r\n");
        sb.append(DebugUtils.getFkeyDebugInfo(model));
        List<ColumnModel> columns = model.getColumns();
        sb.append("Columns:\r\n");
        for (ColumnModel column : columns) {
            sb.append(DebugUtils.getColumnModelDebugInfo(column)).append("\r\n");
        }
        return sb.toString();
    }

    public static String getTableModelsDebugInfo(TableModel[] models) {
        StringBuilder sb = new StringBuilder();
        for (TableModel model : models) {
            sb.append(DebugUtils.getTableModelDebugInfo(model));
        }
        return sb.toString();
    }
}

