/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;

public class SequenceIdGenerator
implements IdGenerator {
    private String name;
    private String sequenceName;
    private Integer initialValue = 0;
    private Integer allocationSize = 1;

    public SequenceIdGenerator() {
    }

    public SequenceIdGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.name = name;
        this.sequenceName = sequenceName;
        this.initialValue = initialValue;
        this.allocationSize = allocationSize;
    }

    @Override
    public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType) {
        DialectException.assureNotEmpty(this.sequenceName, "sequenceName can not be empty");
        String sequenctSQL = dialect.getDdlFeatures().getSequenceNextValString();
        sequenctSQL = StrUtils.replace(sequenctSQL, "_SEQNAME", this.sequenceName);
        return jdbc.nQueryForObject(sequenctSQL, new Object[0]);
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.SEQUENCE;
    }

    @Override
    public String getIdGenName() {
        return this.name;
    }

    @Override
    public IdGenerator newCopy() {
        return new SequenceIdGenerator(this.name, this.sequenceName, this.initialValue, this.allocationSize);
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Integer initialValue) {
        this.initialValue = initialValue;
    }

    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.allocationSize = allocationSize;
    }
}

