/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.entitynet;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.EntityType;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class EntityIdUtils {
    public static final String COMPOUND_ID_SEPARATOR = "__";

    public static Object buildEntityIdFromOneRow(String[] titles, Object[] oneRow, TableModel model, String alias) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException(" No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = null;
        String keColName = alias + "_" + firstPkeyCol.getColumnName();
        for (int i = 0; i < titles.length; ++i) {
            if (!titles[i].equalsIgnoreCase(keColName)) continue;
            firstPKeyValue = oneRow[i];
        }
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            if (sb.length() > 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            Object value = null;
            keColName = alias + "_" + col.getColumnName();
            for (int i = 0; i < titles.length; ++i) {
                if (!titles[i].equalsIgnoreCase(keColName)) continue;
                value = oneRow[i];
            }
            if (value == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromEntity(Object entity, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = SqlBoxContextUtils.readValueFromBeanFieldOrTail(entity, firstPkeyCol);
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            if ((value = SqlBoxContextUtils.readValueFromBeanFieldOrTail(entity, col)) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromMap(Map<String, Object> map, TableModel model) {
        int pkeyCount = model.getPKeyCount();
        if (pkeyCount == 0) {
            throw new SqlBoxException("No Pkey setting for '" + model.getTableName() + "'");
        }
        ColumnModel firstPkeyCol = model.getFirstPKeyColumn();
        Object firstPKeyValue = map.get(firstPkeyCol.getEntityField());
        if (firstPKeyValue == null) {
            return null;
        }
        if (pkeyCount == 1) {
            return firstPKeyValue;
        }
        List<ColumnModel> l = model.getPKeyColsSortByColumnName();
        StringBuilder sb = new StringBuilder();
        for (ColumnModel col : l) {
            Object value;
            if (sb.length() > 0) {
                sb.append(COMPOUND_ID_SEPARATOR);
            }
            if ((value = map.get(col.getEntityField())) == null) {
                return null;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static Object buildEntityIdFromUnknow(Object entityId, TableModel model) {
        Annotation[] anno;
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map mp = (Map)entityId;
            return EntityIdUtils.buildEntityIdFromMap(mp, model);
        }
        if (TypeUtils.canMapToSqlType(entityId.getClass())) {
            return entityId;
        }
        if (entityId instanceof EntityType) {
            return EntityIdUtils.buildEntityIdFromEntity(entityId, model);
        }
        for (Annotation annotation : anno = entityId.getClass().getAnnotations()) {
            if (!annotation.annotationType().getName().endsWith(".Entity")) continue;
            return EntityIdUtils.buildEntityIdFromEntity(entityId, model);
        }
        throw new SqlBoxException("Can not determine entityId type, if it's a entity, put @Entity annotation on it");
    }

    public static <T> T setEntityIdValues(T bean, Object entityId, Collection<ColumnModel> cols) {
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map idMap = (Map)entityId;
            for (Map.Entry item : idMap.entrySet()) {
                ClassCacheUtils.writeValueToBeanField(bean, (String)item.getKey(), item.getValue());
            }
            return bean;
        }
        if (TypeUtils.canMapToSqlType(entityId.getClass())) {
            for (ColumnModel col : cols) {
                if (col.getTransientable().booleanValue() || !col.getPkey().booleanValue()) continue;
                SqlBoxContextUtils.writeValueToBeanFieldOrTail(bean, col, entityId);
                return bean;
            }
            throw new SqlBoxException("No primary key configuration found");
        }
        for (ColumnModel col : cols) {
            if (!col.getPkey().booleanValue()) continue;
            Object value = SqlBoxContextUtils.readValueFromBeanFieldOrTail(entityId, col);
            SqlBoxContextUtils.writeValueToBeanFieldOrTail(bean, col, value);
        }
        return bean;
    }

    public static Object readFeidlValueFromEntityId(Object entityId, ColumnModel col) {
        SqlBoxException.assureNotNull(entityId, "entityId can not be null.");
        if (entityId instanceof Map) {
            Map idMap = (Map)entityId;
            if (idMap.containsKey(col.getEntityField())) {
                return idMap.get(col.getEntityField());
            }
            return idMap.get(col.getColumnName());
        }
        if (TypeUtils.canMapToSqlType(entityId.getClass())) {
            return entityId;
        }
        return SqlBoxContextUtils.readValueFromBeanFieldOrTail(entityId, col);
    }
}

