/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.sharding;

import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.util.Collection;
import java.util.HashSet;

public class ShardingRangeTool
implements ShardingTool {
    @Override
    public String[] handleShardTable(SqlBoxContext ctx, TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardTableColumn();
        if (col == null) {
            throw new SqlBoxException("Not found ShardTable setting for table '" + model.getTableName() + "'");
        }
        if (!"RANGE".equalsIgnoreCase(col.getShardTable()[0])) {
            return null;
        }
        String tableSize = col.getShardTable()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        SqlBoxException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new SqlBoxException("ShardTable key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new SqlBoxException("ShardTable key value can not be null");
        }
        if (shardkey2 != null) {
            return ShardingRangeTool.calculateTableNames(model.getTableName(), shardKey1, shardkey2, tableSize);
        }
        HashSet<String> set = new HashSet<String>();
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingRangeTool.calculateTableName(model.getTableName(), key, tableSize));
            }
            return set.toArray(new String[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingRangeTool.calculateTableName(model.getTableName(), key, tableSize));
            }
            return set.toArray(new String[set.size()]);
        }
        set.add(ShardingRangeTool.calculateTableName(model.getTableName(), shardKey1, tableSize));
        return set.toArray(new String[set.size()]);
    }

    @Override
    public SqlBoxContext[] handleShardDatabase(SqlBoxContext ctx, TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null) {
            throw new SqlBoxException("Not found ShardDatabase setting for table '" + model.getTableName() + "'");
        }
        if (!"RANGE".equalsIgnoreCase(col.getShardDatabase()[0])) {
            return null;
        }
        String tableSize = col.getShardDatabase()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        SqlBoxException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new SqlBoxException("ShardDatabase key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new SqlBoxException("ShardDatabase key value can not be null");
        }
        if (shardkey2 != null) {
            return ShardingRangeTool.calculateDatabases(ctx, shardKey1, shardkey2, tableSize);
        }
        HashSet<SqlBoxContext> set = new HashSet<SqlBoxContext>();
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingRangeTool.calculateDatabase(ctx, key, tableSize));
            }
            return set.toArray(new SqlBoxContext[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingRangeTool.calculateDatabase(ctx, key, tableSize));
            }
            return set.toArray(new SqlBoxContext[set.size()]);
        }
        return new SqlBoxContext[]{ShardingRangeTool.calculateDatabase(ctx, shardKey1, tableSize)};
    }

    private static String calculateTableName(String tableName, Object keyValue, String tableSize) {
        long shardKeyValue = Long.parseLong(String.valueOf(keyValue));
        long size = Long.parseLong(tableSize);
        return new StringBuffer(tableName).append("_").append(shardKeyValue / size).toString();
    }

    private static String[] calculateTableNames(String tableName, Object firstKey, Object secondKey, String tableSize) {
        int firstTable;
        long size;
        long from = Long.parseLong(String.valueOf(firstKey));
        long last = Long.parseLong(String.valueOf(secondKey));
        int lastTable = (int)(last / (size = Long.parseLong(String.valueOf(tableSize))));
        if (lastTable < (firstTable = (int)(from / size))) {
            return new String[0];
        }
        String[] result = new String[lastTable - firstTable + 1];
        for (int i = firstTable; i <= lastTable; ++i) {
            result[i - firstTable] = new StringBuffer(tableName).append("_").append(i).toString();
        }
        return result;
    }

    private static SqlBoxContext calculateDatabase(SqlBoxContext ctx, Object keyValue, String tableSize) {
        long shardKeyValue = Long.parseLong(String.valueOf(keyValue));
        long size = Long.parseLong(String.valueOf(tableSize));
        return (SqlBoxContext)ctx.getMasters()[(int)(shardKeyValue / size)];
    }

    private static SqlBoxContext[] calculateDatabases(SqlBoxContext ctx, Object firstKey, Object secondKey, String tableSize) {
        int firstTable;
        long size;
        long from = Long.parseLong(String.valueOf(firstKey));
        long last = Long.parseLong(String.valueOf(secondKey));
        int lastTable = (int)(last / (size = Long.parseLong(String.valueOf(tableSize))));
        if (lastTable < (firstTable = (int)(from / size))) {
            return new SqlBoxContext[0];
        }
        SqlBoxContext[] result = new SqlBoxContext[lastTable - firstTable + 1];
        for (int i = firstTable; i <= lastTable; ++i) {
            result[i - firstTable] = (SqlBoxContext)ctx.getMasters()[i];
        }
        return result;
    }
}

