/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.spring;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.DataSource;

public class SpringTxConnectionManager
implements ConnectionManager {
    protected final Method getConnectionMethod;
    protected final Method releaseConnectionMethod;
    protected final Method getResourceMethod;

    public SpringTxConnectionManager() {
        Class<?> transactionSynchronizationManagerClass;
        Class<?> dataSourceUtilClass;
        try {
            dataSourceUtilClass = Class.forName("org.springframework.jdbc.datasource.DataSourceUtils");
        }
        catch (ClassNotFoundException e) {
            throw new TransactionsException("Error:spring-jdbc jar missing, fail to build SpringTxConnectionManager.", e);
        }
        try {
            transactionSynchronizationManagerClass = Class.forName("org.springframework.transaction.support.TransactionSynchronizationManager");
        }
        catch (ClassNotFoundException e) {
            throw new TransactionsException("Error:spring-tx jar missing, fail to build SpringTxConnectionManager.", e);
        }
        try {
            this.getConnectionMethod = dataSourceUtilClass.getMethod("getConnection", DataSource.class);
            this.releaseConnectionMethod = dataSourceUtilClass.getMethod("releaseConnection", Connection.class, DataSource.class);
            this.getResourceMethod = transactionSynchronizationManagerClass.getMethod("getResource", Object.class);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager initialize failed.", e);
        }
    }

    public static final SpringTxConnectionManager instance() {
        return SpringTxConnectionManagerSingleton.INSTANCE;
    }

    @Override
    public Connection getConnection(DataSource dataSource) {
        try {
            return (Connection)this.getConnectionMethod.invoke(null, dataSource);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager fail to get connection from dataSource.", e);
        }
    }

    @Override
    public void releaseConnection(Connection conn, DataSource dataSource) {
        try {
            this.releaseConnectionMethod.invoke(null, conn, dataSource);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager fail to release connection.", e);
        }
    }

    @Override
    public boolean isInTransaction(DataSource ds) {
        if (ds == null) {
            return false;
        }
        try {
            return null != this.getResourceMethod.invoke(null, ds);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager fail to get transaction status.", e);
        }
    }

    private static class SpringTxConnectionManagerSingleton {
        private static final SpringTxConnectionManager INSTANCE = new SpringTxConnectionManager();

        private SpringTxConnectionManagerSingleton() {
        }
    }
}

