/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.tinytx.TinyTxConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TinyTx
implements MethodInterceptor {
    private static final TinyTxConnectionManager cm = TinyTxConnectionManager.instance();
    private int transactionIsolation = 2;
    private DataSource ds;

    public TinyTx() {
    }

    public TinyTx(DataSource ds) {
        this.ds = ds;
    }

    public TinyTx(DataSource ds, Integer transactionIsolation) {
        this.ds = ds;
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public Object invoke(MethodInvocation caller) {
        Connection conn;
        if (cm.isInTransaction(this.ds)) {
            try {
                return caller.proceed();
            }
            catch (Throwable t) {
                throw new TransactionsException(t);
            }
        }
        try {
            conn = cm.getConnection(this.ds);
            TransactionsException.assureNotNull(conn, "Connection can not get from DataSource in invoke method");
        }
        catch (Exception e) {
            throw new TransactionsException(e);
        }
        Object invokeResult = null;
        try {
            cm.startTransaction(this.ds, conn);
            conn.setTransactionIsolation(this.transactionIsolation);
            conn.setAutoCommit(false);
            invokeResult = caller.proceed();
            conn.commit();
        }
        catch (Throwable t) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    throw new TransactionsException("TinyTx fail to rollback a transaction.", t);
                }
            }
            throw new TransactionsException("TinyTx found a runtime Exception, transaction rollbacked.", t);
        }
        finally {
            cm.endTransaction(this.ds);
            SQLException closeExp = null;
            try {
                cm.releaseConnection(conn, this.ds);
            }
            catch (SQLException e) {
                closeExp = e;
            }
            if (closeExp != null) {
                throw new TransactionsException("Exception happen when release connection.", closeExp);
            }
        }
        return invokeResult;
    }
}

