/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class TinyTxConnectionManager
implements ConnectionManager {
    public static final ThreadLocal<Map<DataSource, Connection>> threadLocalConnections = new ThreadLocal<Map<DataSource, Connection>>(){

        @Override
        protected Map<DataSource, Connection> initialValue() {
            return new HashMap<DataSource, Connection>();
        }
    };

    public static final TinyTxConnectionManager instance() {
        return InnerTinyTxConnectionManager.INSTANCE;
    }

    @Override
    public boolean isInTransaction(DataSource ds) {
        TransactionsException.assureNotNull(ds, "DataSource can not be null in isInTransaction method");
        return null != threadLocalConnections.get().get(ds);
    }

    public void startTransaction(DataSource ds, Connection conn) {
        TransactionsException.assureNotNull(ds, "DataSource can not be null in startTransaction method");
        threadLocalConnections.get().put(ds, conn);
    }

    public void endTransaction(DataSource ds) {
        TransactionsException.assureNotNull(ds, "DataSource can not be null in endTransaction method");
        threadLocalConnections.get().remove(ds);
    }

    @Override
    public Connection getConnection(DataSource ds) throws SQLException {
        TransactionsException.assureNotNull(ds, "DataSource can not be null");
        Connection conn = threadLocalConnections.get().get(ds);
        if (conn == null) {
            conn = ds.getConnection();
        }
        TransactionsException.assureNotNull(conn, "Fail to get a connection from DataSource");
        return conn;
    }

    @Override
    public void releaseConnection(Connection conn, DataSource ds) throws SQLException {
        Connection saved = threadLocalConnections.get().get(ds);
        if ((saved == null || saved != conn) && conn != null) {
            conn.close();
        }
    }

    private static class InnerTinyTxConnectionManager {
        private static final TinyTxConnectionManager INSTANCE = new TinyTxConnectionManager();

        private InnerTinyTxConnectionManager() {
        }
    }
}

