/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import java.util.HashMap;
import java.util.Map;

public class DialectFunctionTemplate {
    private static void copyTo(Map lastMap, Dialect d) {
        Map<String, String> target = d.functions;
        target.clear();
        target.putAll(lastMap);
    }

    protected static void initFunctionTemplates() {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("mod", "1=$P1|2=$P1 % $P2");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("random", "0=random()");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("quote", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P2, $P1)");
        mp.put("sqrt", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("max", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "*");
        mp.put("count", "*");
        mp.put("length", "*");
        mp.put("concat", "$Lined_Params");
        mp.put("bit_length", "*");
        mp.put("substr", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("round", "*");
        mp.put("nullif", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.SQLiteDialect);
        mp.remove("random");
        mp.remove("quote");
        mp.put("mod", "*");
        mp.put("isnull", "*");
        mp.put("year", "*");
        mp.put("character_length", "*");
        mp.put("bin", "*");
        mp.put("from_days", "*");
        mp.put("degrees", "*");
        mp.put("rand", "0=rand()");
        mp.put("octet_length", "*");
        mp.put("trim", "*");
        mp.put("len", "*");
        mp.put("char_length", "*");
        mp.put("instr", "*");
        mp.put("hex", "*");
        mp.put("exp", "*");
        mp.put("atan2", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("oct", "*");
        mp.put("ceil", "*");
        mp.put("substr", "stuff($Params)");
        mp.put("dayofyear", "*");
        mp.put("microsecond", "*");
        mp.put("trunc", "*");
        mp.put("left", "*");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("datediff", "*");
        mp.put("encrypt", "*");
        mp.put("power", "*");
        mp.put("log2", "*");
        mp.put("timestamp", "*");
        mp.put("timediff", "*");
        mp.put("right", "*");
        mp.put("reverse", "*");
        mp.put("dayname", "*");
        mp.put("soundex", "*");
        mp.put("char", "*");
        mp.put("last_day", "*");
        mp.put("quarter", "*");
        mp.put("md5", "*");
        mp.put("date", "*");
        mp.put("ln", "*");
        mp.put("cos", "*");
        mp.put("sign", "*");
        mp.put("replace", "*");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("space", "*");
        mp.put("translate", "*");
        mp.put("second", "*");
        mp.put("sysdate", "0=sysdate()");
        mp.put("lpad", "*");
        mp.put("monthname", "*");
        mp.put("crc32", "*");
        mp.put("day", "*");
        mp.put("tan", "*");
        mp.put("nvl", "*");
        mp.put("ltrim", "*");
        mp.put("acos", "*");
        mp.put("chr", "char($Params)");
        mp.put("extract", "*");
        mp.put("month", "*");
        mp.put("ucase", "*");
        mp.put("lcase", "*");
        mp.put("to_days", "*");
        mp.put("week", "*");
        mp.put("locate", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("radians", "*");
        mp.put("substring", "*");
        mp.put("dayofmonth", "*");
        mp.put("hour", "*");
        mp.put("rpad", "*");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("floor", "*");
        mp.put("ascii", "*");
        mp.put("ceiling", "*");
        mp.put("initcap", "*");
        mp.put("rtrim", "*");
        mp.put("minute", "*");
        mp.put("dayofweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("asin", "*");
        mp.put("time", "*");
        mp.put("weekofyear", "*");
        mp.put("user", "0=user");
        DialectFunctionTemplate.copyTo(mp, Dialect.AccessDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.ExcelDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.TextDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.ParadoxDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.CobolDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.XMLDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DbfDialect);
        mp.clear();
        mp.put("mod", "{fn mod($Params)}");
        mp.put("isnull", "isnull($Compact_Params)");
        mp.put("year", "{fn year($Params)}");
        mp.put("cos", "{fn cos($Params)}");
        mp.put("character_length", "*");
        mp.put("upper", "*");
        mp.put("sign", "*");
        mp.put("cot", "{fn cot($Params)}");
        mp.put("atan", "{fn atan($Params)}");
        mp.put("space", "*");
        mp.put("second", "{fn second($Params)}");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("sysdate", "0=sysdate");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("len", "*");
        mp.put("sqrt", "{fn SQRT($Params)}");
        mp.put("char_length", "*");
        mp.put("monthname", "{fn monthname($Params)}");
        mp.put("exp", "{fn exp($Params)}");
        mp.put("day", "*");
        mp.put("tan", "{fn tan($Params)}");
        mp.put("curtime", "{fn curtime($Params)}");
        mp.put("nvl", "$NVL_Params");
        mp.put("ltrim", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "coalesce($Compact_Params)");
        mp.put("count", "*");
        mp.put("concat", "$Lined_Params");
        mp.put("acos", "{fn acos($Params)}");
        mp.put("substr", "substr($Compact_Params)");
        mp.put("dayofyear", "{fn dayofyear($Params)}");
        mp.put("str", "str($Compact_Params)");
        mp.put("current_date", "0=current_date");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "{fn month($Params)}");
        mp.put("left", "{fn left($Params)}");
        mp.put("ucase", "{fn ucase($Params)}");
        mp.put("nullif", "nullif($Compact_Params)");
        mp.put("lcase", "{fn lcase($Params)}");
        mp.put("to_char", "to_char($Compact_Params)");
        mp.put("week", "{fn user($Params)}");
        mp.put("locate", "$FIND($Params)");
        mp.put("log", "{fn log($Params)}");
        mp.put("log10", "{fn log($Params)}");
        mp.put("sum", "*");
        mp.put("curdate", "{fn curdate($Params)}");
        mp.put("substring", "substring($Compact_Params)");
        mp.put("dayofmonth", "{fn dayofmonth($Params)}");
        mp.put("datediff", "datediff($Compact_Params)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "{fn hour($Params)}");
        mp.put("to_date", "todate($Compact_Params)");
        mp.put("current_timestamp", "*");
        mp.put("now", "{fn monthname($Params)}");
        mp.put("sin", "{fn sin($Params)}");
        mp.put("power", "power($Compact_Params)");
        mp.put("floor", "*");
        mp.put("ascii", "*");
        mp.put("current_time", "0=current_time");
        mp.put("ceiling", "*");
        mp.put("max", "*");
        mp.put("length", "*");
        mp.put("rtrim", "*");
        mp.put("right", "{fn right($Params)}");
        mp.put("bit_length", "1=($length($P1)*8)");
        mp.put("minute", "{fn minute($Params)}");
        mp.put("abs", "*");
        mp.put("round", "round($Compact_Params)");
        mp.put("dayname", "{fn dayname($Params)}");
        mp.put("char", "{fn char($Params)}");
        mp.put("dayofweek", "{fn dayofweek($Params)}");
        mp.put("pi", "{fn pi($Params)}");
        mp.put("asin", "{fn asin($Params)}");
        mp.put("user", "{fn user($Params)}");
        mp.put("quarter", "{fn quarter($Params)}");
        DialectFunctionTemplate.copyTo(mp, Dialect.Cache71Dialect);
        mp.remove("ceiling");
        mp.remove("isnull");
        mp.remove("len");
        mp.remove("left");
        mp.remove("log");
        mp.remove("dayname");
        mp.remove("char");
        mp.remove("monthname");
        mp.remove("right");
        mp.put("mod", "*");
        mp.put("year", "*");
        mp.put("bin", "*");
        mp.put("weekday", "*");
        mp.put("localtimestamp", "0=localtimestamp");
        mp.put("from_days", "*");
        mp.put("degrees", "*");
        mp.put("rand", "0=rand()");
        mp.put("octet_length", "*");
        mp.put("trim", "*");
        mp.put("sqrt", "*");
        mp.put("utc_time", "0=utc_time()");
        mp.put("instr", "*");
        mp.put("hex", "*");
        mp.put("exp", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("coalesce", "*");
        mp.put("ceil", "*");
        mp.put("substr", "*");
        mp.put("dayofyear", "*");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("trunc", "*");
        mp.put("log10", "*");
        mp.put("datediff", "*");
        mp.put("time_to_sec", "*");
        mp.put("power", "*");
        mp.put("unix_timestamp", "*");
        mp.put("log2", "*");
        mp.put("timestamp", "*");
        mp.put("timediff", "*");
        mp.put("reverse", "*");
        mp.put("last_day", "*");
        mp.put("quarter", "*");
        mp.put("md5", "*");
        mp.put("date", "*");
        mp.put("localtime", "0=localtime");
        mp.put("ln", "*");
        mp.put("cos", "*");
        mp.put("replace", "*");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("translate", "*");
        mp.put("second", "*");
        mp.put("lpad", "*");
        mp.put("tan", "*");
        mp.put("nvl", "*");
        mp.put("acos", "*");
        mp.put("chr", "*");
        mp.put("from_unixtime", "*");
        mp.put("month", "*");
        mp.put("ucase", "*");
        mp.put("nullif", "*");
        mp.put("lcase", "*");
        mp.put("to_char", "*");
        mp.put("to_days", "*");
        mp.put("week", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("sec_to_time", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("radians", "*");
        mp.put("substring", "*");
        mp.put("dayofmonth", "*");
        mp.put("random", "0=random()");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("to_date", "*");
        mp.put("rpad", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("stddev", "*");
        mp.put("bit_length", "*");
        mp.put("minute", "*");
        mp.put("round", "*");
        mp.put("variance", "*");
        mp.put("dayofweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("bit_count", "*");
        mp.put("asin", "*");
        mp.put("time", "*");
        mp.put("utc_date", "0=utc_date()");
        mp.put("user", "0=user");
        DialectFunctionTemplate.copyTo(mp, Dialect.CUBRIDDialect);
        mp.clear();
        mp.put("ln", "*");
        mp.put("mod", "*");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("cos", "*");
        mp.put("upper", "*");
        mp.put("sign", "*");
        mp.put("replace", "*");
        mp.put("atan", "*");
        mp.put("translate", "*");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("sysdate", "0=sysdate");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("lpad", "*");
        mp.put("instr", "*");
        mp.put("exp", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("atan2", "*");
        mp.put("tan", "*");
        mp.put("nvl", "*");
        mp.put("ltrim", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "$NVL_Params");
        mp.put("count", "*");
        mp.put("concat", "$Lined_Params");
        mp.put("acos", "*");
        mp.put("ceil", "*");
        mp.put("chr", "*");
        mp.put("substr", "*");
        mp.put("str", "to_char($Params)");
        mp.put("current_date", "0=current_date");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("trunc", "*");
        mp.put("nullif", "*");
        mp.put("to_char", "*");
        mp.put("locate", "2=instr($P2,$P1)");
        mp.put("log", "*");
        mp.put("sum", "*");
        mp.put("substring", "substr($Params)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("to_date", "*");
        mp.put("rpad", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("sin", "*");
        mp.put("power", "*");
        mp.put("floor", "*");
        mp.put("stddev", "*");
        mp.put("ascii", "*");
        mp.put("current_time", "0=current_timestamp");
        mp.put("initcap", "*");
        mp.put("max", "*");
        mp.put("length", "*");
        mp.put("rtrim", "*");
        mp.put("bit_length", "1=vsize($P1)*8");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("abs", "*");
        mp.put("round", "*");
        mp.put("variance", "*");
        mp.put("soundex", "*");
        mp.put("asin", "*");
        mp.put("last_day", "*");
        mp.put("user", "0=user");
        DialectFunctionTemplate.copyTo(mp, Dialect.DataDirectOracle9Dialect);
        mp.remove("initcap");
        mp.remove("nvl");
        mp.remove("replace");
        mp.remove("translate");
        mp.remove("sysdate");
        mp.remove("trunc");
        mp.remove("to_date");
        mp.remove("rpad");
        mp.remove("lpad");
        mp.remove("instr");
        mp.remove("power");
        mp.remove("last_day");
        mp.remove("to_char");
        mp.remove("ascii");
        mp.remove("user");
        mp.remove("atan2");
        mp.put("date", "*");
        mp.put("year", "*");
        mp.put("cot", "*");
        mp.put("degrees", "*");
        mp.put("second", "*");
        mp.put("rand", "0=rand()");
        mp.put("monthname", "*");
        mp.put("hex", "*");
        mp.put("day", "*");
        mp.put("coalesce", "*");
        mp.put("dayofyear", "*");
        mp.put("str", "1=rtrim(char($P1))");
        mp.put("current_date", "0=current date");
        mp.put("microsecond", "*");
        mp.put("month", "*");
        mp.put("ucase", "*");
        mp.put("lcase", "*");
        mp.put("week", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("log10", "*");
        mp.put("radians", "*");
        mp.put("avg", "1=avg(cast($P1 as double))");
        mp.put("hour", "*");
        mp.put("current_timestamp", "0=current timestamp");
        mp.put("current_time", "0=current time");
        mp.put("timestamp", "*");
        mp.put("ceiling", "*");
        mp.put("bit_length", "1=length($P1)*8");
        mp.put("minute", "*");
        mp.put("dayname", "*");
        mp.put("char", "*");
        mp.put("dayofweek", "*");
        mp.put("time", "*");
        mp.put("quarter", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.DB2Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DB2390Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DB2390V8Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DB2400Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DB297Dialect);
        mp.put("trim", "1=trim(both ' ' from $P1)|2=trim(both $P1 from $P2)");
        mp.put("concat", "($Lined_Params)");
        DialectFunctionTemplate.copyTo(mp, Dialect.DerbyDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DerbyTenFiveDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DerbyTenSevenDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.DerbyTenSixDialect);
        mp.clear();
        mp.put("mod", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("replace", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("max", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "*");
        mp.put("count", "*");
        mp.put("length", "*");
        mp.put("concat", "($Lined_Params)");
        mp.put("bit_length", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("current_date", "0=current_date");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("nullif", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.FirebirdDialect);
        mp.remove("current_date");
        mp.remove("replace");
        mp.remove("concat");
        DialectFunctionTemplate.copyTo(mp, Dialect.FrontBaseDialect);
        mp.put("cos", "*");
        mp.put("sign", "*");
        mp.put("replace", "*");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("degrees", "*");
        mp.put("space", "*");
        mp.put("rand", "0=rand()");
        mp.put("octet_length", "*");
        mp.put("monthname", "*");
        mp.put("exp", "*");
        mp.put("atan2", "*");
        mp.put("tan", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("ltrim", "*");
        mp.put("concat", "($Lined_Params)");
        mp.put("acos", "*");
        mp.put("dayofyear", "*");
        mp.put("current_date", "0=current_date()");
        mp.put("left", "*");
        mp.put("ucase", "*");
        mp.put("lcase", "*");
        mp.put("week", "*");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("radians", "*");
        mp.put("dayofmonth", "*");
        mp.put("datediff", "*");
        mp.put("avg", "1=avg(cast($P1 as double))");
        mp.put("current_timestamp", "0=current_timestamp()");
        mp.put("encrypt", "*");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("power", "*");
        mp.put("floor", "*");
        mp.put("ascii", "*");
        mp.put("current_time", "0=current_time()");
        mp.put("ceiling", "*");
        mp.put("rtrim", "*");
        mp.put("right", "*");
        mp.put("round", "*");
        mp.put("dayname", "*");
        mp.put("soundex", "*");
        mp.put("char", "*");
        mp.put("dayofweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("asin", "*");
        mp.put("user", "0=user()");
        mp.put("quarter", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.H2Dialect);
        mp.remove("curtime");
        mp.remove("ceiling");
        mp.remove("log10");
        mp.remove("curdate");
        mp.remove("radians");
        mp.remove("atan");
        mp.remove("degrees");
        mp.remove("space");
        mp.remove("rand");
        mp.remove("datediff");
        mp.remove("octet_length");
        mp.remove("encrypt");
        mp.remove("soundex");
        mp.remove("dayofweek");
        mp.remove("pi");
        mp.remove("user");
        mp.put("ln", "*");
        mp.put("year", "*");
        mp.put("weekday", "*");
        mp.put("cot", "cos($Params)");
        mp.put("second", "*");
        mp.put("trim", "1=trim(both ' ' from $P1)|2=trim(both $P1 from $P2)");
        mp.put("lpad", "*");
        mp.put("atan2", "atan($Params)");
        mp.put("ceil", "*");
        mp.put("current_date", "0=current_date");
        mp.put("month", "*");
        mp.put("locate", "2=locate($P2, $P1)|3=locate($P2, $P1, $P3)");
        mp.put("log", "ln($Params)");
        mp.put("session_user", "0=session_user");
        mp.put("substring", "*");
        mp.put("avg", "1=avg($P1)");
        mp.put("hour", "*");
        mp.put("to_date", "*");
        mp.put("rpad", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("current_time", "0=current_time");
        mp.put("current_user", "0=current_user");
        mp.put("bit_length", "1=length(to_binary($P1))*8");
        mp.put("minute", "*");
        mp.put("last_day", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.HANAColumnStoreDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.HANARowStoreDialect);
        mp.remove("ln");
        mp.remove("weekday");
        mp.remove("replace");
        mp.remove("ceil");
        mp.remove("right");
        mp.remove("session_user");
        mp.remove("to_date");
        mp.remove("rpad");
        mp.remove("left");
        mp.remove("lpad");
        mp.remove("power");
        mp.remove("last_day");
        mp.remove("atan2");
        mp.remove("current_user");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("degrees", "*");
        mp.put("space", "*");
        mp.put("second", "1=cast(second($P1) as int)");
        mp.put("rand", "*");
        mp.put("sysdate", "0=sysdate");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("day", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("str", "1=cast($P1 as varchar(256))");
        mp.put("trunc", "*");
        mp.put("to_char", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("radians", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("avg", "1=avg(cast($P1 as double))");
        mp.put("ceiling", "*");
        mp.put("reverse", "*");
        mp.put("bit_length", "*");
        mp.put("soundex", "*");
        mp.put("dayofweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("user", "0=user()");
        DialectFunctionTemplate.copyTo(mp, Dialect.HSQLDialect);
        mp.clear();
        mp.put("mod", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1 FROM $P2)|3=substring($P1 FROM $P2 FOR $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("current_timestamp", "0=current");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("max", "*");
        mp.put("nvl", "$NVL_Params");
        mp.put("lower", "*");
        mp.put("coalesce", "$NVL_Params");
        mp.put("count", "*");
        mp.put("length", "*");
        mp.put("concat", "($Lined_Params)");
        mp.put("bit_length", "*");
        mp.put("substr", "1=substr($P1)|2=substr($P1, $P2)|3=substr($P1, $P2, $P3)");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("current_date", "0=today");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("nullif", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.InformixDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Informix10Dialect);
        mp.remove("nvl");
        mp.remove("substr");
        mp.put("ln", "*");
        mp.put("year", "*");
        mp.put("cos", "*");
        mp.put("character_length", "*");
        mp.put("atan", "*");
        mp.put("second", "*");
        mp.put("octet_length", "*");
        mp.put("hex", "*");
        mp.put("exp", "*");
        mp.put("day", "*");
        mp.put("coalesce", "*");
        mp.put("concat", "($Add_Params)");
        mp.put("str", "1=cast($P1 as varchar)");
        mp.put("current_date", "0=date('now')");
        mp.put("extract", "1=date_part('$P1)|3=date_part('$P1', $P3)");
        mp.put("month", "*");
        mp.put("left", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)");
        mp.put("log", "*");
        mp.put("unhex", "*");
        mp.put("session_user", "0=session_user");
        mp.put("random", "0=random()");
        mp.put("hour", "*");
        mp.put("current_timestamp", "0=date('now')");
        mp.put("sin", "*");
        mp.put("power", "*");
        mp.put("current_time", "0=date('now')");
        mp.put("current_user", "0=current_user");
        mp.put("right", "*");
        mp.put("date_trunc", "*");
        mp.put("bit_length", "1=octet_length(hex($P1))*4");
        mp.put("minute", "*");
        mp.put("soundex", "*");
        mp.put("user", "0=user");
        DialectFunctionTemplate.copyTo(mp, Dialect.IngresDialect);
        mp.put("concat", "($Lined_Params)");
        mp.put("current_date", "0=current_date");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("current_time", "0=current_time");
        DialectFunctionTemplate.copyTo(mp, Dialect.Ingres10Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Ingres9Dialect);
        mp.remove("ln");
        mp.remove("log");
        mp.remove("character_length");
        mp.remove("unhex");
        mp.remove("cos");
        mp.remove("right");
        mp.remove("date_trunc");
        mp.remove("atan");
        mp.remove("session_user");
        mp.remove("random");
        mp.remove("octet_length");
        mp.remove("left");
        mp.remove("current_timestamp");
        mp.remove("soundex");
        mp.remove("sin");
        mp.remove("hex");
        mp.remove("power");
        mp.remove("exp");
        mp.remove("user");
        mp.remove("current_time");
        mp.remove("current_user");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("bit_length", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        DialectFunctionTemplate.copyTo(mp, Dialect.InterbaseDialect);
        mp.remove("current_date");
        mp.remove("concat");
        DialectFunctionTemplate.copyTo(mp, Dialect.JDataStoreDialect);
        mp.put("year", "*");
        mp.put("character_length", "*");
        mp.put("bin", "*");
        mp.put("weekday", "*");
        mp.put("localtimestamp", "0=localtimestamp()");
        mp.put("from_days", "*");
        mp.put("degrees", "*");
        mp.put("rand", "0=rand()");
        mp.put("octet_length", "*");
        mp.put("quote", "*");
        mp.put("utc_time", "0=utc_time()");
        mp.put("char_length", "*");
        mp.put("hex", "*");
        mp.put("exp", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("oct", "*");
        mp.put("concat", "*");
        mp.put("ceil", "*");
        mp.put("dayofyear", "*");
        mp.put("sha1", "*");
        mp.put("current_date", "0=current_date");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("unhex", "*");
        mp.put("datediff", "*");
        mp.put("encrypt", "*");
        mp.put("time_to_sec", "*");
        mp.put("unix_timestamp", "*");
        mp.put("microseconds", "*");
        mp.put("log2", "*");
        mp.put("current_time", "0=current_time");
        mp.put("timestamp", "*");
        mp.put("timediff", "*");
        mp.put("utc_timestamp", "0=utc_timestamp()");
        mp.put("reverse", "*");
        mp.put("dayname", "*");
        mp.put("soundex", "*");
        mp.put("date_format", "*");
        mp.put("last_day", "*");
        mp.put("quarter", "*");
        mp.put("md5", "*");
        mp.put("date", "*");
        mp.put("localtime", "0=localtime()");
        mp.put("ln", "*");
        mp.put("cos", "*");
        mp.put("sign", "*");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("space", "*");
        mp.put("second", "*");
        mp.put("sysdate", "0=sysdate()");
        mp.put("monthname", "*");
        mp.put("crc32", "*");
        mp.put("day", "*");
        mp.put("tan", "*");
        mp.put("ltrim", "*");
        mp.put("acos", "*");
        mp.put("sha", "*");
        mp.put("from_unixtime", "*");
        mp.put("month", "*");
        mp.put("ucase", "*");
        mp.put("lcase", "*");
        mp.put("to_days", "*");
        mp.put("week", "*");
        mp.put("sec_to_time", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("radians", "*");
        mp.put("dayofmonth", "*");
        mp.put("hour", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("floor", "*");
        mp.put("stddev", "std($Params)");
        mp.put("ascii", "*");
        mp.put("ord", "*");
        mp.put("ceiling", "*");
        mp.put("rtrim", "*");
        mp.put("minute", "*");
        mp.put("round", "*");
        mp.put("yearweek", "*");
        mp.put("dayofweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("bit_count", "*");
        mp.put("asin", "*");
        mp.put("time", "*");
        mp.put("weekofyear", "*");
        mp.put("utc_date", "0=utc_date()");
        DialectFunctionTemplate.copyTo(mp, Dialect.MariaDBDialect);
        mp.put("localtimestamp", "0=now(6)");
        mp.put("localtime", "0=now(6)");
        mp.put("sysdate", "0=sysdate(6)");
        mp.put("current_timestamp", "0=now(6)");
        mp.put("now", "0=now(6)");
        DialectFunctionTemplate.copyTo(mp, Dialect.MariaDB53Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.MariaDB102Dialect);
        mp.put("chr", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.MariaDB103Dialect);
        mp.remove("chr");
        DialectFunctionTemplate.copyTo(mp, Dialect.MariaDB10Dialect);
        mp.clear();
        mp.put("mod", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("sign", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("max", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "*");
        mp.put("count", "*");
        mp.put("length", "*");
        mp.put("concat", "*");
        mp.put("bit_length", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("round", "*");
        mp.put("nullif", "*");
        mp.put("user", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.MckoiDialect);
        mp.remove("concat");
        mp.remove("user");
        mp.put("date", "*");
        mp.put("cos", "dcos($Params)");
        mp.put("cot", "dcot($Params)");
        mp.put("atan", "datan($Params)");
        mp.put("degrees", "ddegrees($Params)");
        mp.put("sqrt", "dsqrt($Params)");
        mp.put("char_length", "*");
        mp.put("exp", "dexp($Params)");
        mp.put("atan2", "datan2($Params)");
        mp.put("tan", "dtan($Params)");
        mp.put("acos", "dacos($Params)");
        mp.put("dayofyear", "*");
        mp.put("week", "*");
        mp.put("log", "dlog($Params)");
        mp.put("log10", "dlog10($Params)");
        mp.put("sin", "dsin($Params)");
        mp.put("power", "dpower($Params)");
        mp.put("floor", "*");
        mp.put("timestamp", "*");
        mp.put("ceiling", "*");
        mp.put("soundex", "*");
        mp.put("char", "*");
        mp.put("dayofweek", "*");
        mp.put("asin", "dasin($Params)");
        mp.put("time", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.MimerSQLDialect);
        mp.remove("char");
        mp.remove("power");
        mp.remove("atan2");
        mp.put("year", "*");
        mp.put("character_length", "*");
        mp.put("bin", "*");
        mp.put("weekday", "*");
        mp.put("localtimestamp", "0=localtimestamp()");
        mp.put("from_days", "*");
        mp.put("degrees", "*");
        mp.put("rand", "0=rand()");
        mp.put("octet_length", "*");
        mp.put("quote", "*");
        mp.put("sqrt", "*");
        mp.put("utc_time", "0=utc_time()");
        mp.put("hex", "*");
        mp.put("exp", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("oct", "*");
        mp.put("concat", "*");
        mp.put("ceil", "*");
        mp.put("sha1", "*");
        mp.put("current_date", "0=current_date");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("unhex", "*");
        mp.put("datediff", "*");
        mp.put("encrypt", "*");
        mp.put("time_to_sec", "*");
        mp.put("unix_timestamp", "*");
        mp.put("microseconds", "*");
        mp.put("log2", "*");
        mp.put("current_time", "0=current_time");
        mp.put("timediff", "*");
        mp.put("utc_timestamp", "0=utc_timestamp()");
        mp.put("reverse", "*");
        mp.put("dayname", "*");
        mp.put("date_format", "*");
        mp.put("last_day", "*");
        mp.put("quarter", "*");
        mp.put("md5", "*");
        mp.put("localtime", "0=localtime()");
        mp.put("ln", "*");
        mp.put("cos", "*");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("space", "*");
        mp.put("second", "*");
        mp.put("sysdate", "0=sysdate()");
        mp.put("monthname", "*");
        mp.put("crc32", "*");
        mp.put("day", "*");
        mp.put("tan", "*");
        mp.put("ltrim", "*");
        mp.put("acos", "*");
        mp.put("sha", "*");
        mp.put("from_unixtime", "*");
        mp.put("month", "*");
        mp.put("ucase", "*");
        mp.put("lcase", "*");
        mp.put("to_days", "*");
        mp.put("sec_to_time", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("radians", "*");
        mp.put("dayofmonth", "*");
        mp.put("hour", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("stddev", "std($Params)");
        mp.put("ascii", "*");
        mp.put("ord", "*");
        mp.put("rtrim", "*");
        mp.put("minute", "*");
        mp.put("yearweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("bit_count", "*");
        mp.put("asin", "*");
        mp.put("weekofyear", "*");
        mp.put("utc_date", "0=utc_date()");
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQLDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQL5Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQL55Dialect);
        mp.put("localtimestamp", "0=now(6)");
        mp.put("localtime", "0=now(6)");
        mp.put("sysdate", "0=sysdate(6)");
        mp.put("current_timestamp", "0=now(6)");
        mp.put("now", "0=now(6)");
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQL57Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQL57InnoDBDialect);
        mp.put("localtimestamp", "0=localtimestamp()");
        mp.put("localtime", "0=localtime()");
        mp.put("sysdate", "0=sysdate()");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("now", "0=now()");
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQL5InnoDBDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQLInnoDBDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQLMyISAMDialect);
        mp.put("localtimestamp", "0=now(6)");
        mp.put("localtime", "0=now(6)");
        mp.put("sysdate", "0=sysdate(6)");
        mp.put("current_timestamp", "0=now(6)");
        mp.put("now", "0=now(6)");
        DialectFunctionTemplate.copyTo(mp, Dialect.MySQL8Dialect);
        mp.clear();
        mp.put("ln", "*");
        mp.put("mod", "*");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("cos", "*");
        mp.put("upper", "*");
        mp.put("sign", "*");
        mp.put("replace", "*");
        mp.put("atan", "*");
        mp.put("translate", "*");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("sysdate", "0=sysdate");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("lpad", "*");
        mp.put("instr", "*");
        mp.put("exp", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("atan2", "*");
        mp.put("tan", "*");
        mp.put("nvl", "*");
        mp.put("ltrim", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "$NVL_Params");
        mp.put("count", "*");
        mp.put("concat", "$Lined_Params");
        mp.put("acos", "*");
        mp.put("ceil", "*");
        mp.put("chr", "*");
        mp.put("substr", "*");
        mp.put("str", "to_char($Params)");
        mp.put("current_date", "0=current_date");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("trunc", "*");
        mp.put("nullif", "*");
        mp.put("to_char", "*");
        mp.put("locate", "2=instr($P2,$P1)");
        mp.put("log", "*");
        mp.put("sum", "*");
        mp.put("substring", "substr($Params)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("to_date", "*");
        mp.put("rpad", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("sin", "*");
        mp.put("power", "*");
        mp.put("floor", "*");
        mp.put("stddev", "*");
        mp.put("ascii", "*");
        mp.put("current_time", "0=current_timestamp");
        mp.put("initcap", "*");
        mp.put("max", "*");
        mp.put("length", "*");
        mp.put("rtrim", "*");
        mp.put("bit_length", "1=vsize($P1)*8");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("abs", "*");
        mp.put("round", "*");
        mp.put("variance", "*");
        mp.put("soundex", "*");
        mp.put("asin", "*");
        mp.put("last_day", "*");
        mp.put("user", "0=user");
        DialectFunctionTemplate.copyTo(mp, Dialect.OracleDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Oracle10gDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Oracle12cDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Oracle8iDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Oracle9Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Oracle9iDialect);
        mp.clear();
        mp.put("mod", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("max", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "*");
        mp.put("count", "*");
        mp.put("length", "*");
        mp.put("bit_length", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("nullif", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.PointbaseDialect);
        mp.put("localtime", "0=localtime");
        mp.put("ln", "*");
        mp.put("cos", "*");
        mp.put("sign", "*");
        mp.put("replace", "*");
        mp.put("cot", "*");
        mp.put("localtimestamp", "0=localtimestamp");
        mp.put("atan", "*");
        mp.put("degrees", "*");
        mp.put("translate", "*");
        mp.put("rand", "0=random()");
        mp.put("sysdate", "0=sysdate");
        mp.put("octet_length", "*");
        mp.put("lpad", "*");
        mp.put("char_length", "*");
        mp.put("instr", "*");
        mp.put("exp", "*");
        mp.put("atan2", "*");
        mp.put("tan", "*");
        mp.put("nvl", "*");
        mp.put("ltrim", "*");
        mp.put("coalesce", "$NVL_Params");
        mp.put("concat", "($Lined_Params)");
        mp.put("acos", "*");
        mp.put("ceil", "*");
        mp.put("chr", "*");
        mp.put("substr", "*");
        mp.put("str", "1=cast($P1 as varchar)");
        mp.put("current_date", "0=current_date");
        mp.put("trunc", "*");
        mp.put("to_char", "*");
        mp.put("locate", "2=position($P1 in $P2)|3=(position($P1 in substring($P2, $P3))+$P3-1)");
        mp.put("log", "*");
        mp.put("radians", "*");
        mp.put("session_user", "0=session_user");
        mp.put("substring", "substr($Params)");
        mp.put("random", "0=random()");
        mp.put("to_date", "*");
        mp.put("rpad", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("power", "*");
        mp.put("floor", "*");
        mp.put("stddev", "*");
        mp.put("ascii", "*");
        mp.put("current_time", "0=current_time");
        mp.put("current_user", "0=current_user");
        mp.put("initcap", "*");
        mp.put("rtrim", "*");
        mp.put("date_trunc", "*");
        mp.put("round", "*");
        mp.put("variance", "*");
        mp.put("soundex", "*");
        mp.put("asin", "*");
        mp.put("user", "0=user");
        mp.put("md5", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgresPlusDialect);
        mp.remove("sysdate");
        mp.remove("rpad");
        mp.remove("lpad");
        mp.remove("nvl");
        mp.remove("ltrim");
        mp.remove("instr");
        mp.remove("soundex");
        mp.remove("replace");
        mp.remove("rtrim");
        mp.remove("power");
        mp.remove("translate");
        mp.remove("atan2");
        mp.put("coalesce", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQLDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL81Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL82Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL9Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL91Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL92Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL93Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL94Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.PostgreSQL95Dialect);
        mp.clear();
        mp.put("mod", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("max", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "*");
        mp.put("count", "*");
        mp.put("length", "*");
        mp.put("bit_length", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("nullif", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.ProgressDialect);
        mp.put("ln", "*");
        mp.put("year", "*");
        mp.put("cos", "*");
        mp.put("character_length", "*");
        mp.put("sign", "*");
        mp.put("replace", "*");
        mp.put("cot", "*");
        mp.put("atan", "*");
        mp.put("space", "*");
        mp.put("second", "*");
        mp.put("rand", "0=rand()");
        mp.put("trim", "1=ltrim(rtrim($P1))");
        mp.put("lpad", "*");
        mp.put("char_length", "*");
        mp.put("instr", "*");
        mp.put("monthname", "*");
        mp.put("exp", "*");
        mp.put("atan2", "*");
        mp.put("tan", "*");
        mp.put("curtime", "0=curtime()");
        mp.put("nvl", "*");
        mp.put("ltrim", "*");
        mp.put("concat", "1=concat($P1)|2=concat($P1, $P2)");
        mp.put("acos", "*");
        mp.put("ceil", "*");
        mp.put("chr", "*");
        mp.put("substr", "*");
        mp.put("dayofyear", "*");
        mp.put("current_date", "0=current_date");
        mp.put("microsecond", "*");
        mp.put("month", "*");
        mp.put("trunc", "*");
        mp.put("ucase", "*");
        mp.put("lcase", "*");
        mp.put("week", "*");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("curdate", "0=curdate()");
        mp.put("dayofmonth", "*");
        mp.put("hour", "*");
        mp.put("rpad", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("now", "0=now()");
        mp.put("sin", "*");
        mp.put("power", "*");
        mp.put("floor", "*");
        mp.put("ascii", "*");
        mp.put("current_time", "0=current_timestamp");
        mp.put("timestamp", "*");
        mp.put("initcap", "*");
        mp.put("rtrim", "*");
        mp.put("reverse", "*");
        mp.put("minute", "*");
        mp.put("round", "*");
        mp.put("dayname", "*");
        mp.put("soundex", "*");
        mp.put("dayofweek", "*");
        mp.put("pi", "0=pi()");
        mp.put("asin", "*");
        mp.put("time", "*");
        mp.put("last_day", "*");
        mp.put("user", "0=user");
        mp.put("quarter", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.RDMSOS2200Dialect);
        mp.remove("curtime");
        mp.remove("week");
        mp.remove("nvl");
        mp.remove("character_length");
        mp.remove("log10");
        mp.remove("curdate");
        mp.remove("reverse");
        mp.remove("chr");
        mp.remove("space");
        mp.remove("rand");
        mp.remove("current_date");
        mp.remove("char_length");
        mp.remove("current_timestamp");
        mp.remove("instr");
        mp.remove("now");
        mp.remove("ucase");
        mp.remove("last_day");
        mp.remove("lcase");
        mp.remove("user");
        mp.remove("current_time");
        mp.remove("quarter");
        mp.put("date", "*");
        mp.put("year", "1=year($P1)");
        mp.put("cot", "cos($Params)");
        mp.put("degrees", "*");
        mp.put("translate", "*");
        mp.put("second", "1=second($P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("day", "1=day($P1)");
        mp.put("coalesce", "value($Params)");
        mp.put("concat", "($Lined_Params)");
        mp.put("extract", "1=$P1)|3=$P1($P3)");
        mp.put("month", "1=month($P1)");
        mp.put("locate", "index($Params)");
        mp.put("log", "ln($Params)");
        mp.put("radians", "*");
        mp.put("substring", "substr($Params)");
        mp.put("hour", "1=hour($P1)");
        mp.put("minute", "1=minute($P1)");
        mp.put("weekofyear", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.SAPDBDialect);
        mp.remove("date");
        mp.remove("ln");
        mp.remove("initcap");
        mp.remove("replace");
        mp.remove("ceil");
        mp.remove("substr");
        mp.remove("translate");
        mp.remove("dayofyear");
        mp.remove("dayofmonth");
        mp.remove("microsecond");
        mp.remove("trunc");
        mp.remove("rpad");
        mp.remove("lpad");
        mp.remove("dayname");
        mp.remove("soundex");
        mp.remove("monthname");
        mp.remove("dayofweek");
        mp.remove("power");
        mp.remove("time");
        mp.remove("weekofyear");
        mp.remove("atan2");
        mp.remove("timestamp");
        mp.put("mod", "1=$P1|2=$P1 % $P2");
        mp.put("isnull", "*");
        mp.put("year", "*");
        mp.put("cot", "*");
        mp.put("space", "*");
        mp.put("second", "1=datepart(second, $P1)");
        mp.put("rand", "*");
        mp.put("trim", "1=ltrim(rtrim($P1))|2=replace(replace(ltrim(rtrim(replace(replace($P2,' ','${space}$'),$P1,' '))),' ',$P1),'${space}$',' ')");
        mp.put("len", "*");
        mp.put("day", "*");
        mp.put("coalesce", "*");
        mp.put("concat", "($Add_Params)");
        mp.put("str", "*");
        mp.put("current_date", "0=getdate()");
        mp.put("extract", "1=datepart($P1)|3=datepart($P1, $P3)");
        mp.put("month", "*");
        mp.put("locate", "charindex($Params)");
        mp.put("log", "*");
        mp.put("log10", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("hour", "1=datepart(hour, $P1)");
        mp.put("current_timestamp", "0=getdate()");
        mp.put("current_time", "0=getdate()");
        mp.put("ceiling", "*");
        mp.put("length", "len($Params)");
        mp.put("reverse", "*");
        mp.put("bit_length", "1=datalength($P1) * 8");
        mp.put("minute", "1=datepart(minute, $P1)");
        mp.put("char", "*");
        mp.put("user", "0=user()");
        DialectFunctionTemplate.copyTo(mp, Dialect.SQLServerDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.SQLServer2005Dialect);
        mp.put("current_timestamp", "0=current_timestamp");
        DialectFunctionTemplate.copyTo(mp, Dialect.SQLServer2008Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.SQLServer2012Dialect);
        mp.put("mod", "*");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("trim", "1=ltrim(rtrim($P1))");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("locate", "2=charindex($P1, $P2)|3=charindex($P1, right($P2, char_length($P2)-($P3-1)))");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("current_timestamp", "0=getdate()");
        mp.put("bit_length", "*");
        mp.put("minute", "1=extract(minute from $P1)");
        DialectFunctionTemplate.copyTo(mp, Dialect.SybaseDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Sybase11Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.SybaseAnywhereDialect);
        mp.put("mod", "1=$P1|2=$P1 % $P2");
        mp.put("second", "1=datepart(second, $P1)");
        mp.put("sysdate", "0=getdate()");
        mp.put("trim", "1=ltrim(rtrim($P1))|2=str_replace(str_replace(ltrim(rtrim(str_replace(str_replace($P2,' ','${space}$'),$P1,' '))),' ',$P1),'${space}$',' ')");
        mp.put("char_length", "1=char_length($P1)");
        mp.put("atan2", "1=atn2($P1)|2=atn2($P1, $P2)");
        mp.put("coalesce", "coalesce($Compact_Params)");
        mp.put("current_date", "0=current_date()");
        mp.put("extract", "1=datepart($P1)|3=datepart($P1, $P3)");
        mp.put("substring", "substring($Compact_Params)");
        mp.put("datediff", "1=datediff($P1)|2=datediff($P1, $P2)|3=datediff($P1, $P2, $P3)");
        mp.put("hour", "1=datepart(hour, $P1)");
        mp.put("stddev", "0=stddev");
        mp.put("current_time", "0=current_time()");
        mp.put("right", "0=right");
        mp.put("bit_length", "1=datalength($P1) * 8");
        mp.put("minute", "1=datepart(minute, $P1)");
        mp.put("variance", "0=variance");
        mp.put("soundex", "0=sounded");
        DialectFunctionTemplate.copyTo(mp, Dialect.SybaseASE15Dialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.SybaseASE157Dialect);
        mp.clear();
        mp.put("mod", "1=$P1|2=$P1 mod $P2");
        mp.put("locate", "1=position($P1)|2=position($P1 in $P2)");
        mp.put("year", "1=extract(year from $P1)");
        mp.put("upper", "*");
        mp.put("sum", "*");
        mp.put("substring", "1=substring($P1)|2=substring($P1 from $P2)|3=substring($P1 from $P2 for $P3)");
        mp.put("second", "1=extract(second from $P1)");
        mp.put("cast", "2=cast($P1, $P2)");
        mp.put("avg", "1=avg($P1)");
        mp.put("min", "*");
        mp.put("hour", "1=extract(hour from $P1)");
        mp.put("trim", "1=trim($P1)|2=trim($P1 $P2)|3=trim($P1 $P2 $P3)|4=trim($P1 $P2 $P3 $P4)");
        mp.put("sqrt", "*");
        mp.put("current_timestamp", "0=current_timestamp");
        mp.put("day", "1=extract(day from $P1)");
        mp.put("current_time", "0=current_time");
        mp.put("max", "*");
        mp.put("lower", "*");
        mp.put("coalesce", "*");
        mp.put("count", "*");
        mp.put("length", "1=character_length($P1)");
        mp.put("concat", "($Lined_Params)");
        mp.put("bit_length", "1=octet_length(cast($P1 as char))*4");
        mp.put("minute", "1=extract(minute from $P1)");
        mp.put("str", "1=cast($P1 as varchar(255))");
        mp.put("current_date", "0=current_date");
        mp.put("abs", "*");
        mp.put("extract", "1=extract($P1)|2=extract($P1 $P2)|3=extract($P1 $P2 $P3)");
        mp.put("month", "1=extract(month from $P1)");
        mp.put("nullif", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.TeradataDialect);
        DialectFunctionTemplate.copyTo(mp, Dialect.Teradata14Dialect);
        mp.remove("current_date");
        mp.remove("current_timestamp");
        mp.remove("current_time");
        mp.put("mod", "*");
        mp.put("locate", "1=locate($P1)|2=locate($P1, $P2)|3=locate($P1, $P2, $P3)");
        mp.put("substring", "1=substring($P1)|2=substring($P1, $P2)|3=substring($P1, $P2, $P3)");
        mp.put("sysdate", "0=sysdate");
        mp.put("to_date", "*");
        mp.put("nvl", "*");
        mp.put("length", "*");
        mp.put("rtrim", "*");
        mp.put("concat", "*");
        mp.put("bit_length", "*");
        mp.put("str", "1=cast($P1 as char)");
        mp.put("to_char", "*");
        DialectFunctionTemplate.copyTo(mp, Dialect.TimesTenDialect);
    }
}

