/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.EntityType;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.TailType;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.dbutils.ResultSetHandler;

public class ActiveRecord<T>
implements TailType,
EntityType {
    static final ThreadLocal<String[]> forFieldsOrTails = new ThreadLocal();
    static final ThreadLocal<Boolean> isForfield = new ThreadLocal();
    private SqlBoxContext ctx;
    private Map<String, Object> tailsMap;

    protected void miscMethods__________________() {
    }

    public SqlBoxContext ctx(Object ... items) {
        for (Object item : items) {
            if (item == null || !(item instanceof SqlBoxContext)) continue;
            return (SqlBoxContext)item;
        }
        if (this.ctx == null) {
            this.ctx = SqlBoxContext.globalSqlBoxContext;
        }
        SqlBoxException.assureNotNull(this.ctx, "No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        return this.ctx;
    }

    public TableModel model() {
        return SqlBoxContextUtils.findEntityOrClassTableModel(this).newCopy();
    }

    public T useContext(SqlBoxContext ctx) {
        this.ctx = ctx;
        return (T)this;
    }

    @Override
    public Map<String, Object> tails() {
        if (this.tailsMap == null) {
            this.tailsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        return this.tailsMap;
    }

    public <V> V getField(String fieldName) {
        return (V)ClassCacheUtils.readValueFromBeanField(this, fieldName);
    }

    public <V> V getTail(String columnName) {
        if (this.tailsMap == null) {
            return null;
        }
        return (V)this.tailsMap.get(columnName);
    }

    public T putTail(Object ... columAndValues) {
        SqlBoxException.assureTrue(columAndValues.length % 2 == 0, "Column and values should be paired");
        for (int i = 0; i < columAndValues.length / 2; ++i) {
            this.tails().put((String)columAndValues[i * 2], columAndValues[i * 2 + 1]);
        }
        return (T)this;
    }

    public T putField(Object ... fieldAndValues) {
        SqlBoxException.assureTrue(fieldAndValues.length % 2 == 0, "Field and values should be paired");
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            ClassCacheUtils.writeValueToBeanField(this, (String)fieldAndValues[i * 2], fieldAndValues[i * 2 + 1]);
        }
        return (T)this;
    }

    public T forFields(String ... fieldNames) {
        forFieldsOrTails.set(fieldNames);
        isForfield.set(true);
        return (T)this;
    }

    public T forTails(String ... columnNames) {
        forFieldsOrTails.set(columnNames);
        isForfield.set(false);
        return (T)this;
    }

    public T putValues(Object ... values) {
        String[] fields = forFieldsOrTails.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new SqlBoxException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new SqlBoxException("putValues quantity does not match forFields or forColumns");
        }
        for (int i = 0; i < fields.length; ++i) {
            if (isForfield.get().booleanValue()) {
                ClassCacheUtils.writeValueToBeanField(this, fields[i], values[i]);
                continue;
            }
            this.tails().put(fields[i], values[i]);
        }
        return (T)this;
    }

    public String shardTB(Object ... items) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), items);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, this);
        return SqlBoxContextUtils.getShardedTB(this.ctx(items), model.getEntityClass(), shardKey1);
    }

    public SqlBoxContext shardDB(Object ... items) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), items);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, this);
        return SqlBoxContextUtils.getShardedDB(this.ctx(items), model.getEntityClass(), shardKey1);
    }

    public Object[] shard(Object ... items) {
        return new Object[]{this.shardTB(items), this.shardDB(items)};
    }

    protected static Object[] insertThisClassIfNotHave(Object entity, Object ... items) {
        Object[] newItems = items;
        TableModel[] models = SqlBoxContextUtils.findAllModels(items);
        if (models.length == 0) {
            throw new SqlBoxException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            newItems = ArrayUtils.insertArray(model, items);
        }
        return newItems;
    }

    protected void crudMethods__________________() {
    }

    public T insert(Object ... items) {
        return (T)this.ctx(items).eInsert(this, items);
    }

    public T update(Object ... items) {
        return this.ctx(items).eUpdate(this, items);
    }

    public int updateTry(Object ... items) {
        return this.ctx(items).eUpdateTry(this, items);
    }

    public void delete(Object ... items) {
        this.ctx(items).eDelete(this, items);
    }

    public int deleteTry(Object ... items) {
        return this.ctx(items).eDeleteTry(this, items);
    }

    public void deleteById(Object id, Object ... items) {
        this.ctx(items).eDeleteById(this.getClass(), id, items);
    }

    public int deleteByIdTry(Object id, Object ... items) {
        return this.ctx(items).eDeleteByIdTry(this.getClass(), id, items);
    }

    public boolean exist(Object ... items) {
        return this.ctx(items).eExist(this, items);
    }

    public boolean existById(Object id, Object ... items) {
        return this.ctx(items).eExistById(this.getClass(), id, items);
    }

    public int countAll(Object ... items) {
        return this.ctx(items).eCountAll(this.getClass(), items);
    }

    public T load(Object ... items) {
        return (T)this.ctx(items).eLoad(this, items);
    }

    public int loadTry(Object ... items) {
        return this.ctx(items).eLoadTry(this, items);
    }

    public T loadById(Object id, Object ... items) {
        return (T)this.ctx(items).eLoadById(this.getClass(), id, items);
    }

    public T loadByIdTry(Object id, Object ... items) {
        return (T)this.ctx(items).eLoadByIdTry(this.getClass(), id, items);
    }

    public T loadBySQL(Object ... items) {
        return this.ctx(items).eLoadBySQL(items);
    }

    public List<T> findAll(Object ... items) {
        return this.ctx(items).eFindAll(this.getClass(), items);
    }

    public List<T> findBySQL(Object ... items) {
        return this.ctx(items).eFindBySQL(this.getClass(), items);
    }

    public List<T> findBySample(Object ... items) {
        return this.ctx(items).eFindBySample(this, items);
    }

    public EntityNet autoNet(Class<?> ... entityClass) {
        return this.ctx(new Object[0]).autoNet(entityClass);
    }

    public <E> E findRelatedOne(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedOne(this, newItems);
    }

    public <E> List<E> findRelatedList(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedList(this, newItems);
    }

    public <E> Set<E> findRelatedSet(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedSet(this, newItems);
    }

    public <E> Map<Object, E> findRelatedMap(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedMap(this, newItems);
    }

    public <E> List<E> eFindAll(Class<E> entityClass, Object ... items) {
        return this.ctx(items).eFindAll(entityClass, items);
    }

    public <E> List<E> eFindBySample(Object sampleBean, Object ... items) {
        return this.ctx(items).eFindBySample(sampleBean, items);
    }

    public <E> List<E> eFindBySQL(Object ... items) {
        return this.ctx(items).eFindBySQL(items);
    }

    public <E> E eInsert(E entity, Object ... items) {
        return this.ctx(items).eInsert(entity, items);
    }

    public <E> E eLoad(E entity, Object ... items) {
        return this.ctx(items).eLoad(entity, items);
    }

    public <E> E eLoadById(Class<E> entityClass, Object entityId, Object ... items) {
        return this.ctx(items).eLoadById(entityClass, entityId, items);
    }

    public <E> E eLoadByIdTry(Class<E> entityClass, Object entityId, Object ... items) {
        return this.ctx(items).eLoadByIdTry(entityClass, entityId, items);
    }

    public <E> E eUpdate(Object entity, Object ... items) {
        return (E)this.ctx(items).eUpdate(entity, items);
    }

    public boolean eExist(Object entity, Object ... items) {
        return this.ctx(items).eExist(entity, items);
    }

    public boolean eExistById(Class<?> entityClass, Object id, Object ... items) {
        return this.ctx(items).eExistById(entityClass, id, items);
    }

    public int eCountAll(Class<?> entityClass, Object ... items) {
        return this.ctx(items).eCountAll(entityClass, items);
    }

    public int eDeleteByIdTry(Class<?> entityClass, Object id, Object ... items) {
        return this.ctx(items).eDeleteByIdTry(entityClass, id, items);
    }

    public int eDeleteTry(Object entity, Object ... items) {
        return this.ctx(items).eDeleteTry(entity, items);
    }

    public int eLoadTry(Object entity, Object ... items) {
        return this.ctx(items).eLoadTry(entity, items);
    }

    public int eUpdateTry(Object entity, Object ... items) {
        return this.ctx(items).eUpdateTry(entity, items);
    }

    public void eDelete(Object entity, Object ... items) {
        this.ctx(items).eDelete(entity, items);
    }

    public void eDeleteById(Class<?> entityClass, Object id, Object ... items) {
        this.ctx(items).eDeleteById(entityClass, id, items);
    }

    public <E> E eFindRelatedOne(Object entity, Object ... items) {
        return this.ctx(items).eFindRelatedOne(entity, items);
    }

    public <E> List<E> eFindRelatedList(Object entityOrIterable, Object ... items) {
        return this.ctx(items).eFindRelatedList(entityOrIterable, items);
    }

    public <E> Set<E> eFindRelatedSet(Object entity, Object ... items) {
        return this.ctx(items).eFindRelatedSet(entity, items);
    }

    public <E> Map<Object, E> eFindRelatedMap(Object entity, Object ... items) {
        return this.ctx(items).eFindRelatedMap(entity, items);
    }

    public <E> E pQuery(Object ... items) {
        return (E)this.ctx(items).pQuery(items);
    }

    public <E> E pQueryForObject(Object ... items) {
        return (E)this.ctx(items).pQueryForObject(items);
    }

    public long pQueryForLongValue(Object ... items) {
        return this.ctx(items).pQueryForLongValue(items);
    }

    public int pQueryForIntValue(Object ... items) {
        return this.ctx(items).pQueryForIntValue(items);
    }

    public String pQueryForString(Object ... items) {
        return this.ctx(items).pQueryForString(items);
    }

    public List<Map<String, Object>> pQueryForMapList(Object ... items) {
        return this.ctx(items).pQueryForMapList(items);
    }

    public int pUpdate(Object ... items) {
        return this.ctx(items).pUpdate(items);
    }

    public <E> E pInsert(Object ... items) {
        return (E)this.ctx(items).pInsert(items);
    }

    public <E> E pExecute(Object ... items) {
        return (E)this.ctx(items).pExecute(items);
    }

    public <E> List<E> pQueryForEntityList(Object ... items) {
        return this.ctx(items).pQueryForEntityList(items);
    }

    public <E> E iQuery(Object ... items) {
        return (E)this.ctx(items).iQuery(items);
    }

    public <E> E iQueryForObject(Object ... items) {
        return (E)this.ctx(items).iQueryForObject(items);
    }

    public long iQueryForLongValue(Object ... items) {
        return this.ctx(items).iQueryForLongValue(items);
    }

    public int iQueryForIntgValue(Object ... items) {
        return this.ctx(items).iQueryForIntValue(items);
    }

    public String iQueryForString(Object ... items) {
        return this.ctx(items).iQueryForString(items);
    }

    public List<Map<String, Object>> iQueryForMapList(Object ... items) {
        return this.ctx(items).iQueryForMapList(items);
    }

    public int iUpdate(Object ... items) {
        return this.ctx(items).iUpdate(items);
    }

    public <E> E iInsert(Object ... items) {
        return (E)this.ctx(items).iInsert(items);
    }

    public <E> E iExecute(Object ... items) {
        return (E)this.ctx(items).iExecute(items);
    }

    public <E> List<E> iQueryForEntityList(Object ... items) {
        return this.ctx(items).iQueryForEntityList(items);
    }

    public <E> E nQuery(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx(items).nQuery(conn, rsh, sql, items);
    }

    public <E> E nQueryForObject(Connection conn, String sql, Object ... items) {
        return (E)this.ctx(items).nQueryForObject(conn, sql, items);
    }

    public String nQueryForString(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForString(conn, sql, items);
    }

    public long nQueryForLongValue(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForLongValue(conn, sql, items);
    }

    public int nQueryForIntValue(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForIntValue(conn, sql, items);
    }

    public List<Map<String, Object>> nQueryForMapList(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForMapList(conn, sql, items);
    }

    public int nUpdate(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nUpdate(conn, sql, items);
    }

    public <E> E nInsert(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx(items).nInsert(conn, rsh, sql, items);
    }

    public int nExecute(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nExecute(conn, sql, items);
    }

    public <E> List<E> nExecute(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx(items).nExecute(conn, rsh, sql, items);
    }

    public <E> E nQuery(ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx(items).nQuery(rsh, sql, items);
    }

    public <E> E nQueryForObject(String sql, Object ... items) {
        return (E)this.ctx(items).nQueryForObject(sql, items);
    }

    public String nQueryForString(String sql, Object ... items) {
        return this.ctx(items).nQueryForString(sql, items);
    }

    public long nQueryForLongValue(String sql, Object ... items) {
        return this.ctx(items).nQueryForLongValue(sql, items);
    }

    public int nQueryForIntValue(String sql, Object ... items) {
        return this.ctx(items).nQueryForIntValue(sql, items);
    }

    public List<Map<String, Object>> nQueryForMapList(String sql, Object ... items) {
        return this.ctx(items).nQueryForMapList(sql, items);
    }

    public int nUpdate(String sql, Object ... items) {
        return this.ctx(items).nUpdate(sql, items);
    }

    public <E> E nInsert(ResultSetHandler rsh, String sql, Object ... items) {
        return (E)this.ctx(items).nInsert(rsh, sql, items);
    }

    public int nExecute(String sql, Object ... items) {
        return this.ctx(items).nExecute(sql, items);
    }

    public <E> List<E> nExecute(ResultSetHandler rsh, String sql, Object ... items) {
        return this.ctx(items).nExecute(rsh, sql, items);
    }

    public <E> E tQuery(Object ... items) {
        return (E)this.ctx(items).tQuery(items);
    }

    public <E> E tQueryForObject(Object ... items) {
        return (E)this.ctx(items).tQueryForObject(items);
    }

    public long tQueryForLongValue(Object ... items) {
        return this.ctx(items).tQueryForLongValue(items);
    }

    public int tQueryForIntValue(Object ... items) {
        return this.ctx(items).tQueryForIntValue(items);
    }

    public String tQueryForString(Object ... items) {
        return this.ctx(items).tQueryForString(items);
    }

    public List<Map<String, Object>> tQueryForMapList(Object ... items) {
        return this.ctx(items).tQueryForMapList(items);
    }

    public int tUpdate(Object ... items) {
        return this.ctx(items).tUpdate(items);
    }

    public <E> E tInsert(Object ... items) {
        return (E)this.ctx(items).tInsert(items);
    }

    public <E> E tExecute(Object ... items) {
        return (E)this.ctx(items).tExecute(items);
    }

    public <E> List<E> tQueryForEntityList(Class<E> entityClass, Object ... items) {
        return this.ctx(items).tQueryForEntityList(entityClass, items);
    }
}

