/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.jfinal;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.DataSource;

public class JFinalTxConnectionManager
implements ConnectionManager {
    protected final Method getConfigMethod;
    protected final Method getConnectionMethod;
    protected final Method releaseConnectionMethod;
    protected final Method isInTransactionMethod;

    public JFinalTxConnectionManager() {
        Class<?> configClass;
        Class<?> dbKitClass;
        try {
            dbKitClass = Class.forName("com.jfinal.plugin.activerecord.DbKit");
            configClass = Class.forName("com.jfinal.plugin.activerecord.Config");
        }
        catch (ClassNotFoundException e) {
            throw new TransactionsException("Error: jfinal jar missing, fail to build JFinalTxConnectionManager.", e);
        }
        try {
            this.getConfigMethod = dbKitClass.getMethod("getConfig", new Class[0]);
            this.getConnectionMethod = configClass.getMethod("getConnection", new Class[0]);
            this.releaseConnectionMethod = configClass.getMethod("close", Connection.class);
            this.isInTransactionMethod = configClass.getMethod("isInTransaction", new Class[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxConnectionManager initialize failed.", e);
        }
        TransactionsException.assureNotNull(this.getConfigMethod, "Fail to get getConfigMethod method in JFinalTxConnectionManager.");
        TransactionsException.assureNotNull(this.releaseConnectionMethod, "Fail to get releaseConnectionMethod method in JFinalTxConnectionManager.");
        TransactionsException.assureNotNull(this.getConnectionMethod, "Fail to get getConnectionMethod method in JFinalTxConnectionManager.");
        TransactionsException.assureNotNull(this.isInTransactionMethod, "Fail to get isInTransactionMethod method in JFinalTxConnectionManager.");
    }

    public static final JFinalTxConnectionManager instance() {
        return JFinalTxConnectionManagerSingleton.INSTANCE;
    }

    @Override
    public Connection getConnection(DataSource dataSource) {
        try {
            Object config = this.getConfig();
            return (Connection)this.getConnectionMethod.invoke(config, new Object[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxConnectionManager fail to get connection.", e);
        }
    }

    @Override
    public void releaseConnection(Connection conn, DataSource dataSource) {
        try {
            Object config = this.getConfig();
            this.releaseConnectionMethod.invoke(config, conn);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxConnectionManager fail to release connection.", e);
        }
    }

    @Override
    public boolean isInTransaction(DataSource ds) {
        if (ds == null) {
            return false;
        }
        try {
            Object config = this.getConfig();
            return null != this.isInTransactionMethod.invoke(config, new Object[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: JFinalTxConnectionManager fail to get transaction status.", e);
        }
    }

    private Object getConfig() throws IllegalAccessException, InvocationTargetException {
        Object config = this.getConfigMethod.invoke(null, new Object[0]);
        TransactionsException.assureNotNull(config, "Error: get a null jFinal config in JFinalTxConnectionManager.");
        return config;
    }

    private static class JFinalTxConnectionManagerSingleton {
        private static final JFinalTxConnectionManager INSTANCE = new JFinalTxConnectionManager();

        private JFinalTxConnectionManagerSingleton() {
        }
    }
}

