/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.manual;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ManualTx
implements ConnectionManager {
    private Connection connection;
    private DataSource dataSource;
    private Integer transactionIsolationLevel;

    public ManualTx(DataSource ds, Integer transactionIsolationLevel) {
        this.dataSource = ds;
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public Connection getConnection(DataSource dataSource) throws SQLException {
        if (this.connection == null) {
            throw new TransactionsException("Fail to find connection in ManualTx");
        }
        return this.connection;
    }

    @Override
    public void releaseConnection(Connection conn, DataSource dataSource) throws SQLException {
    }

    @Override
    public boolean isInTransaction(DataSource dataSource) {
        try {
            return this.connection != null && !this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw new TransactionsException(e);
        }
    }

    public Connection beginTransaction() {
        try {
            if (this.connection == null) {
                this.connection = this.dataSource.getConnection();
                if (this.transactionIsolationLevel != null) {
                    this.connection.setTransactionIsolation(this.transactionIsolationLevel);
                }
            }
        }
        catch (SQLException e) {
            throw new TransactionsException("Fail to begin a transaction.", e);
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new TransactionsException("Fail to setAutoCommit to false", e);
        }
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            this.connection.commit();
        }
        this.setAutoCommitTrue();
    }

    public void rollback() {
        try {
            if (this.connection != null && !this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new TransactionsException(e);
        }
        this.setAutoCommitTrue();
    }

    private void setAutoCommitTrue() {
        try {
            if (this.connection != null && !this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new TransactionsException("Fail to setAutoCommit to true", e);
        }
    }
}

