/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.tinytx.TinyTxConnectionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TinyTx
implements MethodInterceptor {
    private static final TinyTxConnectionManager cm = TinyTxConnectionManager.instance();
    private int transactionIsolation = 2;
    private DataSource ds;

    public TinyTx(DataSource ds) {
        this.ds = ds;
    }

    public TinyTx(DataSource ds, Integer transactionIsolation) {
        this.ds = ds;
        this.transactionIsolation = transactionIsolation;
    }

    public Connection beginTransaction() {
        return cm.startTransaction(this.ds, this.transactionIsolation);
    }

    public void commit() throws SQLException {
        cm.commit(this.ds);
    }

    public void rollback() {
        cm.rollback(this.ds);
    }

    @Override
    public Object invoke(MethodInvocation caller) throws Throwable {
        if (cm.isInTransaction(this.ds)) {
            return caller.proceed();
        }
        Object invokeResult = null;
        try {
            cm.startTransaction(this.ds, this.transactionIsolation);
            invokeResult = caller.proceed();
            cm.commit(this.ds);
        }
        catch (Throwable t) {
            cm.rollback(this.ds);
            throw new TransactionsException("TinyTx found a runtime Exception, transaction rollbacked.", t);
        }
        return invokeResult;
    }
}

