/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.log;

import com.github.drinkjava2.jdbpro.log.DbProLog;
import com.github.drinkjava2.jdbpro.log.DbProPrintLog;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class DbProLogFactory {
    private static Class<?> dbProLogClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbProLog getLog(Class<?> clazz) {
        if (dbProLogClass == Void.TYPE) {
            return new DbProPrintLog(clazz);
        }
        if (dbProLogClass != null) {
            try {
                Constructor<?> constr = dbProLogClass.getConstructor(Class.class);
                return (DbProLog)constr.newInstance(clazz);
            }
            catch (Exception e) {
                dbProLogClass = Void.TYPE;
                return new DbProPrintLog(clazz);
            }
        }
        InputStream is = DbProLog.class.getClassLoader().getResourceAsStream(DbProLog.class.getSimpleName() + ".properties");
        if (is == null) {
            dbProLogClass = Void.TYPE;
            return new DbProPrintLog(clazz);
        }
        Properties prop = new Properties();
        try {
            prop.load(is);
            String className = prop.getProperty("log");
            dbProLogClass = Class.forName(className);
            DbProLog dbProLog = DbProLogFactory.getLog(clazz);
            return dbProLog;
        }
        catch (Exception e) {
            dbProLogClass = Void.TYPE;
            DbProPrintLog dbProPrintLog = new DbProPrintLog(clazz);
            return dbProPrintLog;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }
}

