/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.log;

import com.github.drinkjava2.jdbpro.DbProException;
import com.github.drinkjava2.jdbpro.log.DbProLog;
import java.lang.reflect.Method;

public class DbProSLF4JLog
implements DbProLog {
    private Object logger;
    private Method info;
    private Method warn;
    private Method debug;
    private Method error;

    public DbProSLF4JLog(Class<?> targetClass) {
        try {
            Class<?> logFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Method method = logFactoryClass.getMethod("getLogger", Class.class);
            this.logger = method.invoke(logFactoryClass, targetClass);
            this.debug = this.logger.getClass().getMethod("debug", String.class);
            this.info = this.logger.getClass().getMethod("info", String.class);
            this.warn = this.logger.getClass().getMethod("warn", String.class);
            this.error = this.logger.getClass().getMethod("error", String.class);
        }
        catch (Exception e) {
            throw new DbProException(e);
        }
    }

    public void call(Method method, String msg) {
        try {
            method.invoke(this.logger, msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void info(String msg) {
        this.call(this.info, msg);
    }

    @Override
    public void warn(String msg) {
        this.call(this.warn, msg);
    }

    @Override
    public void debug(String msg) {
        this.call(this.debug, msg);
    }

    @Override
    public void error(String msg) {
        this.call(this.error, msg);
    }
}

