/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.AutoIdGenerator;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.SequenceIdGenerator;
import com.github.drinkjava2.jdialects.id.TableIdGenerator;
import com.github.drinkjava2.jdialects.log.DialectLog;
import com.github.drinkjava2.jdialects.log.DialectLogFactory;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.IndexModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.model.UniqueModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DDLCreateUtils {
    private static final DialectLog logger = DialectLogFactory.getLog(DDLCreateUtils.class);

    public static String[] toCreateDDL(Dialect dialect, TableModel ... tables) {
        ArrayList<Object> objectResultList = new ArrayList<Object>();
        for (TableModel table : tables) {
            DDLCreateUtils.transferTableToObjectList(dialect, table, objectResultList);
        }
        boolean hasAutoIdGenerator = false;
        block1: for (TableModel table : tables) {
            for (ColumnModel column : table.getColumns()) {
                if (!GenerationType.AUTO.equals((Object)column.getIdGenerationType())) continue;
                hasAutoIdGenerator = true;
                break;
            }
            for (IdGenerator idGens : table.getIdGenerators()) {
                if (!hasAutoIdGenerator && !idGens.dependOnAutoIdGenerator().booleanValue()) continue;
                hasAutoIdGenerator = true;
                continue block1;
            }
        }
        ArrayList<String> stringResultList = new ArrayList<String>();
        ArrayList<TableIdGenerator> tbGeneratorList = new ArrayList<TableIdGenerator>();
        ArrayList<SequenceIdGenerator> sequenceList = new ArrayList<SequenceIdGenerator>();
        ArrayList<FKeyModel> fKeyConstraintList = new ArrayList<FKeyModel>();
        for (Object strOrObj : objectResultList) {
            if (StrUtils.isEmpty(strOrObj)) continue;
            if (strOrObj instanceof String) {
                stringResultList.add((String)strOrObj);
                continue;
            }
            if (strOrObj instanceof TableIdGenerator) {
                tbGeneratorList.add((TableIdGenerator)strOrObj);
                continue;
            }
            if (strOrObj instanceof SequenceIdGenerator) {
                sequenceList.add((SequenceIdGenerator)strOrObj);
                continue;
            }
            if (!(strOrObj instanceof FKeyModel)) continue;
            fKeyConstraintList.add((FKeyModel)strOrObj);
        }
        if (hasAutoIdGenerator) {
            IdGenerator realIdGen = AutoIdGenerator.INSTANCE.getSequenceOrTableIdGenerator(dialect);
            if (realIdGen instanceof TableIdGenerator) {
                tbGeneratorList.add((TableIdGenerator)realIdGen);
            } else if (realIdGen instanceof SequenceIdGenerator) {
                sequenceList.add((SequenceIdGenerator)realIdGen);
            } else {
                throw new DialectException("Unknow exception happen for realIdGen, please report this bug");
            }
        }
        DDLCreateUtils.buildSequenceDDL(dialect, stringResultList, sequenceList);
        DDLCreateUtils.buildTableGeneratorDDL(dialect, stringResultList, tbGeneratorList);
        DDLCreateUtils.outputFKeyConstraintDDL(dialect, stringResultList, fKeyConstraintList);
        Object[] result = stringResultList.toArray(new String[stringResultList.size()]);
        if (Dialect.getGlobalAllowShowSql().booleanValue()) {
            logger.info("Create DDL:\r" + StrUtils.arrayToString(result, "\r"));
        }
        return result;
    }

    private static void transferTableToObjectList(Dialect dialect, TableModel t, List<Object> objectResultList) {
        List<FKeyModel> fkeyChks;
        List<UniqueModel> ukChks;
        DDLFeatures features = dialect.ddlFeatures;
        StringBuilder buf = new StringBuilder();
        boolean hasPkey = false;
        String pkeys = "";
        String tableName = t.getTableName();
        List<ColumnModel> columns = t.getColumns();
        dialect.checkNotEmptyReservedWords(tableName, "Table name", tableName);
        List<IndexModel> idexChks = t.getIndexConsts();
        if (idexChks != null && !idexChks.isEmpty()) {
            for (IndexModel index : idexChks) {
                dialect.checkReservedWords(index.getName());
            }
        }
        if ((ukChks = t.getUniqueConsts()) != null && !ukChks.isEmpty()) {
            for (UniqueModel unique : ukChks) {
                dialect.checkReservedWords(unique.getName());
            }
        }
        if ((fkeyChks = t.getFkeyConstraints()) != null && !fkeyChks.isEmpty()) {
            for (FKeyModel fkey : fkeyChks) {
                dialect.checkReservedWords(fkey.getFkeyName());
            }
        }
        for (ColumnModel col : columns) {
            if (col.getTransientable().booleanValue()) continue;
            dialect.checkNotEmptyReservedWords(col.getColumnName(), "Column name", tableName);
        }
        for (IdGenerator idGen : t.getIdGenerators()) {
            objectResultList.add(idGen);
        }
        for (FKeyModel fkey : t.getFkeyConstraints()) {
            objectResultList.add(fkey);
        }
        for (ColumnModel col : columns) {
            if (col.getTransientable().booleanValue() || !col.getPkey().booleanValue()) continue;
            hasPkey = true;
            if (StrUtils.isEmpty(pkeys)) {
                pkeys = col.getColumnName();
                continue;
            }
            pkeys = pkeys + "," + col.getColumnName();
        }
        buf.append(hasPkey ? dialect.ddlFeatures.createTableString : dialect.ddlFeatures.createMultisetTableString).append(" ").append(tableName).append(" ( ");
        for (ColumnModel c : columns) {
            if (c.getTransientable().booleanValue()) continue;
            if (c.getColumnType() == null) {
                DialectException.throwEX("Type not set on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\"");
            }
            buf.append(c.getColumnName()).append(" ");
            if (GenerationType.IDENTITY.equals((Object)c.getIdGenerationType()) && !features.supportsIdentityColumns.booleanValue()) {
                DialectException.throwEX("Unsupported identity setting for dialect \"" + dialect + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\"");
            }
            if (GenerationType.IDENTITY.equals((Object)c.getIdGenerationType())) {
                if (features.hasDataTypeInIdentityColumn.booleanValue()) {
                    buf.append(dialect.translateToDDLType(c.getColumnType(), c.getLengths()));
                }
                buf.append(' ');
                if (Type.BIGINT.equals((Object)c.getColumnType())) {
                    buf.append(features.identityColumnStringBigINT);
                } else {
                    buf.append(features.identityColumnString);
                }
            } else {
                buf.append(dialect.translateToDDLType(c.getColumnType(), c.getLengths()));
                String defaultValue = c.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (!c.getNullable().booleanValue()) {
                    buf.append(" not null");
                } else {
                    buf.append(features.nullColumnString);
                }
            }
            if (!StrUtils.isEmpty(c.getCheck())) {
                if (features.supportsColumnCheck.booleanValue()) {
                    buf.append(" check (").append(c.getCheck()).append(")");
                } else {
                    logger.warn("Ignore unsupported check setting for dialect \"" + dialect + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\" with value: " + c.getCheck());
                }
            }
            if (c.getComment() != null) {
                if (StrUtils.isEmpty(features.columnComment) && !features.supportsCommentOn.booleanValue()) {
                    logger.warn("Ignore unsupported comment setting for dialect \"" + dialect + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\" with value: " + c.getComment());
                } else {
                    buf.append(StrUtils.replace(features.columnComment, "_COMMENT", c.getComment()));
                }
            }
            if (!StrUtils.isEmpty(c.getTail())) {
                buf.append(c.getTail());
            }
            buf.append(",");
        }
        if (!StrUtils.isEmpty(pkeys)) {
            buf.append(" primary key (").append(pkeys).append("),");
        }
        if (!StrUtils.isEmpty(t.getCheck())) {
            if (features.supportsTableCheck.booleanValue()) {
                buf.append(" check (").append(t.getCheck()).append("),");
            } else {
                logger.warn("Ignore unsupported table check setting for dialect \"" + dialect + "\" on table \"" + tableName + "\" with value: " + t.getCheck());
            }
        }
        buf.setLength(buf.length() - 1);
        buf.append(")");
        String tableTypeString = features.tableTypeString;
        if (!StrUtils.isEmpty(tableTypeString) && !"NOT_SUPPORT".equals(tableTypeString)) {
            buf.append(tableTypeString);
            if (!StrUtils.isEmpty(t.getEngineTail())) {
                buf.append(t.getEngineTail());
            }
        }
        objectResultList.add(buf.toString());
        if (t.getComment() != null) {
            if (features.supportsCommentOn.booleanValue()) {
                objectResultList.add("comment on table " + t.getTableName() + " is '" + t.getComment() + "'");
            } else {
                logger.warn("Ignore unsupported table comment setting for dialect \"" + dialect + "\" on table \"" + tableName + "\" with value: " + t.getComment());
            }
        }
        for (ColumnModel c : columns) {
            if (!features.supportsCommentOn.booleanValue() || c.getComment() == null || !StrUtils.isEmpty(features.columnComment)) continue;
            objectResultList.add("comment on column " + tableName + '.' + c.getColumnName() + " is '" + c.getComment() + "'");
        }
        DDLCreateUtils.buildIndexDLL(dialect, objectResultList, t);
        DDLCreateUtils.buildUniqueDLL(dialect, objectResultList, t);
    }

    protected static void checkAndInsertToNotRepeatSeq(Set<SequenceIdGenerator> notRepeatedSeq, SequenceIdGenerator seq) {
        DialectException.assureNotEmpty(seq.getName(), "SequenceGen name can not be empty");
        DialectException.assureNotEmpty(seq.getSequenceName(), "sequenceName can not be empty of \"" + seq.getName() + "\"");
        boolean canAdd = true;
        for (SequenceIdGenerator not : notRepeatedSeq) {
            if (seq.getName().equals(not.getName())) {
                canAdd = false;
                if (seq.getSequenceName().equals(not.getSequenceName()) && seq.getInitialValue().equals(not.getInitialValue()) && seq.getAllocationSize().equals(not.getAllocationSize())) continue;
                throw new DialectException("In one or more tableModel, duplicated SequenceIdGenerator name '" + seq.getName() + "' but different value of sequenceName/initialValue/allocationSize setting");
            }
            if (!seq.getSequenceName().equals(not.getSequenceName())) continue;
            throw new DialectException("In one or more tableModel, duplicated SequenceName '" + seq.getSequenceName() + "' found for '" + seq.getName() + "' and '" + not.getName() + "'");
        }
        if (canAdd) {
            notRepeatedSeq.add(seq);
        }
    }

    private static void buildSequenceDDL(Dialect dialect, List<String> stringList, List<SequenceIdGenerator> sequenceList) {
        HashSet<SequenceIdGenerator> notRepeatedSequences = new HashSet<SequenceIdGenerator>();
        for (SequenceIdGenerator seq : sequenceList) {
            DDLCreateUtils.checkAndInsertToNotRepeatSeq(notRepeatedSequences, seq);
        }
        DDLFeatures features = dialect.ddlFeatures;
        for (SequenceIdGenerator seq : notRepeatedSequences) {
            if (!features.supportBasicOrPooledSequence()) {
                DialectException.throwEX("Dialect \"" + dialect + "\" does not support sequence setting on sequence \"" + seq.getName() + "\"");
            }
            if (features.supportsPooledSequences.booleanValue()) {
                String pooledSequence = StrUtils.replace(features.createPooledSequenceStrings, "_SEQ", seq.getSequenceName());
                pooledSequence = StrUtils.replace(pooledSequence, "11", "" + seq.getInitialValue());
                pooledSequence = StrUtils.replace(pooledSequence, "33", "" + seq.getAllocationSize());
                stringList.add(pooledSequence);
                continue;
            }
            if (seq.getInitialValue() >= 2 || seq.getAllocationSize() >= 2) {
                DialectException.throwEX("Dialect \"" + dialect + "\" does not support initialValue and allocationSize setting on sequence \"" + seq.getName() + "\", try set initialValue and allocationSize to 1 to fix");
            }
            String simepleSeq = StrUtils.replace(features.createSequenceStrings, "_SEQ", seq.getSequenceName());
            stringList.add(simepleSeq);
        }
    }

    protected static void checkAndInsertToNotRepeatTable(Set<TableIdGenerator> notRepeatedSeq, TableIdGenerator tab) {
        DialectException.assureNotEmpty(tab.getName(), "TableGen name can not be empty");
        DialectException.assureNotEmpty(tab.getTable(), "TableGen tableName can not be empty of \"" + tab.getName() + "\"");
        DialectException.assureNotEmpty(tab.getPkColumnName(), "TableGen pkColumnName can not be empty of \"" + tab.getName() + "\"");
        DialectException.assureNotEmpty(tab.getPkColumnValue(), "TableGen pkColumnValue can not be empty of \"" + tab.getName() + "\"");
        DialectException.assureNotEmpty(tab.getValueColumnName(), "TableGen valueColumnName can not be empty of \"" + tab.getName() + "\"");
        boolean canAdd = true;
        for (TableIdGenerator not : notRepeatedSeq) {
            if (!tab.getName().equals(not.getName())) continue;
            canAdd = false;
            if (tab.getTable().equals(not.getTable()) && tab.getPkColumnName().equals(not.getPkColumnName()) && tab.getPkColumnValue().equals(not.getPkColumnValue()) && tab.getValueColumnName().equals(not.getValueColumnName()) && tab.getInitialValue().equals(not.getInitialValue()) && tab.getAllocationSize().equals(not.getAllocationSize())) continue;
            throw new DialectException("In one or more tableModel, duplicated TableIdGenerator name '" + tab.getName() + "' but different value of table/pKColumnName/pkColumnValue/valueColumnName/initialValue/allocationSize setting");
        }
        if (canAdd) {
            notRepeatedSeq.add(tab);
        }
    }

    private static void buildTableGeneratorDDL(Dialect dialect, List<String> stringList, List<TableIdGenerator> tbGeneratorList) {
        HashSet<TableIdGenerator> notRepeatedTab = new HashSet<TableIdGenerator>();
        for (TableIdGenerator tab : tbGeneratorList) {
            DDLCreateUtils.checkAndInsertToNotRepeatTable(notRepeatedTab, tab);
        }
        HashSet<String> tableExisted = new HashSet<String>();
        HashSet<String> columnExisted = new HashSet<String>();
        for (TableIdGenerator tg : tbGeneratorList) {
            if (tg.getAllocationSize() == 0) continue;
            String tableName = tg.getTable().toLowerCase();
            String tableAndPKColumn = tg.getTable().toLowerCase() + "..XXOO.." + tg.getPkColumnName();
            String tableAndValColumn = tg.getTable().toLowerCase() + "..XXOO.." + tg.getValueColumnName();
            if (!tableExisted.contains(tableName)) {
                String s = dialect.ddlFeatures.createTableString + " " + tableName + " (";
                s = s + tg.getPkColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + ",";
                s = s + tg.getValueColumnName() + " " + dialect.translateToDDLType(Type.BIGINT, new Integer[0]) + " )";
                stringList.add(s);
                tableExisted.add(tableName);
                columnExisted.add(tableAndPKColumn);
                columnExisted.add(tableAndValColumn);
                continue;
            }
            if (!columnExisted.contains(tableAndPKColumn)) {
                stringList.add("alter table " + tableName + " " + dialect.ddlFeatures.addColumnString + " " + tg.getPkColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + " " + dialect.ddlFeatures.addColumnSuffixString);
                columnExisted.add(tableAndPKColumn);
            }
            if (columnExisted.contains(tableAndValColumn)) continue;
            stringList.add("alter table " + tableName + " " + dialect.ddlFeatures.addColumnString + " " + tg.getValueColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + " " + dialect.ddlFeatures.addColumnSuffixString);
            columnExisted.add(tableAndValColumn);
        }
    }

    private static void outputFKeyConstraintDDL(Dialect dialect, List<String> stringList, List<FKeyModel> trueList) {
        if ("NOT_SUPPORT".equals(dialect.ddlFeatures.addForeignKeyConstraintString)) {
            logger.warn("Dialect \"" + dialect + "\" does not support foreign key setting, settings be ignored");
            return;
        }
        for (FKeyModel t : trueList) {
            if (!t.getDdl().booleanValue()) continue;
            String constName = t.getFkeyName();
            if (StrUtils.isEmpty(constName)) {
                constName = "fk_" + t.getTableName().toLowerCase() + "_" + StrUtils.replace(StrUtils.listToString(t.getColumnNames()), ",", "_");
            }
            String[] refTableAndColumns = t.getRefTableAndColumns();
            DialectException.assureNotNull(refTableAndColumns, new String[0]);
            String fkeyTemplate = refTableAndColumns.length == 1 ? dialect.ddlFeatures.addFKeyRefPkeyString : dialect.ddlFeatures.addForeignKeyConstraintString;
            fkeyTemplate = StrUtils.replace(fkeyTemplate, "_FK1, _FK2", StrUtils.listToString(t.getColumnNames()));
            fkeyTemplate = StrUtils.replace(fkeyTemplate, "_REF1, _REF2", StrUtils.arrayToStringButSkipFirst(t.getRefTableAndColumns()));
            fkeyTemplate = StrUtils.replace(fkeyTemplate, "_REFTABLE", t.getRefTableAndColumns()[0]);
            fkeyTemplate = StrUtils.replace(fkeyTemplate, "_FKEYNAME", constName);
            String tail = StrUtils.isEmpty(t.getFkeyTail()) ? "" : " " + t.getFkeyTail();
            stringList.add("alter table " + t.getTableName() + " " + fkeyTemplate + tail);
        }
    }

    private static void buildIndexDLL(Dialect dialect, List<Object> objectResultList, TableModel t) {
        List<IndexModel> l = t.getIndexConsts();
        if (l == null || l.isEmpty()) {
            return;
        }
        String template = Dialect.Teradata14Dialect.equals(dialect) ? "create $ifUnique index $indexName ($indexValues) on " + t.getTableName() : "create $ifUnique index $indexName on " + t.getTableName() + " ($indexValues)";
        for (IndexModel index : l) {
            String indexname = index.getName();
            if (StrUtils.isEmpty(indexname)) {
                indexname = "IX_" + t.getTableName() + "_" + StrUtils.arrayToString(index.getColumnList(), "_");
            }
            String ifUnique = index.getUnique() != false ? "unique" : "";
            String result = StrUtils.replace(template, "$ifUnique", ifUnique);
            result = StrUtils.replace(result, "$indexName", indexname);
            result = StrUtils.replace(result, "$indexValues", StrUtils.arrayToString(index.getColumnList()));
            objectResultList.add(result);
        }
    }

    private static void buildUniqueDLL(Dialect dialect, List<Object> objectResultList, TableModel t) {
        List<UniqueModel> l = t.getUniqueConsts();
        if (l == null || l.isEmpty()) {
            return;
        }
        String dialectName = "" + dialect;
        for (UniqueModel unique : l) {
            String[] columns;
            boolean nullable = false;
            for (String colNames : columns = unique.getColumnList()) {
                ColumnModel vc = t.getColumnByColName(colNames);
                if (vc == null || !vc.getNullable().booleanValue()) continue;
                nullable = true;
            }
            String uniqueName = unique.getName();
            if (StrUtils.isEmpty(uniqueName)) {
                uniqueName = "UK_" + t.getTableName() + "_" + StrUtils.arrayToString(unique.getColumnList(), "_");
            }
            String template = "alter table $TABLE add constraint $UKNAME unique ($COLUMNS)";
            if ((StrUtils.startsWithIgnoreCase(dialectName, "DB2") || StrUtils.startsWithIgnoreCase(dialectName, "DERBY")) && nullable) {
                template = "create unique index $UKNAME on $TABLE ($COLUMNS)";
            } else if (StrUtils.startsWithIgnoreCase(dialectName, "Informix")) {
                template = "alter table $TABLE add constraint unique ($COLUMNS) constraint $UKNAME";
            }
            String result = StrUtils.replace(template, "$TABLE", t.getTableName());
            result = StrUtils.replace(result, "$UKNAME", uniqueName);
            result = StrUtils.replace(result, "$COLUMNS", StrUtils.arrayToString(unique.getColumnList()));
            objectResultList.add(result);
        }
    }
}

