/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.converter;

import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.converter.EnumOrdinalFieldConverter;
import com.github.drinkjava2.jsqlbox.converter.EnumStringFieldConverter;
import com.github.drinkjava2.jsqlbox.converter.FieldConverter;
import com.github.drinkjava2.jsqlbox.converter.VersionFieldConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FieldConverterUtils {
    private static final Map<Object, FieldConverter> converterCache = new ConcurrentHashMap<Object, FieldConverter>();

    private FieldConverterUtils() {
    }

    public static FieldConverter getFieldConverter(Object key) {
        FieldConverter converter = converterCache.get(key);
        if (converter == null) {
            try {
                converter = (FieldConverter)((Class)key).newInstance();
                converterCache.put(key, converter);
            }
            catch (Exception e) {
                throw new SqlBoxException("Fail to use newInstance() method to build a singleTon instance for '" + key + "'", e);
            }
        }
        return converter;
    }

    public static void registerConverter(Object key, FieldConverter converter) {
        converterCache.put(key, converter);
    }

    static {
        FieldConverterUtils.registerConverter("Version", new VersionFieldConverter());
        FieldConverterUtils.registerConverter("EnumType.ORDINAL", new EnumOrdinalFieldConverter());
        FieldConverterUtils.registerConverter("EnumType.STRING", new EnumStringFieldConverter());
    }
}

