/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.entitynet;

import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.TailType;
import com.github.drinkjava2.jsqlbox.entitynet.EntityIdUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityNet {
    private Map<String, TableModel> models = new LinkedHashMap<String, TableModel>();
    private List<String[]> givesList = new ArrayList<String[]>();
    private Map<Class<?>, LinkedHashMap<Object, Object>> body = new HashMap();

    protected void core__________________________() {
    }

    public EntityNet configFromPreparedSQL(PreparedSQL ps) {
        SqlBoxException.assureNotNull(ps.getModels(), "No tableModel setting found.");
        for (int i = 0; i < ps.getModels().length; ++i) {
            this.models.put(ps.getAliases()[i], (TableModel)ps.getModels()[i]);
        }
        this.addGivesList(ps.getGivesList());
        return this;
    }

    public EntityNet giveBoth(String a, String b) {
        this.give(a, b);
        this.give(b, a);
        return this;
    }

    public EntityNet give(String a, String b) {
        TableModel aModel = this.models.get(a);
        SqlBoxException.assureNotNull(aModel, "Not found config for alias '" + a + "'");
        SqlBoxException.assureNotNull(aModel.getEntityClass(), "'entityClass' property not set for model " + aModel);
        String fieldName = StrUtils.toLowerCaseFirstOne(aModel.getEntityClass().getSimpleName());
        TableModel bModel = this.models.get(b);
        SqlBoxException.assureNotNull(bModel, "Not found config for alias '" + a + "'");
        SqlBoxException.assureNotNull(bModel.getEntityClass(), "'entityClass' property not set for model " + bModel);
        Method readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName);
        if (readMethod != null) {
            this.give(a, b, StrUtils.toLowerCaseFirstOne(fieldName));
        }
        if ((readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName + "List")) != null) {
            this.give(a, b, fieldName + "List");
        }
        if ((readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName + "Set")) != null) {
            this.give(a, b, fieldName + "Set");
        }
        if ((readMethod = ClassCacheUtils.getClassFieldReadMethod(bModel.getEntityClass(), fieldName + "Map")) != null) {
            this.give(a, b, fieldName + "Map");
        }
        return this;
    }

    public EntityNet give(String a, String b, String someField) {
        SqlBoxException.assureNotEmpty(someField, "give field parameter can not be empty for '" + b + "'");
        this.givesList.add(new String[]{a, b, someField});
        return this;
    }

    public EntityNet joinTitleArrayList(List<Object[]> titleArrayList) {
        String[] titles = (String[])titleArrayList.get(0);
        int i = 0;
        for (Object[] oneRow : titleArrayList) {
            if (i++ == 0) continue;
            this.translateAndGive(titles, oneRow);
        }
        return this;
    }

    public <T> List<T> pickEntityList(String alias) {
        return this.pickEntityList(this.models.get(alias).getEntityClass());
    }

    public <T> Set<T> pickEntitySet(String alias) {
        return this.pickEntitySet(this.models.get(alias).getEntityClass());
    }

    public <T> Map<Object, T> pickEntityMap(String alias) {
        return this.pickEntityMap(this.models.get(alias).getEntityClass());
    }

    public <T> T pickOneEntity(String alias, Object entityId) {
        return (T)this.pickOneEntity(this.models.get(alias).getEntityClass(), entityId);
    }

    public <T> List<T> pickEntityList(Class<T> claz) {
        Map map = this.body.get(claz);
        if (map == null) {
            return new ArrayList();
        }
        return new ArrayList(map.values());
    }

    public <T> Set<T> pickEntitySet(Class<T> claz) {
        Map map = this.body.get(claz);
        if (map == null) {
            return new LinkedHashSet();
        }
        return new LinkedHashSet(map.values());
    }

    public <T> Map<Object, T> pickEntityMap(Class<T> claz) {
        return this.body.get(claz);
    }

    public <T> T pickOneEntity(Class<T> claz, Object entityId) {
        Object realEntityId;
        TableModel model = null;
        for (Map.Entry<String, TableModel> entry : this.models.entrySet()) {
            if (!claz.equals(entry.getValue().getEntityClass())) continue;
            model = entry.getValue();
            break;
        }
        if ((realEntityId = EntityIdUtils.buildEntityIdFromUnknow(entityId, model)) == null) {
            throw new SqlBoxException("Can not build entityId for '" + entityId + "'");
        }
        Map map = this.body.get(claz);
        if (map == null) {
            return null;
        }
        return (T)map.get(realEntityId);
    }

    private void translateAndGive(String[] titles, Object[] oneRow) {
        HashMap<String, Object> oneRowEntities = new HashMap<String, Object>();
        for (Map.Entry<String, TableModel> config : this.models.entrySet()) {
            String alias;
            TableModel model = config.getValue();
            Object entityId = EntityIdUtils.buildEntityIdFromOneRow(titles, oneRow, model, alias = config.getKey());
            if (entityId == null) continue;
            SqlBoxException.assureNotNull(model.getEntityClass(), new String[0]);
            Object entity = this.getOneEntity(model.getEntityClass(), entityId);
            if (entity == null) {
                entity = EntityNet.createEntity(titles, oneRow, model, alias);
                this.putOneEntity(model.getEntityClass(), entityId, entity);
            } else {
                EntityNet.updateEntity(titles, entity, oneRow, model, alias);
            }
            oneRowEntities.put(alias, entity);
            oneRowEntities.put("#" + alias, entity);
        }
        this.doGive(oneRowEntities);
    }

    private static Object createEntity(String[] titles, Object[] oneRow, TableModel model, String alias) {
        Object entity = ClassCacheUtils.createNewEntity(model.getEntityClass());
        return EntityNet.updateEntity(titles, entity, oneRow, model, alias);
    }

    private static Object updateEntity(String[] titles, Object entity, Object[] oneRow, TableModel model, String alias) {
        for (int i = 0; i < titles.length; ++i) {
            String colName;
            ColumnModel col;
            String titleAlias = StrUtils.substringBefore(titles[i], "_");
            if (!alias.equalsIgnoreCase(titleAlias) || (col = model.getColumnByColName(colName = StrUtils.substringAfter(titles[i], "_"))) != null && col.getTransientable().booleanValue()) continue;
            if (col == null) {
                if (!(entity instanceof TailType)) continue;
                ((TailType)entity).tails().put(colName, oneRow[i]);
                continue;
            }
            SqlBoxContextUtils.writeValueToBeanFieldOrTail(col, entity, oneRow[i]);
        }
        return entity;
    }

    private void doGive(Map<String, Object> oneRow) {
        for (String[] gives : this.givesList) {
            String fromAlias = gives[0];
            String toAlias = gives[1];
            Object from = oneRow.get(fromAlias);
            Object to = oneRow.get(toAlias);
            String tofield = gives[2];
            SqlBoxException.assureNotEmpty(tofield, new String[0]);
            if (from == null || to == null) continue;
            TableModel toModel = this.models.get(toAlias);
            ColumnModel col = toModel.getColumnByFieldName(tofield);
            Method readMethod = ClassCacheUtils.getClassFieldReadMethod(toModel.getEntityClass(), col.getEntityField());
            Class<Object> fieldType = readMethod.getReturnType();
            if (fieldType.isAssignableFrom(List.class)) {
                ArrayList<Object> list = (ArrayList<Object>)ClassCacheUtils.readValueFromBeanField(to, tofield);
                if (list == null) {
                    list = new ArrayList<Object>();
                    ClassCacheUtils.writeValueToBeanField(to, tofield, list);
                }
                if (list.contains(from)) continue;
                list.add(from);
                continue;
            }
            if (fieldType.isAssignableFrom(Set.class)) {
                HashSet<Object> set = (HashSet<Object>)ClassCacheUtils.readValueFromBeanField(to, tofield);
                if (set == null) {
                    set = new HashSet<Object>();
                    ClassCacheUtils.writeValueToBeanField(to, tofield, set);
                }
                if (set.contains(from)) continue;
                set.add(from);
                continue;
            }
            if (fieldType.isAssignableFrom(Map.class)) {
                HashMap<Object, Object> map = (HashMap<Object, Object>)ClassCacheUtils.readValueFromBeanField(to, tofield);
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    ClassCacheUtils.writeValueToBeanField(to, tofield, map);
                }
                Object entityId = oneRow.get("#" + fromAlias);
                SqlBoxException.assureNotNull(entityId, "Can not find entityId for '" + fromAlias + "'");
                if (map.containsKey(entityId)) continue;
                map.put(entityId, from);
                continue;
            }
            ClassCacheUtils.writeValueToBeanField(to, tofield, from);
        }
    }

    public void putOneEntity(Class<?> claz, Object entityId, Object entity) {
        LinkedHashMap<Object, Object> entityMap = this.body.get(claz);
        if (entityMap == null) {
            entityMap = new LinkedHashMap();
            this.body.put(claz, entityMap);
        }
        entityMap.put(entityId, entity);
    }

    public Object getOneEntity(Class<?> claz, Object entityId) {
        Map entityMap = this.body.get(claz);
        if (entityMap == null) {
            return null;
        }
        return entityMap.get(entityId);
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n=========givesList=========\r\n");
        for (String[] stringArray : this.givesList) {
            for (String str : stringArray) {
                sb.append(str + " ");
            }
            sb.append("\r\n");
        }
        sb.append("\r\n=========configs=========\r\n");
        for (TableModel tableModel : this.models.values()) {
            sb.append(tableModel.getDebugInfo());
        }
        sb.append("\r\n=========body=========\r\n");
        for (LinkedHashMap linkedHashMap : this.body.values()) {
            sb.append(linkedHashMap.toString()).append("\r\n");
        }
        return sb.toString();
    }

    public <E> List<E> findRelatedList(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        Set<E> resultSet = this.findRelatedSet(ctx, entity, sqlItems);
        return new ArrayList<E>(resultSet);
    }

    public <E> Set<E> findRelatedSet(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        TableModel[] tbModels = SqlBoxContextUtils.findAllModels(sqlItems);
        SqlBoxException.assureTrue(tbModels.length > 1, new String[0]);
        SqlBoxException.assureTrue(entity.getClass().equals(tbModels[0].getEntityClass()), new String[0]);
        return this.doFindRelatedSet(0, entity, tbModels);
    }

    public <E> Map<Object, E> findRelatedMap(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        TableModel[] tbModels = SqlBoxContextUtils.findAllModels(sqlItems);
        Set<E> resultSet = this.findRelatedSet(ctx, entity, sqlItems);
        HashMap<Object, E> resultMap = new HashMap<Object, E>();
        for (E ent : resultSet) {
            Object entityId = EntityIdUtils.buildEntityIdFromEntity(ent, tbModels[tbModels.length - 1]);
            resultMap.put(entityId, ent);
        }
        return resultMap;
    }

    private static boolean hasRelationShip(Object e1, Object e2, TableModel m1, TableModel m2) {
        String refTable;
        List<FKeyModel> fkeys = m1.getFkeyConstraints();
        for (FKeyModel fkey : fkeys) {
            refTable = fkey.getRefTableAndColumns()[0];
            if (!refTable.equalsIgnoreCase(m2.getTableName())) continue;
            return EntityNet.realDoRelationCheck(e1, e2, m1, m2, fkey);
        }
        fkeys = m2.getFkeyConstraints();
        for (FKeyModel fkey : fkeys) {
            refTable = fkey.getRefTableAndColumns()[0];
            if (!refTable.equalsIgnoreCase(m1.getTableName())) continue;
            return EntityNet.realDoRelationCheck(e2, e1, m2, m1, fkey);
        }
        throw new SqlBoxException("Not found relationship(foreign key) setting between '" + m1.getEntityClass() + "' and '" + m2.getEntityClass() + "'");
    }

    private static boolean realDoRelationCheck(Object e1, Object e2, TableModel m1, TableModel m2, FKeyModel fkey) {
        int i = 0;
        for (String col : fkey.getColumnNames()) {
            String refCol = fkey.getRefTableAndColumns()[i + 1];
            ColumnModel c1 = m1.getColumnByColName(col);
            ColumnModel c2 = m2.getColumnByColName(refCol);
            Object value1 = ClassCacheUtils.readValueFromBeanField(e1, c1.getEntityField());
            Object value2 = ClassCacheUtils.readValueFromBeanField(e2, c2.getEntityField());
            if (value1 == null || value2 == null || !value1.equals(value2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Set<Object> doFindRelatedSet(int index, Object entity, TableModel[] tbModels) {
        HashSet<Object> result = new HashSet<Object>();
        TableModel m1 = tbModels[index];
        TableModel m2 = tbModels[index + 1];
        if (index + 2 >= tbModels.length) {
            for (Map.Entry<Object, Object> e : this.body.get(m2.getEntityClass()).entrySet()) {
                if (!EntityNet.hasRelationShip(entity, e.getValue(), m1, m2)) continue;
                result.add(e.getValue());
            }
        } else {
            Set<Object> middleEntitis = this.doFindRelatedSet(0, entity, new TableModel[]{m1, m2});
            for (Object mid : middleEntitis) {
                Set<Object> targets = this.doFindRelatedSet(index + 1, mid, tbModels);
                result.addAll(targets);
            }
        }
        return result;
    }

    protected void getterSetter__________________________() {
    }

    public Map<String, TableModel> getConfigs() {
        return this.models;
    }

    public EntityNet setConfigs(Map<String, TableModel> configs) {
        this.models = configs;
        return this;
    }

    public List<String[]> getGivesList() {
        return this.givesList;
    }

    public EntityNet addGivesList(List<String[]> givesList) {
        if (givesList == null) {
            return this;
        }
        for (String[] strings : givesList) {
            if (strings == null || strings.length < 2 || strings.length > 3) {
                throw new SqlBoxException("gives should have 2 or 3 parameters");
            }
            if (strings.length == 2) {
                this.give(strings[0], strings[1]);
                continue;
            }
            this.give(strings[0], strings[1], strings[2]);
        }
        return this;
    }

    public EntityNet setGivesList(List<String[]> givesList) {
        this.givesList = givesList;
        return this;
    }

    public Map<Class<?>, LinkedHashMap<Object, Object>> getBody() {
        return this.body;
    }

    public void setBody(Map<Class<?>, LinkedHashMap<Object, Object>> body) {
        this.body = body;
    }
}

