/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.sharding;

import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.util.Collection;
import java.util.HashSet;

public class ShardingModTool
implements ShardingTool {
    @Override
    public String[] handleShardTable(SqlBoxContext ctx, TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for table '" + model.getTableName() + "'");
        }
        if (!"MOD".equalsIgnoreCase(col.getShardTable()[0])) {
            return null;
        }
        String modNumber = col.getShardTable()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        SqlBoxException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new SqlBoxException("ShardTable key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new SqlBoxException("ShardTable key value can not be null");
        }
        HashSet<String> set = new HashSet<String>();
        if (shardkey2 != null) {
            throw new SqlBoxException("ShardingModTool does not support shardBetween type method");
        }
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingModTool.calculateTableName(model.getTableName(), key, modNumber));
            }
            return set.toArray(new String[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingModTool.calculateTableName(model.getTableName(), key, modNumber));
            }
            return set.toArray(new String[set.size()]);
        }
        return new String[]{ShardingModTool.calculateTableName(model.getTableName(), shardKey1, modNumber)};
    }

    @Override
    public SqlBoxContext[] handleShardDatabase(SqlBoxContext ctx, TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new SqlBoxException("Not found ShardDatabase setting for table '" + model.getTableName() + "'");
        }
        if (!"MOD".equalsIgnoreCase(col.getShardDatabase()[0])) {
            return null;
        }
        String modNumber = col.getShardDatabase()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        SqlBoxException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new SqlBoxException("ShardDatabase key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new SqlBoxException("ShardDatabase key value can not be null");
        }
        HashSet<SqlBoxContext> set = new HashSet<SqlBoxContext>();
        if (shardkey2 != null) {
            throw new SqlBoxException("ShardingModTool does not support shardBetween type method");
        }
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingModTool.calculateMaster(ctx, key, modNumber));
            }
            return set.toArray(new SqlBoxContext[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingModTool.calculateMaster(ctx, key, modNumber));
            }
            return set.toArray(new SqlBoxContext[set.size()]);
        }
        return new SqlBoxContext[]{ShardingModTool.calculateMaster(ctx, shardKey1, modNumber)};
    }

    private static String calculateTableName(String tableName, Object keyValue, String modNumber) {
        return tableName + "_" + ShardingModTool.calculateMod(keyValue, modNumber);
    }

    private static SqlBoxContext calculateMaster(SqlBoxContext ctx, Object keyValue, String modNumber) {
        return (SqlBoxContext)ctx.getMasters()[ShardingModTool.calculateMod(keyValue, modNumber)];
    }

    private static int calculateMod(Object keyValue, String modNumber) {
        long shardKeyValue = Long.parseLong(String.valueOf(keyValue));
        int mod = Integer.parseInt(modNumber);
        return (int)(shardKeyValue % (long)mod);
    }
}

