/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.grouptx;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class GroupTxConnectionManager
implements ConnectionManager {
    private int transactionIsolation = 2;
    DataSource[] dataSources;
    private ThreadLocal<Boolean> inTransation = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<Map<DataSource, Connection>> threadLocalConnections = new ThreadLocal<Map<DataSource, Connection>>(){

        @Override
        protected Map<DataSource, Connection> initialValue() {
            return new HashMap<DataSource, Connection>();
        }
    };

    public GroupTxConnectionManager(DataSource ... dataSources) {
        this.dataSources = dataSources;
    }

    public GroupTxConnectionManager(Integer transactionIsolation, DataSource ... dataSources) {
        this.transactionIsolation = transactionIsolation;
        this.dataSources = dataSources;
    }

    public boolean isInGroupTransaction() {
        return this.inTransation.get();
    }

    public void startGroupTransaction() {
        this.inTransation.set(true);
    }

    public void endGroupTransaction() {
        this.inTransation.set(false);
        Map<DataSource, Connection> map = this.threadLocalConnections.get();
        if (map == null) {
            return;
        }
        SQLException lastExp = null;
        for (Map.Entry<DataSource, Connection> entry : map.entrySet()) {
            try {
                entry.getValue().setAutoCommit(true);
            }
            catch (SQLException e) {
                if (lastExp != null) {
                    e.setNextException(lastExp);
                }
                lastExp = e;
            }
        }
        for (Map.Entry<DataSource, Connection> entry : map.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                if (lastExp != null) {
                    e.setNextException(lastExp);
                }
                lastExp = e;
            }
        }
        map.clear();
        if (lastExp != null) {
            throw new TransactionsException(lastExp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitGroupTx() {
        if (!this.isInGroupTransaction()) {
            return;
        }
        try {
            Map<DataSource, Connection> map = this.threadLocalConnections.get();
            if (map == null) {
                return;
            }
            SQLException lastExp = null;
            for (Map.Entry<DataSource, Connection> entry : map.entrySet()) {
                Connection conn = entry.getValue();
                try {
                    conn.commit();
                    if (lastExp == null) continue;
                    conn.rollback();
                }
                catch (SQLException e) {
                    if (lastExp != null) {
                        e.setNextException(lastExp);
                    }
                    lastExp = e;
                }
            }
            if (lastExp != null) {
                throw new TransactionsException(lastExp);
            }
        }
        finally {
            this.endGroupTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackGroupTx() {
        if (!this.isInGroupTransaction()) {
            return;
        }
        try {
            Map<DataSource, Connection> map = this.threadLocalConnections.get();
            if (map == null) {
                return;
            }
            SQLException lastExp = null;
            for (Map.Entry<DataSource, Connection> entry : map.entrySet()) {
                Connection conn = entry.getValue();
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    if (lastExp != null) {
                        e.setNextException(lastExp);
                    }
                    lastExp = e;
                }
            }
            if (lastExp != null) {
                throw new TransactionsException(lastExp);
            }
        }
        finally {
            this.endGroupTransaction();
        }
    }

    @Override
    public boolean isInTransaction(DataSource ds) {
        return this.isInGroupTransaction();
    }

    @Override
    public Connection getConnection(DataSource ds) throws SQLException {
        TransactionsException.assureNotNull(ds, "DataSource can not be null");
        Connection conn = null;
        if (this.isInGroupTransaction()) {
            conn = this.threadLocalConnections.get().get(ds);
            if (conn == null) {
                conn = ds.getConnection();
                TransactionsException.assureNotNull(conn, "Can not obtain a connection from DataSource");
                conn.setTransactionIsolation(this.transactionIsolation);
                conn.setAutoCommit(false);
                this.threadLocalConnections.get().put(ds, conn);
            }
        } else {
            conn = ds.getConnection();
        }
        TransactionsException.assureNotNull(conn, "Fail to get a connection from DataSource");
        return conn;
    }

    @Override
    public void releaseConnection(Connection conn, DataSource ds) throws SQLException {
        if (!this.isInGroupTransaction() && conn != null) {
            conn.close();
        }
    }
}

