/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.grouptx;

import com.github.drinkjava2.jtransactions.grouptx.TwoKeyMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TwoKeyHashMap<K, P, V>
implements TwoKeyMap<K, P, V> {
    private Map<TwoKeyMap.TwoKey<K, P>, V> map = new HashMap<TwoKeyMap.TwoKey<K, P>, V>();

    @Override
    public V get(K key1, P key2) {
        if (key1 == null || key2 == null) {
            throw new IllegalArgumentException("key1 cannot be null");
        }
        return this.map.get(this.newKey(key1, key2));
    }

    private TwoKeyMap.TwoKey<K, P> newKey(K key1, P key2) {
        return new TwoKeyImpl<K, P>(key1, key2);
    }

    @Override
    public V get(K key1, P key2, V defValue) {
        if (key1 == null || key2 == null) {
            throw new IllegalArgumentException("key1 cannot be null");
        }
        V value = this.get(key1, key2);
        return value == null ? defValue : value;
    }

    @Override
    public V put(K key1, P key2, V value) {
        return this.map.put(this.newKey(key1, key2), value);
    }

    @Override
    public V putIfAbsent(K key1, P key2, V value) {
        V v = this.get(key1, key2);
        if (v == null) {
            v = this.put(key1, key2, value);
        }
        return v;
    }

    @Override
    public Set<Map.Entry<TwoKeyMap.TwoKey<K, P>, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<TwoKeyMap.TwoKey<K, P>> keys() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void remove(K key1, P key2) {
        Set<TwoKeyMap.TwoKey<K, P>> keys = this.keys();
        if (keys == null) {
            return;
        }
        TwoKeyMap.TwoKey<K, P> toRemove = null;
        for (TwoKeyMap.TwoKey<K, P> twoKey : keys) {
            if (key1 != twoKey.getKey1() || key2 != twoKey.getkey2()) continue;
            toRemove = twoKey;
            break;
        }
        this.map.remove(toRemove);
    }

    static class TwoKeyImpl<K, P>
    implements TwoKeyMap.TwoKey<K, P> {
        private K key1;
        private P key2;

        TwoKeyImpl(K key1, P key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        @Override
        public K getKey1() {
            return this.key1;
        }

        @Override
        public P getkey2() {
            return this.key2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key1 == null ? 0 : this.key1.hashCode());
            result = 31 * result + (this.key2 == null ? 0 : this.key2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TwoKeyImpl other = (TwoKeyImpl)obj;
            if (this.key1 == null ? other.key1 != null : !this.key1.equals(other.key1)) {
                return false;
            }
            return !(this.key2 == null ? other.key2 != null : !this.key2.equals(other.key2));
        }
    }
}

