/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class TinyTxConnectionManager
implements ConnectionManager {
    private static final ThreadLocal<Map<DataSource, Connection>> threadLocalConnections = new ThreadLocal<Map<DataSource, Connection>>(){

        @Override
        protected Map<DataSource, Connection> initialValue() {
            return new HashMap<DataSource, Connection>();
        }
    };

    public static final TinyTxConnectionManager instance() {
        return InnerTinyTxConnectionManager.INSTANCE;
    }

    @Override
    public boolean isInTransaction(DataSource ds) {
        TransactionsException.assureNotNull(ds, "DataSource can not be null in isInTransaction method");
        return null != threadLocalConnections.get().get(ds);
    }

    public Connection startTransaction(DataSource ds, int transactionIsolation) {
        TransactionsException.assureNotNull(ds, "DataSource can not be null in startTransaction method");
        if (null != threadLocalConnections.get().get(ds)) {
            throw new TransactionsException("Can not start transaction in an existing transaction.");
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ds);
            TransactionsException.assureNotNull(conn, "Can not obtain a connection from DataSource");
            conn.setTransactionIsolation(transactionIsolation);
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    throw new TransactionsException("Fail to close connection" + e2 + ", root cause:" + e);
                }
            }
            throw new TransactionsException(e);
        }
        threadLocalConnections.get().put(ds, conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(DataSource ds) throws SQLException {
        Connection conn = null;
        try {
            conn = threadLocalConnections.get().get(ds);
            TransactionsException.assureNotNull(conn, "Connection can not get from DataSource");
            conn.commit();
            this.setAutoCommitTrue(conn);
        }
        finally {
            if (conn != null) {
                this.endTransaction(conn, ds);
            }
        }
    }

    public void rollback(DataSource ds) {
        Connection conn = threadLocalConnections.get().get(ds);
        try {
            if (conn != null) {
                conn.rollback();
                this.setAutoCommitTrue(conn);
                this.endTransaction(conn, ds);
            }
        }
        catch (SQLException e) {
            throw new TransactionsException(e);
        }
    }

    private void endTransaction(Connection conn, DataSource ds) throws SQLException {
        TransactionsException.assureNotNull(ds, "DataSource can not be null");
        threadLocalConnections.get().remove(ds);
        this.releaseConnection(conn, ds);
    }

    @Override
    public Connection getConnection(DataSource ds) throws SQLException {
        TransactionsException.assureNotNull(ds, "DataSource can not be null");
        Connection conn = threadLocalConnections.get().get(ds);
        if (conn == null) {
            conn = ds.getConnection();
        }
        TransactionsException.assureNotNull(conn, "Fail to get a connection from DataSource");
        return conn;
    }

    @Override
    public void releaseConnection(Connection conn, DataSource ds) throws SQLException {
        Connection saved = threadLocalConnections.get().get(ds);
        if ((saved == null || saved != conn) && conn != null) {
            conn.close();
        }
    }

    private void setAutoCommitTrue(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new TransactionsException("Fail to setAutoCommit to true", e);
        }
    }

    private static class InnerTinyTxConnectionManager {
        private static final TinyTxConnectionManager INSTANCE = new TinyTxConnectionManager();

        private InnerTinyTxConnectionManager() {
        }
    }
}

