/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.JDBPRO;
import com.github.drinkjava2.jdbpro.LinkArrayList;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.IdentityIdGenerator;
import com.github.drinkjava2.jdialects.id.SnowflakeCreator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.JSQLBOX;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.TailType;
import com.github.drinkjava2.jsqlbox.converter.FieldConverter;
import com.github.drinkjava2.jsqlbox.converter.FieldConverterUtils;
import com.github.drinkjava2.jsqlbox.entitynet.EntityIdUtils;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import com.github.drinkjava2.jsqlbox.gtx.GtxTag;
import com.github.drinkjava2.jsqlbox.gtx.GtxUtils;
import com.github.drinkjava2.jsqlbox.handler.EntityNetHandler;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import com.github.drinkjava2.jsqlbox.sqlitem.EntityKeyItem;
import com.github.drinkjava2.jsqlbox.sqlitem.SampleItem;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SqlBoxContextUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel[] loadMetaTableModels(SqlBoxContext ctx, Dialect dialect) {
        Connection con = null;
        SQLException sqlException = null;
        try {
            con = ctx.prepareConnection();
            TableModel[] tableModelArray = TableModelUtils.db2Models(con, dialect);
            return tableModelArray;
        }
        catch (SQLException e) {
            sqlException = e;
        }
        finally {
            try {
                ctx.close(con);
            }
            catch (SQLException e) {
                if (sqlException != null) {
                    sqlException.setNextException(e);
                }
                sqlException = e;
            }
        }
        throw new SqlBoxException(sqlException);
    }

    public static SqlBoxContext getShardedDB(SqlBoxContext currentCtx, Object entityOrClass, Object ... shardKey) {
        Integer shardDBCode = SqlBoxContextUtils.getShardedDBCode(currentCtx, entityOrClass, shardKey);
        if (shardDBCode == null) {
            return currentCtx;
        }
        return (SqlBoxContext)currentCtx.getMasters()[shardDBCode];
    }

    public static Integer getShardedDbCodeByBean(SqlBoxContext ctx, Object entity) {
        ColumnModel col = TableModelUtils.entity2ReadOnlyModel(entity.getClass()).getShardDatabaseColumn();
        if (col == null) {
            return ctx.getDbCode();
        }
        Object value = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entity);
        SqlBoxException.assureNotNull(value, "Entity bean's shardDatabase field value can not be null.");
        Integer dbCode = SqlBoxContextUtils.getShardedDBCode(ctx, entity.getClass(), value);
        SqlBoxException.assureNotNull(dbCode, "Entity bean's shardDatabase value can not map to a dbCode.");
        return dbCode;
    }

    public static String getShardedTbByBean(SqlBoxContext ctx, Object entity) {
        TableModel model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
        ColumnModel col = model.getShardTableColumn();
        if (col == null) {
            return model.getTableName();
        }
        Object value = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entity);
        SqlBoxException.assureNotNull(value, "Entity bean's shardTable field value can not be null.");
        Integer tbCode = SqlBoxContextUtils.getShardedTBCode(ctx, entity.getClass(), value);
        SqlBoxException.assureNotNull(tbCode, "Entity bean's shardTable value can not map to a table code");
        return model.getTableName() + "_" + tbCode;
    }

    public static Integer getShardedDBCode(SqlBoxContext ctx, Object entityOrClass, Object ... shardKey) {
        if (ctx.getMasters() == null || ctx.getMasters().length == 0) {
            return null;
        }
        if (ctx.getShardingTools() == null || ctx.getShardingTools().length == 0) {
            return null;
        }
        TableModel model = SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
        for (ShardingTool sh : ctx.getShardingTools()) {
            Integer[] result = sh.handleShardDatabase(model, shardKey);
            if (result == null) continue;
            if (result.length > 1) {
                throw new SqlBoxException("Found more than 1 SqlBoxContext tables for target '" + model.getEntityClass() + "', jSqlBox current version do not support auto-join, to solve this issue you need adjust your ShardDatabase search condition.");
            }
            return result[0];
        }
        return null;
    }

    public static String getShardedTB(SqlBoxContext ctx, Object entityOrClass, Object ... shardKey) {
        Integer shardedTBCode = SqlBoxContextUtils.getShardedTBCode(ctx, entityOrClass, shardKey);
        TableModel model = SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
        if (shardedTBCode == null) {
            return model.getTableName();
        }
        return model.getTableName() + "_" + shardedTBCode;
    }

    public static Integer getShardedTBCode(SqlBoxContext ctx, Object entityOrClass, Object ... shardKey) {
        if (ctx.getShardingTools() == null || ctx.getShardingTools().length == 0) {
            return null;
        }
        TableModel model = SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
        for (ShardingTool sh : ctx.getShardingTools()) {
            Integer[] result = sh.handleShardTable(model, shardKey);
            if (result == null) continue;
            if (result.length > 1) {
                throw new SqlBoxException("Found more than 1 sharding tables for target '" + model.getEntityClass() + "', jSqlBox current version do not support auto-join, to solve this issue you need adjust your ShardTable search condition");
            }
            return result[0];
        }
        return null;
    }

    public static TableModel findTableModel(Object entityOrClass, Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findFirstModel(optionItems);
        if (model != null) {
            return model;
        }
        return SqlBoxContextUtils.findEntityOrClassTableModel(entityOrClass);
    }

    public static TableModel findEntityOrClassTableModel(Object entityOrClassOrModel) {
        if (entityOrClassOrModel == null) {
            throw new SqlBoxException("Can not build TableModel from null entityOrClass");
        }
        if (entityOrClassOrModel instanceof TableModel) {
            return (TableModel)entityOrClassOrModel;
        }
        if (entityOrClassOrModel instanceof Class) {
            return TableModelUtils.entity2ReadOnlyModel((Class)entityOrClassOrModel);
        }
        return TableModelUtils.entity2ReadOnlyModel(entityOrClassOrModel.getClass());
    }

    public static TableModel findFirstModel(Object ... optionItems) {
        for (Object item : optionItems) {
            if (item instanceof TableModel) {
                return (TableModel)item;
            }
            if (!(item instanceof Class)) continue;
            return TableModelUtils.entity2ReadOnlyModel((Class)item);
        }
        return null;
    }

    public static TableModel findTailModel(SqlBoxContext ctx, TableModel entityModel, Object ... optionItems) {
        String tailTable = null;
        for (Object item : optionItems) {
            if (!(item instanceof SqlItem) || !SqlOption.TAIL.equals((Object)((SqlItem)item).getType())) continue;
            if (((SqlItem)item).getParameters().length == 0) {
                tailTable = "";
                break;
            }
            tailTable = (String)((SqlItem)item).getParameters()[0];
            break;
        }
        if (tailTable == null) {
            return null;
        }
        if ("".equals(tailTable)) {
            tailTable = entityModel.getTableName();
        }
        ctx.ensureTailModelLoaded();
        for (TableModel model : ctx.getTailModels()) {
            if (!tailTable.equalsIgnoreCase(model.getTableName())) continue;
            return model;
        }
        throw new SqlBoxException("Not found table '" + tailTable + "' in database");
    }

    public static TableModel[] findAllModels(Object ... sqlItems) {
        ArrayList<TableModel> result = new ArrayList<TableModel>();
        SqlBoxContextUtils.doFindAllModels(result, sqlItems);
        return result.toArray(new TableModel[result.size()]);
    }

    private static void doFindAllModels(List<TableModel> result, Object ... sqlItems) {
        for (Object item : sqlItems) {
            if (item instanceof TableModel) {
                result.add((TableModel)item);
                continue;
            }
            if (item instanceof Class) {
                result.add(TableModelUtils.entity2ReadOnlyModel((Class)item));
                continue;
            }
            if (!item.getClass().isArray()) continue;
            SqlBoxContextUtils.doFindAllModels(result, (Object[])item);
        }
    }

    public static Object[] findModelAlias(Object ... sqlItems) {
        ArrayList<Object> result = new ArrayList<Object>();
        SqlBoxContextUtils.dofindModelAlias(result, sqlItems);
        return result.toArray(new Object[result.size()]);
    }

    private static void dofindModelAlias(List<Object> result, Object ... sqlItems) {
        for (Object item : sqlItems) {
            SqlItem sqItem;
            SqlOption sqlItemType;
            if (item instanceof TableModel) {
                result.add((TableModel)item);
                continue;
            }
            if (item instanceof Class) {
                result.add(TableModelUtils.entity2ReadOnlyModel((Class)item));
                continue;
            }
            if (item.getClass().isArray()) {
                SqlBoxContextUtils.dofindModelAlias(result, (Object[])item);
                continue;
            }
            if (!(item instanceof SqlItem) || !SqlOption.ALIAS.equals((Object)(sqlItemType = (sqItem = (SqlItem)item).getType()))) continue;
            result.add(item);
        }
    }

    public static Object[] findNotModelAlias(Object ... sqlItems) {
        ArrayList<Object> result = new ArrayList<Object>();
        SqlBoxContextUtils.dofindNotModelAlias(result, sqlItems);
        return result.toArray(new Object[result.size()]);
    }

    private static void dofindNotModelAlias(List<Object> result, Object ... sqlItems) {
        for (Object item : sqlItems) {
            if (item instanceof TableModel || item instanceof Class) continue;
            if (item.getClass().isArray()) {
                SqlBoxContextUtils.dofindNotModelAlias(result, (Object[])item);
                continue;
            }
            if (item instanceof SqlItem) {
                if (SqlOption.ALIAS.equals((Object)((SqlItem)item).getType())) continue;
                result.add(item);
                continue;
            }
            result.add(item);
        }
    }

    private static SqlBoxContext extractCtx(Object ... sqlItems) {
        for (Object item : sqlItems) {
            SqlBoxContext ctx;
            if (item instanceof SqlBoxContext) {
                return (SqlBoxContext)item;
            }
            if (item == null || !item.getClass().isArray() || (ctx = SqlBoxContextUtils.extractCtx((Object[])item)) == null) continue;
            return ctx;
        }
        return null;
    }

    private static void removeSqlBoxContextFromParam(List<Object> resultList, boolean founded, Object ... sqlItems) {
        boolean found = founded;
        for (Object item : sqlItems) {
            if (item instanceof SqlBoxContext) {
                if (founded) {
                    resultList.add(item);
                }
                found = true;
                continue;
            }
            if (item != null && item.getClass().isArray()) {
                SqlBoxContextUtils.removeSqlBoxContextFromParam(resultList, found, (Object[])item);
                continue;
            }
            resultList.add(item);
        }
    }

    private static Object[] cleanUpParam(Object ... sqlItems) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        SqlBoxContextUtils.removeSqlBoxContextFromParam(resultList, false, sqlItems);
        return resultList.toArray(new Object[resultList.size()]);
    }

    public static void createLastAutoAliasName(PreparedSQL ps) {
        if (ps.getModels() == null || ps.getModels().length == 0) {
            throw new SqlBoxException("No tableModel found");
        }
        TableModel model = (TableModel)ps.getModels()[ps.getModels().length - 1];
        StringBuilder sb = new StringBuilder();
        char[] chars = model.getEntityClass() != null ? model.getEntityClass().getSimpleName().toCharArray() : model.getTableName().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && (c < 'A' || c > 'Z') && (i <= 0 || chars[i - 1] != '_')) continue;
            sb.append(c);
        }
        String alias = sb.toString().toLowerCase();
        String[] aliases = ps.getAliases();
        int count = 1;
        String newAlias = alias;
        boolean found = false;
        block1: do {
            for (int i = 0; i < aliases.length - 2; ++i) {
                if (!newAlias.equals(aliases[i])) continue;
                newAlias = alias + count++;
                found = true;
                continue block1;
            }
        } while (found);
        ps.setLastAliases(newAlias);
    }

    public static <T> T mapToEntityBean(TableModel model, Map<String, Object> oneRow) {
        if (oneRow == null || oneRow.isEmpty()) {
            throw new SqlBoxException("Can not use null or empty row to convert to EntityBean");
        }
        SqlBoxException.assureNotNull(model.getEntityClass(), "Can not find entityClass setting in model.");
        Object bean = ClassCacheUtils.createNewEntity(model.getEntityClass());
        for (Map.Entry<String, Object> entry : oneRow.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ColumnModel col = model.getColumnByColName(key);
            if (col == null) {
                if (!(bean instanceof TailType)) continue;
                ((TailType)bean).tails().put(key, value);
                continue;
            }
            SqlBoxContextUtils.writeValueToBeanFieldOrTail(col, bean, value);
        }
        return (T)bean;
    }

    public static <T> T entityOrClassToBean(Object entityOrClass) {
        if (entityOrClass == null) {
            throw new SqlBoxException("Can build Bean for null entityOrClass");
        }
        if (entityOrClass instanceof Class) {
            try {
                return ((Class)entityOrClass).newInstance();
            }
            catch (Exception e) {
                throw new SqlBoxException("Can not create new instance for '" + entityOrClass + "'");
            }
        }
        return (T)entityOrClass;
    }

    protected static void appendLeftJoinSQL(PreparedSQL ps) {
        int i;
        Object[] m = ps.getModels();
        String[] a = ps.getAliases();
        SqlBoxException.assureTrue(m != null && a != null && m.length == a.length, new String[0]);
        StringBuilder sb = new StringBuilder(" select ");
        boolean ifFirst = true;
        for (i = 0; i < m.length; ++i) {
            TableModel md = (TableModel)m[i];
            for (ColumnModel col : md.getColumns()) {
                if (col.getTransientable().booleanValue()) continue;
                if (ifFirst) {
                    ifFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(a[i]).append(".").append(col.getColumnName()).append(" as ").append(a[i]).append("_").append(col.getColumnName());
            }
        }
        sb.append(" from ");
        sb.append(((TableModel)m[0]).getTableName()).append(" ").append(a[0]).append(" ");
        for (i = 1; i < m.length; ++i) {
            sb.append(" left join ");
            sb.append(((TableModel)m[i]).getTableName()).append(" ").append(a[i]);
            sb.append(" on ");
            SqlBoxContextUtils.appendKeyEquelsSqlPiece(sb, a[i - 1], (TableModel)m[i - 1], a[i], (TableModel)m[i]);
        }
        ps.addSql(sb.toString());
    }

    private static void appendKeyEquelsSqlPiece(StringBuilder sb, String a1, TableModel m1, String a2, TableModel m2) {
        String refTable;
        List<FKeyModel> fkeys = m1.getFkeyConstraints();
        for (FKeyModel fkey : fkeys) {
            refTable = fkey.getRefTableAndColumns()[0];
            if (!refTable.equalsIgnoreCase(m2.getTableName())) continue;
            SqlBoxContextUtils.realDoAppendKeyEquelsSqlPiece(sb, a1, a2, fkey);
            return;
        }
        fkeys = m2.getFkeyConstraints();
        for (FKeyModel fkey : fkeys) {
            refTable = fkey.getRefTableAndColumns()[0];
            if (!refTable.equalsIgnoreCase(m1.getTableName())) continue;
            SqlBoxContextUtils.realDoAppendKeyEquelsSqlPiece(sb, a2, a1, fkey);
            return;
        }
        throw new SqlBoxException("Not found relationship(foreign key) setting between '" + m1.getEntityClass() + "' and '" + m2.getEntityClass() + "'");
    }

    private static void realDoAppendKeyEquelsSqlPiece(StringBuilder sb, String a, String b, FKeyModel fkey) {
        int i = 0;
        for (String col : fkey.getColumnNames()) {
            if (i > 0) {
                sb.append("and ");
            }
            sb.append(a).append(".").append(col).append("=").append(b).append(".").append(fkey.getRefTableAndColumns()[i + 1]).append(" ");
            ++i;
        }
    }

    public static Object readValueFromBeanFieldOrTail(ColumnModel columnModel, Object entityBean) {
        SqlBoxException.assureNotNull(columnModel, "columnModel can not be null.");
        if (columnModel.getValueExist().booleanValue()) {
            return columnModel.getValue();
        }
        if (columnModel.getConverterClassOrName() != null) {
            FieldConverter cust = FieldConverterUtils.getFieldConverter(columnModel.getConverterClassOrName());
            return cust.entityFieldToDbValue(columnModel, entityBean);
        }
        return SqlBoxContextUtils.doReadFromFieldOrTail(columnModel, entityBean);
    }

    public static Object doReadFromFieldOrTail(ColumnModel columnModel, Object entityBean) {
        if (columnModel.getTransientable().booleanValue()) {
            return null;
        }
        String fieldName = columnModel.getEntityField();
        if (fieldName == null) {
            if (entityBean instanceof TailType) {
                return ((TailType)entityBean).tails().get(columnModel.getColumnName());
            }
            throw new SqlBoxException("Can not read tail value from instance which is not TailSupport");
        }
        Method readMethod = ClassCacheUtils.getClassFieldReadMethod(entityBean.getClass(), fieldName);
        if (readMethod != null) {
            try {
                return readMethod.invoke(entityBean, new Object[0]);
            }
            catch (Exception e) {
                throw new SqlBoxException(e);
            }
        }
        if (entityBean instanceof TailType) {
            return ((TailType)entityBean).tails().get(fieldName);
        }
        throw new SqlBoxException("No read method for '" + fieldName + "'");
    }

    public static void writeValueToBeanFieldOrTail(ColumnModel columnModel, Object entityBean, Object value) {
        SqlBoxException.assureNotNull(columnModel, "columnModel can not be null");
        if (columnModel.getConverterClassOrName() != null) {
            FieldConverter converter = FieldConverterUtils.getFieldConverter(columnModel.getConverterClassOrName());
            converter.writeDbValueToEntityField(entityBean, columnModel, value);
        } else {
            SqlBoxContextUtils.doWriteToFieldOrTail(columnModel, entityBean, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doWriteToFieldOrTail(ColumnModel columnModel, Object entityBean, Object value) {
        SqlBoxException.assureNotNull(columnModel, "columnModel can not be null");
        if (columnModel.getTransientable().booleanValue()) {
            return;
        }
        String fieldName = columnModel.getEntityField();
        if (fieldName == null) {
            if (!(entityBean instanceof TailType)) throw new SqlBoxException("Can not write tail value for entity which is not TailSupport");
            ((TailType)entityBean).tails().put(columnModel.getColumnName(), value);
            return;
        }
        try {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(entityBean.getClass(), fieldName);
            writeMethod.invoke(entityBean, value);
            return;
        }
        catch (Exception e) {
            throw new SqlBoxException("FieldName '" + fieldName + "' can not write with value '" + value + "'", e);
        }
    }

    public static String entityCompare(Object entityBean1, Object entityBean2, TableModel ... optionModel) {
        TableModel model = optionModel.length > 0 ? optionModel[0] : TableModelUtils.entity2Model(entityBean1.getClass());
        for (ColumnModel col : model.getColumns()) {
            if (col == null || col.getTransientable().booleanValue()) continue;
            Object value1 = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean1);
            Object value2 = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean2);
            if (value1 != null && !value1.equals(value2)) {
                return col.getEntityField();
            }
            if (value2 == null || value2.equals(value1)) continue;
            return col.getEntityField();
        }
        return "";
    }

    private static void coreMethods___________________________________() {
    }

    public static int entityInsertTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityInsertTry(paramCtx, entityBean, newParams);
        }
        int result = SqlBoxContextUtils.doEntityInsertTry(ctx, entityBean, optionItems);
        if (result == 1 && ctx.isGtxOpen() && !(entityBean instanceof GtxTag)) {
            GtxUtils.reg(ctx, entityBean, "INSERT");
        }
        return result;
    }

    private static int doEntityInsertTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = null;
        if (entityBean instanceof TailType && (tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems)) != null) {
            for (String colName : ((TailType)entityBean).tails().keySet()) {
                ColumnModel col = tailModel.getColumnByColName(colName);
                if (col == null) continue;
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        ColumnModel identityCol = null;
        Type identityType = null;
        Boolean ignoreNull = null;
        sqlBody.append(" (");
        boolean foundColumnToInsert = false;
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        for (ColumnModel col : cols.values()) {
            if (col == null || col.getTransientable().booleanValue() || !col.getInsertable().booleanValue()) continue;
            if (col.getConverterClassOrName() != null) {
                FieldConverter converter = FieldConverterUtils.getFieldConverter(col.getConverterClassOrName());
                converter.handleSQL(SqlOption.INSERT, ctx, col, entityBean, sqlBody, null);
                continue;
            }
            Object value = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean);
            if (value == null && col.getIdGenerationType() != null || !StrUtils.isEmpty(col.getIdGeneratorName())) {
                if (col.getIdGenerator() == null) {
                    throw new SqlBoxException("No IdGenerator found for column '" + col.getColumnName() + "'");
                }
                IdGenerator idGen = col.getIdGenerator();
                if (GenerationType.IDENTITY.equals((Object)idGen.getGenerationType())) {
                    if (identityCol != null) {
                        throw new SqlBoxException("More than 1 identity field found for table '" + model.getTableName() + "'");
                    }
                    identityType = col.getColumnType();
                    identityCol = col;
                } else if (GenerationType.SNOWFLAKE.equals((Object)idGen.getGenerationType())) {
                    sqlBody.append(col.getColumnName());
                    SnowflakeCreator snow = ctx.getSnowflakeCreator();
                    if (snow == null) {
                        throw new SqlBoxException("Current SqlBoxContext no SnowflakeCreator found when try to create a Snowflake value");
                    }
                    Long id = snow.nextId();
                    sqlBody.append(JDBPRO.param(id));
                    sqlBody.append(", ");
                    foundColumnToInsert = true;
                    SqlBoxContextUtils.writeValueToBeanFieldOrTail(col, entityBean, id);
                } else {
                    sqlBody.append(col.getColumnName());
                    Object id = idGen.getNextID(ctx, ctx.getDialect(), col.getColumnType());
                    sqlBody.append(JDBPRO.param(id));
                    sqlBody.append(", ");
                    foundColumnToInsert = true;
                    SqlBoxContextUtils.writeValueToBeanFieldOrTail(col, entityBean, id);
                }
            } else {
                if (value == null && ignoreNull == null) {
                    for (Object itemObject : optionItems) {
                        if (!SqlOption.IGNORE_NULL.equals(itemObject)) continue;
                        ignoreNull = true;
                        break;
                    }
                    if (ignoreNull == null) {
                        ignoreNull = false;
                    }
                }
                if (ignoreNull == null || !ignoreNull.booleanValue() || value != null) {
                    sqlBody.append(col.getColumnName());
                    sqlBody.append(new SqlItem(SqlOption.PARAM, value));
                    sqlBody.append(", ");
                    foundColumnToInsert = true;
                }
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean));
        }
        if (foundColumnToInsert) {
            sqlBody.remove(sqlBody.size() - 1);
        }
        if (shardTableItem != null) {
            sqlBody.frontAdd(shardTableItem);
        } else {
            sqlBody.frontAdd(tableName);
        }
        if (shardDbItem != null) {
            sqlBody.append(shardDbItem);
        }
        sqlBody.frontAdd("insert into ");
        sqlBody.append(") ");
        sqlBody.append(JDBPRO.valuesQuestions());
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        int result = ctx.iUpdate(sqlBody.toArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        if (identityCol != null) {
            Object identityId = IdentityIdGenerator.INSTANCE.getNextID(ctx, ctx.getDialect(), identityType);
            SqlBoxContextUtils.writeValueToBeanFieldOrTail(identityCol, entityBean, identityId);
        }
        return result;
    }

    public static int entityUpdateTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        int result;
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityUpdateTry(paramCtx, entityBean, newParams);
        }
        Object oldEntity = null;
        if (ctx.isGtxOpen() && !(entityBean instanceof GtxTag)) {
            oldEntity = SqlBoxContextUtils.doEntityLoadByIdTry(ctx, entityBean.getClass(), entityBean, optionItems);
        }
        if ((result = SqlBoxContextUtils.doEntityUpdateTry(ctx, entityBean, optionItems)) == 1 && ctx.isGtxOpen() && !(entityBean instanceof GtxTag)) {
            GtxUtils.reg(ctx, oldEntity, "BEFORE");
            GtxUtils.reg(ctx, entityBean, "AFTER");
        }
        return result;
    }

    private static int doEntityUpdateTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = null;
        if (entityBean instanceof TailType && (tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems)) != null) {
            for (String colName : ((TailType)entityBean).tails().keySet()) {
                ColumnModel col = tailModel.getColumnByColName(colName);
                if (col == null) continue;
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        LinkArrayList<Object> sqlWhere = new LinkArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        Boolean ignoreNull = null;
        for (ColumnModel col : cols.values()) {
            if (col.getTransientable().booleanValue() || !col.getUpdatable().booleanValue()) continue;
            String fieldName = col.getEntityField();
            if (StrUtils.isEmpty(fieldName)) {
                fieldName = col.getColumnName();
            }
            SqlBoxException.assureNotEmpty(fieldName, "Found a column not mapped to entity field or DB column in model '" + model + "'");
            if (col.getConverterClassOrName() != null) {
                FieldConverter converter = FieldConverterUtils.getFieldConverter(col.getConverterClassOrName());
                converter.handleSQL(SqlOption.UPDATE, ctx, col, entityBean, sqlBody, sqlWhere);
                continue;
            }
            Object value = SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean);
            if (col.getPkey().booleanValue()) {
                if (!sqlWhere.isEmpty()) {
                    sqlWhere.append(" and ");
                }
                sqlWhere.append(col.getColumnName()).append("=?");
                sqlWhere.append(JDBPRO.param(value));
            } else {
                if (value == null && ignoreNull == null) {
                    for (Object itemObject : optionItems) {
                        if (!SqlOption.IGNORE_NULL.equals(itemObject)) continue;
                        ignoreNull = true;
                        break;
                    }
                    if (ignoreNull == null) {
                        ignoreNull = false;
                    }
                }
                if (ignoreNull == null || !ignoreNull.booleanValue() || value != null) {
                    if (!sqlBody.isEmpty()) {
                        sqlBody.append(", ");
                    }
                    sqlBody.append(col.getColumnName()).append("=? ");
                    sqlBody.append(JDBPRO.param(value));
                }
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(value);
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(value);
        }
        sqlBody.frontAdd(" set ");
        if (shardTableItem != null) {
            sqlBody.frontAdd(shardTableItem);
        } else {
            sqlBody.frontAdd(tableName);
        }
        if (shardDbItem != null) {
            sqlBody.append(shardDbItem);
        }
        sqlBody.frontAdd("update ");
        sqlBody.append(" where ");
        sqlBody.addAll(sqlWhere);
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        int rowAffected = ctx.iUpdate(sqlBody.toObjectArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        return rowAffected;
    }

    public static int entityDeleteTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        return SqlBoxContextUtils.entityDeleteByIdTry(ctx, entityBean.getClass(), entityBean, optionItems);
    }

    public static int entityDeleteByIdTry(SqlBoxContext ctx, Class<?> entityClass, Object id, Object ... optionItems) {
        int result;
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityDeleteByIdTry(paramCtx, entityClass, id, newParams);
        }
        Object oldEntity = null;
        if (ctx.isGtxOpen() && !(id instanceof GtxTag)) {
            oldEntity = SqlBoxContextUtils.doEntityLoadByIdTry(ctx, entityClass, id, optionItems);
        }
        if ((result = SqlBoxContextUtils.doEntityDeleteByIdTry(ctx, entityClass, id, optionItems)) == 1 && ctx.isGtxOpen() && !(id instanceof GtxTag)) {
            GtxUtils.reg(ctx, oldEntity, "DELETE");
        }
        return result;
    }

    protected static int doEntityDeleteByIdTry(SqlBoxContext ctx, Class<?> entityClass, Object id, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityDeleteByIdTry(paramCtx, entityClass, id, newParams);
        }
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = null;
        if (id instanceof TailType && (tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems)) != null) {
            for (String colName : ((TailType)id).tails().keySet()) {
                ColumnModel col = tailModel.getColumnByColName(colName);
                if (col == null) continue;
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        LinkArrayList<Object> sqlWhere = new LinkArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        for (ColumnModel col : cols.values()) {
            if (col == null || col.getTransientable().booleanValue()) continue;
            if (col.getConverterClassOrName() != null) {
                FieldConverter converter = FieldConverterUtils.getFieldConverter(col.getConverterClassOrName());
                converter.handleSQL(SqlOption.DELETE, ctx, col, id, sqlBody, sqlWhere);
                continue;
            }
            if (col.getPkey().booleanValue()) {
                Object value = EntityIdUtils.readFeidlValueFromEntityId(id, col);
                if (!sqlWhere.isEmpty()) {
                    sqlWhere.append(" and ");
                }
                sqlWhere.append(JDBPRO.param(value));
                sqlWhere.append(col.getColumnName()).append("=? ");
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(EntityIdUtils.readFeidlValueFromEntityId(id, col));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(EntityIdUtils.readFeidlValueFromEntityId(id, col));
        }
        if (sqlWhere.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        sqlBody.append("delete from ");
        if (shardTableItem != null) {
            sqlBody.append(shardTableItem);
        } else {
            sqlBody.append(tableName);
        }
        if (shardDbItem != null) {
            sqlBody.append(shardDbItem);
        }
        sqlBody.append(" where ").addAll(sqlWhere);
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        sqlBody.append(SingleTonHandlers.arrayHandler);
        int rowAffected = ctx.iUpdate(sqlBody.toObjectArray());
        if (ctx.isBatchEnabled()) {
            return 1;
        }
        return rowAffected;
    }

    public static int entityLoadTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityLoadTry(paramCtx, entityBean, newParams);
        }
        int result = SqlBoxContextUtils.doEntityLoadTry(ctx, entityBean, optionItems);
        if (result == 1 && ctx.isGtxOpen() && !(entityBean instanceof GtxTag)) {
            GtxUtils.reg(ctx, entityBean, "BEFORE");
        }
        return result;
    }

    private static int doEntityLoadTry(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = null;
        if (entityBean instanceof TailType && (tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems)) != null) {
            for (String colName : ((TailType)entityBean).tails().keySet()) {
                ColumnModel col = tailModel.getColumnByColName(colName);
                if (col == null) continue;
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        LinkArrayList<String> sqlWhere = new LinkArrayList<String>();
        ArrayList<ColumnModel> effectColumns = new ArrayList<ColumnModel>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        for (ColumnModel col : cols.values()) {
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                sqlWhere.append(col.getColumnName()).append("=?").append((String)((Object)JDBPRO.param(SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean)))).append(" and ");
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean));
            }
            if (col.getShardDatabase() != null) {
                shardDbItem = JSQLBOX.shardDB(SqlBoxContextUtils.readValueFromBeanFieldOrTail(col, entityBean));
            }
            sqlBody.append(col.getColumnName()).append(", ");
            effectColumns.add(col);
        }
        sqlBody.remove(sqlBody.size() - 1);
        if (sqlWhere.isEmpty()) {
            throw new SqlBoxException("No PKey column found from tableModel '" + model.getTableName() + "'");
        }
        sqlWhere.remove(sqlWhere.size() - 1);
        sqlBody.frontAdd("select ").append(" from ");
        if (shardTableItem != null) {
            sqlBody.append(shardTableItem);
        } else {
            sqlBody.append(tableName);
        }
        if (shardDbItem != null) {
            sqlBody.append(shardDbItem);
        }
        sqlBody.append(" where ").addAll(sqlWhere);
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        sqlBody.append(SingleTonHandlers.arrayListHandler);
        List valuesList = (List)ctx.iQuery(sqlBody.toObjectArray());
        if (valuesList == null || valuesList.isEmpty()) {
            return 0;
        }
        Object[] values = (Object[])valuesList.get(0);
        for (int i = 0; i < values.length; ++i) {
            SqlBoxContextUtils.writeValueToBeanFieldOrTail((ColumnModel)effectColumns.get(i), entityBean, values[i]);
        }
        return valuesList.size();
    }

    public static <T> T entityLoadByIdTry(SqlBoxContext ctx, Class<T> entityClass, Object id, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityLoadByIdTry(paramCtx, entityClass, id, newParams);
        }
        T result = SqlBoxContextUtils.doEntityLoadByIdTry(ctx, entityClass, id, optionItems);
        if (result != null && ctx.isGtxOpen() && !(id instanceof GtxTag)) {
            GtxUtils.reg(ctx, result, "EXSTRICT");
        }
        return result;
    }

    private static <T> T doEntityLoadByIdTry(SqlBoxContext ctx, Class<T> entityClass, Object id, Object ... optionItems) {
        T bean = SqlBoxContextUtils.buildBeanById(ctx, entityClass, id, optionItems);
        int result = SqlBoxContextUtils.doEntityLoadTry(ctx, bean, optionItems);
        if (result != 1) {
            return null;
        }
        return bean;
    }

    private static <T> T buildBeanById(SqlBoxContext ctx, Class<T> entityClass, Object id, Object ... optionItems) {
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems);
        if (tailModel != null) {
            for (ColumnModel col : tailModel.getColumns()) {
                if (col == null) continue;
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        T bean = SqlBoxContextUtils.entityOrClassToBean(entityClass);
        bean = EntityIdUtils.setEntityIdValues(bean, id, cols.values());
        return bean;
    }

    public static boolean entityExistStrict(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        Object entityBean2 = SqlBoxContextUtils.entityLoadByIdTry(ctx, entityBean.getClass(), entityBean, optionItems);
        if (entityBean2 == null) {
            return false;
        }
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityBean.getClass());
        }
        return StrUtils.isEmpty(SqlBoxContextUtils.entityCompare(entityBean, entityBean2, model));
    }

    public static boolean entityExist(SqlBoxContext ctx, Object entityBean, Object ... optionItems) {
        return SqlBoxContextUtils.entityExistById(ctx, entityBean.getClass(), entityBean, optionItems);
    }

    public static boolean entityExistById(SqlBoxContext ctx, Class<?> entityClass, Object id, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityExistById(paramCtx, entityClass, id, newParams);
        }
        Object bean = SqlBoxContextUtils.buildBeanById(ctx, entityClass, id, optionItems);
        boolean result = SqlBoxContextUtils.doEntityExistById(ctx, entityClass, bean, optionItems);
        if (result && ctx.isGtxOpen() && !(id instanceof GtxTag)) {
            GtxUtils.reg(ctx, bean, "EXISTID");
        }
        return result;
    }

    private static boolean doEntityExistById(SqlBoxContext ctx, Class<?> entityClass, Object id, Object ... optionItems) {
        long result;
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityExistById(paramCtx, entityClass, id, newParams);
        }
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = null;
        if (id instanceof TailType && (tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems)) != null) {
            for (String colName : ((TailType)id).tails().keySet()) {
                ColumnModel col = tailModel.getColumnByColName(colName);
                if (col == null) continue;
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        LinkArrayList<Object> sqlWhere = new LinkArrayList<Object>();
        SqlItem shardTableItem = null;
        SqlItem shardDbItem = null;
        for (ColumnModel col : cols.values()) {
            if (col.getTransientable().booleanValue()) continue;
            if (col.getPkey().booleanValue()) {
                Object value = EntityIdUtils.readFeidlValueFromEntityId(id, col);
                if (!sqlWhere.isEmpty()) {
                    sqlWhere.append(" and ");
                }
                sqlWhere.append(JDBPRO.param(value));
                sqlWhere.append(col.getColumnName()).append("=? ");
            }
            if (col.getShardTable() != null) {
                shardTableItem = JSQLBOX.shardTB(EntityIdUtils.readFeidlValueFromEntityId(id, col));
            }
            if (col.getShardDatabase() == null) continue;
            shardDbItem = JSQLBOX.shardDB(EntityIdUtils.readFeidlValueFromEntityId(id, col));
        }
        if (sqlWhere.isEmpty()) {
            throw new SqlBoxException("No primary key found for entityBean");
        }
        sqlBody.append("select count(1) from ");
        if (shardTableItem != null) {
            sqlBody.append(shardTableItem);
        } else {
            sqlBody.append(tableName);
        }
        if (shardDbItem != null) {
            sqlBody.append(shardDbItem);
        }
        sqlBody.append(" where ").addAll(sqlWhere);
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        if ((result = ctx.iQueryForLongValue(sqlBody.toObjectArray())) == 1L) {
            return true;
        }
        if (result == 0L) {
            return false;
        }
        throw new SqlBoxException("Fail to check entity exist because found " + result + " rows record in database");
    }

    public static int entityCountAll(SqlBoxContext ctx, Class<?> entityClass, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityCountAll(paramCtx, entityClass, newParams);
        }
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems);
        if (tailModel != null) {
            for (ColumnModel col : tailModel.getColumns()) {
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        for (ColumnModel col : cols.values()) {
            if (col.getTransientable().booleanValue() || col.getShardTable() == null) continue;
            throw new SqlBoxException("Fail to count all entity because shardTable column " + col.getColumnName() + " exist.");
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        sqlBody.append("select count(1) from ").append(tableName);
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        return ctx.iQueryForIntValue(sqlBody.toObjectArray());
    }

    public static <T> List<T> entityFindAll(SqlBoxContext ctx, Class<T> entityClass, Object ... optionItems) {
        SqlBoxContext paramCtx = SqlBoxContextUtils.extractCtx(optionItems);
        if (paramCtx != null) {
            Object[] newParams = SqlBoxContextUtils.cleanUpParam(optionItems);
            return SqlBoxContextUtils.entityFindAll(paramCtx, entityClass, newParams);
        }
        TableModel optionModel = SqlBoxContextUtils.findFirstModel(optionItems);
        TableModel model = optionModel;
        if (model == null) {
            model = SqlBoxContextUtils.findEntityOrClassTableModel(entityClass);
        }
        HashMap<String, ColumnModel> cols = new HashMap<String, ColumnModel>();
        for (ColumnModel col : model.getColumns()) {
            cols.put(col.getColumnName().toLowerCase(), col);
        }
        TableModel tailModel = null;
        tailModel = SqlBoxContextUtils.findTailModel(ctx, model, optionItems);
        if (tailModel != null) {
            for (ColumnModel col : tailModel.getColumns()) {
                cols.put(col.getColumnName().toLowerCase(), col);
            }
        }
        String tableName = model.getTableName();
        if (tailModel != null) {
            tableName = tailModel.getTableName();
        }
        LinkArrayList<Object> sqlBody = new LinkArrayList<Object>();
        ArrayList<ColumnModel> effectColumns = new ArrayList<ColumnModel>();
        for (ColumnModel col : cols.values()) {
            if (col.getTransientable().booleanValue()) continue;
            if (col.getShardTable() != null) {
                throw new SqlBoxException("Fail to load all entity because ShardTable columns exist.");
            }
            sqlBody.append(col.getColumnName()).append(", ");
            effectColumns.add(col);
        }
        sqlBody.remove(sqlBody.size() - 1);
        sqlBody.frontAdd("select ").append(" from ");
        sqlBody.append(tableName);
        if (optionItems != null) {
            for (Object item : optionItems) {
                sqlBody.append(item);
            }
        }
        if (optionModel == null) {
            sqlBody.frontAdd(model);
        }
        sqlBody.append(SingleTonHandlers.arrayListHandler);
        List valuesList = (List)ctx.iQuery(sqlBody.toObjectArray());
        ArrayList<T> result = new ArrayList<T>();
        if (valuesList == null || valuesList.isEmpty()) {
            return result;
        }
        for (Object[] values : valuesList) {
            T bean = SqlBoxContextUtils.entityOrClassToBean(entityClass);
            for (int i = 0; i < effectColumns.size(); ++i) {
                SqlBoxContextUtils.writeValueToBeanFieldOrTail((ColumnModel)effectColumns.get(i), bean, values[i]);
            }
            result.add(bean);
        }
        return result;
    }

    public static <T> List<T> entityFindBySample(SqlBoxContext ctx, Object sampleBean, Object ... sqlItems) {
        return SqlBoxContextUtils.entityFindAll(ctx, sampleBean.getClass(), new SampleItem(sampleBean).sql(" where ").notNullFields(), sqlItems);
    }

    private static void ormQueryMethods___________________________________() {
    }

    public static EntityNet entityAutoNet(SqlBoxContext ctx, Class<?> ... entityClasses) {
        TableModel[] models = SqlBoxContextUtils.findAllModels(entityClasses);
        PreparedSQL ps = ctx.iPrepare(new Object[]{SqlOption.QUERY, new EntityNetHandler(), models, JSQLBOX.AUTO_SQL});
        SqlBoxException.assureTrue(ps.getAliases() != null && ps.getAliases().length > 1, new String[0]);
        String firstAlias = ps.getAliases()[0];
        for (int i = 1; i < entityClasses.length; ++i) {
            ps.giveBoth(firstAlias, ps.getAliases()[i]);
        }
        return (EntityNet)ctx.runPreparedSQL(ps);
    }

    public static <E> E entityFindRelatedOne(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        List<E> list = SqlBoxContextUtils.entityFindRelatedList(ctx, entity, sqlItems);
        if (list.size() != 1) {
            throw new SqlBoxException("Expect 1 entity but found " + list.size() + " records");
        }
        return list.get(0);
    }

    public static <E> List<E> entityFindRelatedList(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        if (sqlItems.length == 0) {
            throw new SqlBoxException("Target entity class is required.");
        }
        for (Object item : sqlItems) {
            if (!(item instanceof EntityNet)) continue;
            return ((EntityNet)item).findRelatedList(ctx, entity, sqlItems);
        }
        SqlBoxException.assureNotNull(entity, new String[0]);
        TableModel[] models = SqlBoxContextUtils.findAllModels(sqlItems);
        Object[] modelsAlias = SqlBoxContextUtils.findModelAlias(sqlItems);
        Object[] notModelAlias = SqlBoxContextUtils.findNotModelAlias(sqlItems);
        EntityNet net = (EntityNet)ctx.iQuery(new Object[]{SqlOption.QUERY, new EntityNetHandler(), modelsAlias, JSQLBOX.AUTO_SQL, " where ", new EntityKeyItem(entity), notModelAlias});
        return net.pickEntityList(models[models.length - 1].getEntityClass());
    }

    public static <E> Set<E> entityFindRelatedSet(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        if (sqlItems.length == 0) {
            throw new SqlBoxException("Target entity class is required");
        }
        for (Object item : sqlItems) {
            if (!(item instanceof EntityNet)) continue;
            return ((EntityNet)item).findRelatedSet(ctx, entity, sqlItems);
        }
        TableModel[] models = SqlBoxContextUtils.findAllModels(sqlItems);
        Object[] modelsAlias = SqlBoxContextUtils.findModelAlias(sqlItems);
        Object[] notModelAlias = SqlBoxContextUtils.findNotModelAlias(sqlItems);
        EntityNet net = (EntityNet)ctx.iQuery(new Object[]{SqlOption.QUERY, new EntityNetHandler(), modelsAlias, JSQLBOX.AUTO_SQL, " where ", new EntityKeyItem(entity), notModelAlias});
        return net.pickEntitySet(models[models.length - 1].getEntityClass());
    }

    public static <E> Map<Object, E> entityFindRelatedMap(SqlBoxContext ctx, Object entity, Object ... sqlItems) {
        if (sqlItems.length == 0) {
            throw new SqlBoxException("Target entity class is required");
        }
        for (Object item : sqlItems) {
            if (!(item instanceof EntityNet)) continue;
            return ((EntityNet)item).findRelatedMap(ctx, entity, sqlItems);
        }
        TableModel[] models = SqlBoxContextUtils.findAllModels(sqlItems);
        Object[] modelsAlias = SqlBoxContextUtils.findModelAlias(sqlItems);
        Object[] notModelAlias = SqlBoxContextUtils.findNotModelAlias(sqlItems);
        EntityNet net = (EntityNet)ctx.iQuery(new Object[]{SqlOption.QUERY, new EntityNetHandler(), modelsAlias, JSQLBOX.AUTO_SQL, " where ", new EntityKeyItem(entity), notModelAlias});
        return net.pickEntityMap(models[models.length - 1].getEntityClass());
    }
}

