/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.gtx;

import com.github.drinkjava2.jsqlbox.gtx.GtxConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class GtxAOP
implements MethodInterceptor {
    private GtxConnectionManager cm;
    private int transactionIsolation = 2;

    public GtxAOP() {
    }

    public GtxAOP(GtxConnectionManager cm) {
        this.cm = cm;
    }

    public GtxAOP(GtxConnectionManager cm, Integer transactionIsolation) {
        this.cm = cm;
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public Object invoke(MethodInvocation caller) throws Throwable {
        if (this.cm.isInTransaction()) {
            return caller.proceed();
        }
        Object invokeResult = null;
        try {
            this.cm.startTransaction(this.transactionIsolation);
            invokeResult = caller.proceed();
            this.cm.commitTransaction();
        }
        catch (Throwable t) {
            this.cm.rollbackTransaction();
            throw new TransactionsException("GroupTx found a runtime Exception, transaction rollbacked.", t);
        }
        return invokeResult;
    }
}

