/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.gtx;

import com.github.drinkjava2.jdbpro.JDBPRO;
import com.github.drinkjava2.jdbpro.log.DbProLog;
import com.github.drinkjava2.jdbpro.log.DbProLogFactory;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.Tail;
import com.github.drinkjava2.jsqlbox.gtx.GtxConnectionManager;
import com.github.drinkjava2.jsqlbox.gtx.GtxId;
import com.github.drinkjava2.jsqlbox.gtx.GtxTag;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxResult;
import com.github.drinkjava2.jtransactions.manual.ManualTxConnectionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ColumnListHandler;

public abstract class GtxUnlockServ {
    protected static final DbProLog logger = DbProLogFactory.getLog(GtxUnlockServ.class);
    private static final Map<String, String> gtxIdCache = new HashMap<String, String>();
    private static SqlBoxContext lockCtx;
    private static SqlBoxContext[] ctxs;

    private static void initContext(SqlBoxContext userCtx) {
        GtxConnectionManager lockCM = (GtxConnectionManager)userCtx.getConnectionManager();
        lockCtx = lockCM.getLockCtx();
        System.out.println("lcokCtx.master:" + lockCtx.getMasters());
        ctxs = new SqlBoxContext[userCtx.getMasters().length];
        for (int i = 0; i < userCtx.getMasters().length; ++i) {
            SqlBoxContext userCtxArr = (SqlBoxContext)userCtx.getMasters()[i];
            GtxUnlockServ.ctxs[i] = new SqlBoxContext(userCtxArr.getDataSource());
            ctxs[i].setName(userCtxArr.getName());
            ctxs[i].setConnectionManager(new ManualTxConnectionManager());
            ctxs[i].setDbCode(userCtxArr.getDbCode());
            ctxs[i].setDialect(userCtxArr.getDialect());
            ctxs[i].setShardingTools(userCtxArr.getShardingTools());
            ctxs[i].setAllowShowSQL(userCtxArr.getAllowShowSQL());
            ctxs[i].setMasters(ctxs);
        }
        gtxIdCache.clear();
    }

    public static void start(SqlBoxContext ctx, long intervalSecond, long maxLoopTimes) {
        GtxUnlockServ.initContext(ctx);
        long loop = 0L;
        Integer lockDb = null;
        do {
            SqlBoxContext locker = lockCtx;
            if (lockCtx.getMasters() != null) {
                if (lockDb == null) {
                    lockDb = 0;
                }
                locker = (SqlBoxContext)lockCtx.getMasters()[lockDb];
                Integer n = lockDb;
                Integer n2 = lockDb = Integer.valueOf(lockDb + 1);
                if (lockDb >= lockCtx.getMasters().length) {
                    lockDb = 0;
                }
            }
            List<GtxId> gtxIdList = locker.eFindAll(GtxId.class, new Object[0]);
            for (GtxId gtxId : gtxIdList) {
                String id = gtxId.getGid();
                if (gtxIdCache.containsKey(id)) {
                    if (!"LOADED".equals(gtxIdCache.get(id))) continue;
                    gtxIdCache.put(id, "TRY UNLOCK");
                    try {
                        if (GtxUnlockServ.unlockOne(lockDb, id)) {
                            gtxIdCache.remove(id);
                            logger.info("Unlocked success for gtxid:" + id);
                            continue;
                        }
                        gtxIdCache.put(id, "UNLOCK FAIL");
                        logger.info("Unlock fail for gtxid:" + id);
                    }
                    catch (Exception e) {
                        gtxIdCache.put(id, "UNLOCK FAIL");
                        logger.warn("Unlock fail exception, for gtxid:" + id, e);
                    }
                    continue;
                }
                gtxIdCache.put(id, "LOADED");
            }
            try {
                Thread.sleep(intervalSecond * 1000L);
            }
            catch (InterruptedException e) {
                throw new TransactionsException(e);
            }
            if (++loop <= Long.MAX_VALUE) continue;
            loop = 0L;
        } while (maxLoopTimes <= 0L || loop < maxLoopTimes);
    }

    public static boolean forceUnlock(SqlBoxContext ctx, String gtxId) {
        return GtxUnlockServ.forceUnlock(null, ctx, gtxId);
    }

    public static boolean forceUnlock(Integer locker, SqlBoxContext ctx, String gtxId) {
        GtxUnlockServ.initContext(ctx);
        return GtxUnlockServ.unlockOne(locker, gtxId);
    }

    public static boolean forceUnlock(SqlBoxContext ctx, TxResult txResult) {
        return GtxUnlockServ.forceUnlock(null, ctx, txResult);
    }

    public static boolean forceUnlock(Integer locker, SqlBoxContext ctx, TxResult txResult) {
        GtxUnlockServ.initContext(ctx);
        try {
            return GtxUnlockServ.unlockOne(locker, txResult.getGid());
        }
        catch (Exception e) {
            logger.error("forceUnlock fail, ", e);
            return false;
        }
    }

    private static boolean unlockOne(Integer lockNo, String gid) {
        SqlBoxContext locker = lockCtx;
        if (lockNo != null) {
            locker = (SqlBoxContext)lockCtx.getMasters()[lockNo];
        }
        GtxId lockGid = null;
        lockGid = locker.eLoadByIdTry(GtxId.class, gid, new Object[0]);
        if (lockGid == null) {
            logger.error("Can not access lock server:" + lockNo);
            return false;
        }
        List dbLstLst = (List)locker.iExecute("select distinct(db) from gtxlock where gid=?", JDBPRO.param(gid), new ColumnListHandler());
        List dbList = (List)dbLstLst.get(0);
        for (Integer db : dbList) {
            GtxUnlockServ.executeUndo(lockNo, db, gid);
        }
        locker.eDeleteById(GtxId.class, gid, new Object[0]);
        return true;
    }

    private static void executeUndo(Integer lockNo, Integer db, String gid) {
        String _gid;
        SqlBoxContext locker = lockCtx;
        if (lockNo != null) {
            locker = (SqlBoxContext)lockCtx.getMasters()[lockNo];
        }
        if (!gid.equals(_gid = ctxs[db].nQueryForString("select gid from gtxtag where gid=?", gid))) {
            return;
        }
        List tmp = (List)locker.iExecute("select distinct(entityTb) from gtxlock where gid=?", JDBPRO.param(gid), " and db=?", JDBPRO.param(db), new ColumnListHandler());
        List tbList = (List)tmp.get(0);
        ctxs[db].startTrans();
        try {
            for (String tb : tbList) {
                List oneRecord = locker.eFindBySQL(Tail.class, "select * from ", tb, " where gtxdb=?", JDBPRO.param(db), " and gtxid=?", JDBPRO.param(gid), " order by GTXLOGNO desc");
                for (Tail tail : oneRecord) {
                    GtxUnlockServ.undo(db, tb, tail);
                }
            }
            ctxs[db].eDelete(new GtxTag(gid), new Object[0]);
            ctxs[db].commitTrans();
        }
        catch (Exception e) {
            ctxs[db].rollbackTrans();
            throw new TransactionsException(e);
        }
    }

    private static void undo(Integer db, String tb, Tail tail) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String gtxtyp = (String)tail.getTail("gtxtype");
        String entityClassName = (String)tail.getTail("gtxentity");
        Class<?> entityClass = Class.forName(entityClassName);
        Object entity = GtxUnlockServ.tailToEntityBean(tail, entityClass);
        if ("INSERT".equals(gtxtyp)) {
            ctxs[db].eDelete(entity, new Object[0]);
        } else if ("DELETE".equals(gtxtyp)) {
            ctxs[db].eInsert(entity, new Object[0]);
        } else if ("AFTER".equals(gtxtyp)) {
            ctxs[db].eExistStrict(entity, new Object[0]);
        } else if ("BEFORE".equals(gtxtyp)) {
            ctxs[db].eUpdate(entity, new Object[0]);
        } else if ("EXISTID".equals(gtxtyp)) {
            ctxs[db].eExist(entity, new Object[0]);
        } else if ("EXSTRICT".equals(gtxtyp)) {
            ctxs[db].eExistStrict(entity, new Object[0]);
        }
    }

    private static Object tailToEntityBean(Tail tail, Class<?> entityClass) throws InstantiationException, IllegalAccessException {
        Object entity = entityClass.newInstance();
        TableModel model = TableModelUtils.entity2ReadOnlyModel(entityClass);
        for (ColumnModel col : model.getColumns()) {
            String fieldName = col.getEntityField();
            if (!tail.tails().containsKey(fieldName)) continue;
            SqlBoxContextUtils.writeValueToBeanFieldOrTail(col, entity, tail.getTail(fieldName));
        }
        return entity;
    }
}

