/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.sharding;

import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.util.Collection;
import java.util.HashSet;

public class ShardingModTool
implements ShardingTool {
    @Override
    public Integer[] handleShardTable(TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardTableColumn();
        if (col == null) {
            return null;
        }
        if (col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for table '" + model.getTableName() + "'");
        }
        if (!"MOD".equalsIgnoreCase(col.getShardTable()[0])) {
            return null;
        }
        String modNumber = col.getShardTable()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        SqlBoxException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new SqlBoxException("ShardTable key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new SqlBoxException("ShardTable key value can not be null");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        if (shardkey2 != null) {
            throw new SqlBoxException("ShardingModTool does not support shardBetween type method");
        }
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingModTool.calculateMod(key, modNumber));
            }
            return set.toArray(new Integer[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingModTool.calculateMod(key, modNumber));
            }
            return set.toArray(new Integer[set.size()]);
        }
        return new Integer[]{ShardingModTool.calculateMod(shardKey1, modNumber)};
    }

    @Override
    public Integer[] handleShardDatabase(TableModel model, Object ... shardkey) {
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null) {
            return null;
        }
        if (col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new SqlBoxException("Not found ShardDatabase setting for table '" + model.getTableName() + "'");
        }
        if (!"MOD".equalsIgnoreCase(col.getShardDatabase()[0])) {
            return null;
        }
        String modNumber = col.getShardDatabase()[1];
        Object shardKey1 = null;
        Object shardkey2 = null;
        Class<?> entityOrClass = model.getEntityClass();
        SqlBoxException.assureNotNull(entityOrClass, new String[0]);
        if (shardkey == null || shardkey.length == 0) {
            throw new SqlBoxException("ShardDatabase key parameter needed");
        }
        if (shardkey.length == 1) {
            shardKey1 = shardkey[0];
        } else {
            shardKey1 = shardkey[0];
            shardkey2 = shardkey[1];
        }
        if (shardKey1 == null) {
            throw new SqlBoxException("ShardDatabase key value can not be null, on table:" + col.getTableModel().getTableName() + ", column:" + col.getColumnName());
        }
        HashSet<Integer> set = new HashSet<Integer>();
        if (shardkey2 != null) {
            throw new SqlBoxException("ShardingModTool does not support shardBetween type method");
        }
        if (shardKey1 instanceof Collection) {
            for (Object key : (Collection)shardKey1) {
                set.add(ShardingModTool.calculateMod(key, modNumber));
            }
            return set.toArray(new Integer[set.size()]);
        }
        if (shardKey1.getClass().isArray()) {
            for (Object key : (Object[])shardKey1) {
                set.add(ShardingModTool.calculateMod(key, modNumber));
            }
            return set.toArray(new Integer[set.size()]);
        }
        return new Integer[]{ShardingModTool.calculateMod(shardKey1, modNumber)};
    }

    private static int calculateMod(Object keyValue, String modNumber) {
        long shardKeyValue = Long.parseLong(String.valueOf(keyValue));
        int mod = Integer.parseInt(modNumber);
        return (int)(shardKeyValue % (long)mod);
    }
}

