/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.grouptx;

import com.github.drinkjava2.jtransactions.DataSourceHolder;
import com.github.drinkjava2.jtransactions.ThreadConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxInfo;
import com.github.drinkjava2.jtransactions.TxResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;

public class GroupTxConnectionManager
extends ThreadConnectionManager {
    public static final GroupTxConnectionManager instance() {
        return InnerGroupTxMgr.INSTANCE;
    }

    @Override
    public Connection getConnection(Object dsOrHolder) throws SQLException {
        DataSource ds = dsOrHolder instanceof DataSource ? (DataSource)dsOrHolder : ((DataSourceHolder)dsOrHolder).getDataSource();
        TransactionsException.assureNotNull(ds, "DataSource can not be null");
        if (this.isInTransaction()) {
            TxInfo tx = this.getThreadTxInfo();
            Connection conn = tx.getConnectionCache().get(ds);
            if (conn == null) {
                conn = ds.getConnection();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(tx.getTxIsolationLevel());
                tx.getConnectionCache().put(ds, conn);
            }
            return conn;
        }
        return ds.getConnection();
    }

    @Override
    public TxResult commitTransaction() throws Exception {
        if (!this.isInTransaction()) {
            throw new TransactionsException("Transaction not opened, can not commit");
        }
        Collection<Connection> conns = this.getThreadTxInfo().getConnectionCache().values();
        for (Connection con : conns) {
            con.commit();
        }
        this.endTransaction(null);
        return TxResult.TX_SUCESS;
    }

    @Override
    public TxResult rollbackTransaction() {
        if (!this.isInTransaction()) {
            throw new TransactionsException("Transaction not opened, can not rollback");
        }
        SQLException lastExp = null;
        Collection<Connection> conns = this.getThreadTxInfo().getConnectionCache().values();
        for (Connection con : conns) {
            try {
                con.rollback();
            }
            catch (SQLException e) {
                if (lastExp != null) {
                    e.setNextException(lastExp);
                }
                lastExp = e;
            }
        }
        this.endTransaction(lastExp);
        return TxResult.TX_FAIL;
    }

    private void endTransaction(SQLException lastExp) {
        if (!this.isInTransaction()) {
            return;
        }
        Collection<Connection> conns = this.getThreadTxInfo().getConnectionCache().values();
        this.setThreadTxInfo(null);
        if (conns.isEmpty()) {
            return;
        }
        for (Connection con : conns) {
            if (con == null) continue;
            try {
                if (!con.getAutoCommit()) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                if (lastExp != null) {
                    e.setNextException(lastExp);
                }
                lastExp = e;
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                if (lastExp != null) {
                    e.setNextException(lastExp);
                }
                lastExp = e;
            }
        }
        conns.clear();
        if (lastExp != null) {
            throw new TransactionsException(lastExp);
        }
    }

    private static class InnerGroupTxMgr {
        private static final GroupTxConnectionManager INSTANCE = new GroupTxConnectionManager();

        private InnerGroupTxMgr() {
        }
    }
}

