/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.manual;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.DataSourceHolder;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxInfo;
import com.github.drinkjava2.jtransactions.TxResult;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class ManualTxConnectionManager
implements ConnectionManager {
    private TxInfo txInfo;

    @Override
    public boolean isInTransaction() {
        return this.txInfo != null;
    }

    @Override
    public void startTransaction() {
        if (this.isInTransaction()) {
            throw new TransactionsException("Transaction already started");
        }
        this.txInfo = new TxInfo();
    }

    @Override
    public void startTransaction(int txIsolationLevel) {
        if (this.isInTransaction()) {
            throw new TransactionsException("Transaction already started");
        }
        this.txInfo = new TxInfo(txIsolationLevel);
    }

    @Override
    public Connection getConnection(Object dsOrHolder) throws SQLException {
        DataSource ds = dsOrHolder instanceof DataSource ? (DataSource)dsOrHolder : ((DataSourceHolder)dsOrHolder).getDataSource();
        if (this.isInTransaction()) {
            if (this.txInfo.getConnection() == null) {
                Connection con = ds.getConnection();
                con.setAutoCommit(false);
                con.setTransactionIsolation(this.txInfo.getTxIsolationLevel());
                this.txInfo.setConnection(con);
            }
            return this.txInfo.getConnection();
        }
        return ds.getConnection();
    }

    @Override
    public void releaseConnection(Connection conn, Object dsOwner) throws SQLException {
        if (!this.isInTransaction() && conn != null) {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxResult commitTransaction() throws Exception {
        block7: {
            if (!this.isInTransaction()) {
                throw new TransactionsException("Transaction not opened, can not commit");
            }
            try {
                Connection con = this.txInfo.getConnection();
                if (con == null) {
                    TxResult txResult = TxResult.TX_SUCESS;
                    return txResult;
                }
                if (!con.getAutoCommit()) {
                    con.commit();
                    break block7;
                }
                throw new TransactionsException("Connection is auto commit status, can not commit");
            }
            finally {
                this.endTransaction();
            }
        }
        return TxResult.TX_SUCESS;
    }

    @Override
    public TxResult rollbackTransaction() {
        block9: {
            if (!this.isInTransaction()) {
                throw new TransactionsException("Transaction not opened, can not rollback");
            }
            try {
                Connection con = this.txInfo.getConnection();
                if (con == null) {
                    TxResult txResult = TxResult.TX_FAIL;
                    return txResult;
                }
                if (!con.getAutoCommit()) {
                    con.rollback();
                    break block9;
                }
                throw new TransactionsException("Connection is auto commit status, can not rollback");
            }
            catch (SQLException e) {
                throw new TransactionsException(e);
            }
            finally {
                this.endTransaction();
            }
        }
        return TxResult.TX_FAIL;
    }

    private void endTransaction() {
        if (!this.isInTransaction()) {
            return;
        }
        Connection con = this.txInfo.getConnection();
        try {
            if (con == null) {
                return;
            }
            if (!con.getAutoCommit()) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new TransactionsException("Fail to setAutoCommit to true", e);
        }
        finally {
            this.txInfo.setConnection(null);
            this.txInfo = null;
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    throw new TransactionsException("Fail to close connection", e);
                }
            }
        }
    }
}

